/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation.kernel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import gama.core.common.interfaces.IExperimentAgentCreator;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.model.GamlModelSpecies;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.population.IPopulation;
import gama.gaml.compilation.IAgentConstructor;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.PlatformSpeciesDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaGenericAgentType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GamaMetaModel {
    public static final GamaMetaModel INSTANCE = new GamaMetaModel();
    private final Map<String, IExperimentAgentCreator> experimentCreators = new HashMap<String, IExperimentAgentCreator>();
    private final Map<String, SpeciesProto> tempSpecies = new HashMap<String, SpeciesProto>();
    private final Multimap<String, String> speciesSkills = HashMultimap.create();
    private GamlModelSpecies abstractModelSpecies;
    private ISpecies abstractAgentSpecies;
    public volatile boolean isInitialized;
    private SpeciesDescription agent;
    private ModelDescription model;
    private ExperimentDescription experiment;
    private PlatformSpeciesDescription platform;

    public static SpeciesDescription getAgentSpeciesDescription() {
        return GamaMetaModel.INSTANCE.agent;
    }

    public static SpeciesDescription getModelDescription() {
        return GamaMetaModel.INSTANCE.model;
    }

    public static SpeciesDescription getExperimentDescription() {
        return GamaMetaModel.INSTANCE.experiment;
    }

    public static PlatformSpeciesDescription getPlatformSpeciesDescription() {
        return GamaMetaModel.INSTANCE.platform;
    }

    private GamaMetaModel() {
    }

    public ExperimentAgent createExperimentAgent(String string, IPopulation iPopulation, int n) {
        return (ExperimentAgent)this.experimentCreators.get(string).create(iPopulation, n);
    }

    public void addExperimentAgentCreator(String string, IExperimentAgentCreator iExperimentAgentCreator) {
        this.experimentCreators.put(string, iExperimentAgentCreator);
    }

    public void addSpecies(String string, Class clazz, IAgentConstructor iAgentConstructor, String[] stringArray) {
        SpeciesProto speciesProto = new SpeciesProto(string, clazz, iAgentConstructor, stringArray);
        this.tempSpecies.put(string, speciesProto);
    }

    public void build() {
        SpeciesProto speciesProto = this.tempSpecies.remove("agent");
        this.agent = this.buildSpecies(speciesProto, null, null, false, false);
        ((GamaGenericAgentType)Types.builtInTypes.get("agent")).setSpecies(this.agent);
        SpeciesProto speciesProto2 = this.tempSpecies.remove("model");
        this.model = (ModelDescription)this.buildSpecies(speciesProto2, null, this.agent, true, false);
        this.agent.setEnclosingDescription(this.model);
        this.model.addChild(this.agent);
        SpeciesProto speciesProto3 = this.tempSpecies.remove("experiment");
        this.experiment = (ExperimentDescription)this.buildSpecies(speciesProto3, null, this.agent, false, true);
        this.experiment.finalizeDescription();
        this.model.addChild(this.experiment);
        for (SpeciesProto speciesProto4 : this.tempSpecies.values()) {
            this.model.addChild(this.buildSpecies(speciesProto4, this.model, this.agent, SimulationAgent.class.isAssignableFrom(speciesProto4.clazz), false));
        }
        this.tempSpecies.clear();
        this.model.buildTypes();
        this.model.finalizeDescription();
        this.isInitialized = true;
    }

    public SpeciesDescription buildSpecies(SpeciesProto speciesProto, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, boolean bl, boolean bl2) {
        SpeciesDescription speciesDescription3;
        Class clazz = speciesProto.clazz;
        String string = speciesProto.name;
        IAgentConstructor iAgentConstructor = speciesProto.helper;
        String[] stringArray = speciesProto.skills;
        String string2 = speciesProto.plugin;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        hashSet.addAll(this.speciesSkills.get((Object)string));
        if ("platform".equals(speciesProto.name)) {
            speciesDescription3 = DescriptionFactory.createPlatformSpeciesDescription(string, clazz, speciesDescription, speciesDescription2, iAgentConstructor, hashSet, string2);
            this.platform = (PlatformSpeciesDescription)speciesDescription3;
        } else {
            speciesDescription3 = !bl ? (bl2 ? DescriptionFactory.createBuiltInExperimentDescription(string, clazz, speciesDescription, speciesDescription2, iAgentConstructor, hashSet, string2) : DescriptionFactory.createBuiltInSpeciesDescription(string, clazz, speciesDescription, speciesDescription2, iAgentConstructor, hashSet, string2)) : DescriptionFactory.createRootModelDescription(string, clazz, speciesDescription, speciesDescription2, iAgentConstructor, hashSet, string2);
        }
        speciesDescription3.copyJavaAdditions();
        speciesDescription3.inheritFromParent();
        return speciesDescription3;
    }

    public void addSpeciesSkill(String string, String string2) {
        this.speciesSkills.put((Object)string, (Object)string2);
    }

    public GamlModelSpecies getAbstractModelSpecies() {
        if (this.abstractModelSpecies == null) {
            this.abstractModelSpecies = (GamlModelSpecies)GamaMetaModel.getModelDescription().compile();
        }
        return this.abstractModelSpecies;
    }

    public ISpecies getAbstractAgentSpecies() {
        if (this.abstractAgentSpecies == null) {
            this.abstractAgentSpecies = (ISpecies)GamaMetaModel.getAgentSpeciesDescription().compile();
        }
        return this.abstractAgentSpecies;
    }

    public Set<String> getExperimentTypes() {
        return this.experimentCreators.keySet();
    }

    public Class<? extends IExperimentAgent> getJavaBaseFor(String string) {
        IExperimentAgentCreator iExperimentAgentCreator = this.experimentCreators.get(string);
        if (!(iExperimentAgentCreator instanceof IExperimentAgentCreator.ExperimentAgentDescription)) {
            return ExperimentAgent.class;
        }
        IExperimentAgentCreator.ExperimentAgentDescription experimentAgentDescription = (IExperimentAgentCreator.ExperimentAgentDescription)iExperimentAgentCreator;
        return (Class)experimentAgentDescription.getJavaBase();
    }

    public IExperimentAgentCreator getExperimentCreator(String string) {
        return this.experimentCreators.get(string);
    }

    private static class SpeciesProto {
        final String name;
        final String plugin = GamaBundleLoader.CURRENT_PLUGIN_NAME;
        final Class clazz;
        final IAgentConstructor helper;
        final String[] skills;

        public SpeciesProto(String string, Class clazz, IAgentConstructor iAgentConstructor, String[] stringArray) {
            this.name = string;
            this.clazz = clazz;
            this.helper = iAgentConstructor;
            this.skills = stringArray;
        }
    }
}

