/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.ImmutableSet;
import gama.annotations.precompiler.GamlAnnotations;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Set;

public class FacetProto
implements IGamlDescription,
Comparable<FacetProto> {
    public final String name;
    public String deprecated = null;
    public final IType<?>[] types;
    public final int[] typesDescribers;
    public final IType<?> contentType;
    public final IType<?> keyType;
    public final boolean optional;
    public final boolean internal;
    private final boolean isLabel;
    private final boolean isId;
    final boolean isRemote;
    final boolean isNewTemp;
    boolean docBuilt;
    public final Set<String> values;
    public String doc = "No documentation yet";
    public String owner;
    public Class<?> support;

    public FacetProto(String string, int[] nArray, int n, int n2, String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        this.name = string;
        this.typesDescribers = nArray;
        this.isNewTemp = this.typesDescribers[0] == -204;
        this.types = new IType[nArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            this.types[n3] = Types.get(nArray[n3]);
            ++n3;
        }
        this.contentType = Types.get(n);
        this.keyType = Types.get(n2);
        this.optional = bl;
        this.internal = bl2;
        this.isRemote = bl3;
        this.isLabel = SymbolProto.ids.contains(nArray[0]);
        this.isId = this.isLabel && nArray[0] != -200;
        this.values = stringArray.length == 0 ? null : ImmutableSet.copyOf((Object[])stringArray);
    }

    boolean isLabel() {
        return this.isLabel;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    @Override
    public String getDefiningPlugin() {
        return null;
    }

    public boolean isId() {
        return this.isId;
    }

    @Override
    public String getTitle() {
        String string = this.owner == null ? "" : " of " + this.owner;
        return "Facet " + this.name + string;
    }

    public String typesToString() {
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(this.types.length < 2 ? " " : " any type in [");
        int n = 0;
        while (n < this.types.length) {
            switch (this.typesDescribers[n]) {
                case -201: {
                    stringBuilder.append("an identifier");
                    break;
                }
                case -200: {
                    stringBuilder.append("a label");
                    break;
                }
                case -204: 
                case -203: {
                    stringBuilder.append("a new identifier");
                    break;
                }
                case -202: {
                    stringBuilder.append("a datatype identifier");
                    break;
                }
                case 0: {
                    stringBuilder.append("any type");
                    break;
                }
                default: {
                    stringBuilder.append(this.types[n]);
                }
            }
            if (n != this.types.length - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        if (this.types.length >= 2) {
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        IGamlDescription.RegularDoc regularDoc = new IGamlDescription.RegularDoc();
        regularDoc.append(this.getDeprecated() != null ? "Deprecated" : (this.optional ? "Optional" : "Required")).append(", expects ").append(this.typesToString());
        if (this.values != null && this.values.size() > 0) {
            regularDoc.append(", takes values in ").append(this.values.toString()).append(". ");
        }
        if (this.getDoc() != null && this.getDoc().length() > 0) {
            regularDoc.append(" - ").append(this.getDoc());
        }
        if (this.getDeprecated() != null) {
            regularDoc.append(" <b>[");
            regularDoc.append(this.getDeprecated());
            regularDoc.append("]</b>");
        }
        return regularDoc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public int compareTo(FacetProto facetProto) {
        return this.getName().compareTo(facetProto.getName());
    }

    @Override
    public String serializeToGaml(boolean bl) {
        if (this.getDeprecated() != null || SymbolSerializer.uselessFacets.contains(this.name)) {
            return "";
        }
        return this.name + (this.optional ? ": optional" : ": required") + " (" + (this.types.length < 2 ? this.typesToString().substring(1) : this.typesToString()) + ")";
    }

    public void buildDoc() {
        if (this.docBuilt) {
            return;
        }
        this.docBuilt = true;
        GamlAnnotations.facets facets2 = this.support.getAnnotation(GamlAnnotations.facets.class);
        if (facets2 != null) {
            GamlAnnotations.facet[] facetArray;
            GamlAnnotations.facet[] facetArray2 = facetArray = facets2.value();
            int n = facetArray.length;
            int n2 = 0;
            while (n2 < n) {
                GamlAnnotations.doc[] docArray;
                GamlAnnotations.facet facet2 = facetArray2[n2];
                if (this.name.equals(facet2.name()) && (docArray = facet2.doc()) != null && docArray.length > 0) {
                    GamlAnnotations.doc doc2 = docArray[0];
                    this.doc = doc2.value();
                    this.deprecated = doc2.deprecated();
                    if (this.deprecated != null && this.deprecated.length() == 0) {
                        this.deprecated = null;
                    }
                }
                ++n2;
            }
        }
        if (this.doc == null) {
            this.doc = "Not documented";
        }
    }

    public void setClass(Class clazz) {
        this.support = clazz;
    }

    public String getDoc() {
        this.buildDoc();
        return this.doc;
    }

    public String getDeprecated() {
        this.buildDoc();
        return this.deprecated;
    }
}

