/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.sobol;

import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.operators.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.moeaframework.util.sequence.Saltelli;

public class Sobol {
    private double[][] saltelli;
    private int sample;
    private int _sample;
    protected int _resample = 1000;
    private Map<String, List<Object>> problem;
    private final Map<String, List<Object>> parameters;
    private final List<String> output_names;
    private Map<String, List<Object>> outputs;
    private final Map<String, Map<String, List<Double>>> sobol_analysis = new HashMap<String, Map<String, List<Double>>>();
    private final IScope scope;

    public Sobol(LinkedHashMap<String, List<Object>> linkedHashMap, List<String> list, int n, IScope iScope) {
        this.scope = iScope;
        this.problem = linkedHashMap;
        this.parameters = new LinkedHashMap<String, List<Object>>();
        linkedHashMap.keySet().stream().forEach(string -> {
            ArrayList arrayList = this.parameters.put((String)string, new ArrayList());
        });
        this.output_names = list;
        this.outputs = new HashMap<String, List<Object>>();
        this.sample = n;
        this._sample = n * (2 * this.parameters.size() + 2);
    }

    public Sobol(File file2, int n, IScope iScope) throws GamaRuntimeException {
        this.scope = iScope;
        this.parameters = new LinkedHashMap<String, List<Object>>();
        this.output_names = new ArrayList<String>();
        this.outputs = new HashMap<String, List<Object>>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));){
                String string = bufferedReader.readLine();
                String[] stringArray = string.split(",");
                int n2 = 0;
                while (n2 < n) {
                    this.parameters.put(stringArray[n2], new ArrayList());
                    ++n2;
                }
                n2 = n;
                while (n2 < stringArray.length) {
                    this.output_names.add(stringArray[n2]);
                    this.outputs.put(stringArray[n2], new ArrayList());
                    ++n2;
                }
                this._sample = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    ++this._sample;
                    String[] stringArray2 = string.split(",");
                    int n3 = 0;
                    while (n3 < n) {
                        this.parameters.get(stringArray[n3]).add(Double.parseDouble(stringArray2[n3]));
                        ++n3;
                    }
                    n3 = n;
                    while (n3 < stringArray.length) {
                        this.outputs.get(stringArray[n3]).add(Double.parseDouble(stringArray2[n3]));
                        ++n3;
                    }
                }
                if (this._sample % (2 * n + 2) != 0) {
                    throw new IllegalArgumentException("Number of sample in the file doesn't match the number of parameters");
                }
                this.sample = this._sample / (2 * n + 2);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error("File " + file2.toString() + " not found", iScope);
        }
        catch (OutOfRangeException outOfRangeException) {
            throw GamaRuntimeException.error("The number of parameters provided doesn't match the number of parameters in the file", iScope);
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error(exception.toString(), iScope);
        }
    }

    public void setRandomSaltelliSampling() {
        this.saltelli = new Saltelli().generate(this._sample, this.parameters.size());
        this.sample();
    }

    public void setSaltelliSamplingFromCsv(File file2) {
        this.parseSaltelli(file2);
        this.sample();
    }

    public void saveSaltelliSample(File file2) throws GamaRuntimeException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileWriter fileWriter = new FileWriter(file2, false);){
                fileWriter.write(this.buildSaltelliReport());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error("File " + file2.toString() + " not found", this.scope);
        }
    }

    public Map<String, List<Object>> getParametersValues() {
        return this.parameters;
    }

    public void setOutputs(Map<String, List<Object>> map) {
        for (String string : map.keySet()) {
            if (map.get(string).size() == this._sample) continue;
            throw GamaRuntimeException.error("This size of the output " + string + " doesn't match the number of samples in the parameters", this.scope);
        }
        this.outputs = map;
    }

    public Map<String, Map<String, List<Double>>> evaluate() {
        if (this.outputs.isEmpty()) {
            System.err.println("no output porivded call setOutputs before calling evaluate");
        }
        double[] dArray = new double[this.sample];
        double[] dArray2 = new double[this.sample];
        double[][] dArray3 = new double[this.sample][this.parameters.size()];
        for (String string : this.outputs.keySet()) {
            Iterator<Object> iterator = this.outputs.get(string).iterator();
            HashMap hashMap = new HashMap();
            int n = 0;
            while (n < this.sample) {
                dArray[n] = Double.parseDouble(iterator.next().toString());
                int n2 = 0;
                while (n2 < this.parameters.size()) {
                    dArray3[n][n2] = Double.parseDouble(iterator.next().toString());
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.parameters.size()) {
                    iterator.next();
                    ++n2;
                }
                dArray2[n] = Double.parseDouble(iterator.next().toString());
                ++n;
            }
            n = 0;
            for (String string2 : this.parameters.keySet()) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                double[] dArray4 = new double[this.sample];
                double[] dArray5 = new double[this.sample];
                double[] dArray6 = new double[this.sample];
                int n3 = 0;
                while (n3 < this.sample) {
                    dArray4[n3] = dArray[n3];
                    dArray5[n3] = dArray3[n3][n];
                    dArray6[n3] = dArray2[n3];
                    ++n3;
                }
                arrayList.add(this.computeFirstOrder(dArray4, dArray5, dArray6, this.sample));
                arrayList.add(this.computeFirstOrderConfidence(dArray4, dArray5, dArray6, this.sample, this._resample));
                arrayList.add(this.computeTotalOrder(dArray4, dArray5, dArray6, this.sample));
                arrayList.add(this.computeTotalOrderConfidence(dArray4, dArray5, dArray6, this.sample, this._resample));
                hashMap.put(string2, arrayList);
                ++n;
            }
            this.sobol_analysis.put(string, hashMap);
        }
        return this.sobol_analysis;
    }

    public void saveResult(File file2) throws GamaRuntimeException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileWriter fileWriter = new FileWriter(file2, false);){
                fileWriter.write(this.buildReportString(FileNameUtils.getExtension((String)file2.getPath())));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error("File " + file2.toString() + " not found", this.scope);
        }
    }

    private void sample() {
        int n = 0;
        while (n < this._sample) {
            int n2 = 0;
            for (String string : this.parameters.keySet()) {
                this.roll(string, this.saltelli[n][n2], this.problem.get(string));
                ++n2;
            }
            ++n;
        }
    }

    public String buildReportString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = ',';
        if ("txt".equalsIgnoreCase(string)) {
            stringBuilder.append("SOBOL ANALYSIS:\n");
            for (String string2 : this.sobol_analysis.keySet()) {
                stringBuilder.append("##############################\n");
                stringBuilder.append("output variable : " + string2).append(Strings.LN);
                stringBuilder.append("-------------------").append(Strings.LN);
                for (String string3 : this.sobol_analysis.get(string2).keySet()) {
                    stringBuilder.append(string3 + " : \n");
                    stringBuilder.append("first order : ");
                    stringBuilder.append(this.sobol_analysis.get(string2).get(string3).get(0)).append(Strings.LN);
                    stringBuilder.append("first order confidence : ");
                    stringBuilder.append(this.sobol_analysis.get(string2).get(string3).get(1)).append(Strings.LN);
                    stringBuilder.append("Total order : ");
                    stringBuilder.append(this.sobol_analysis.get(string2).get(string3).get(2)).append(Strings.LN);
                    stringBuilder.append("Total order confidence : ");
                    stringBuilder.append(this.sobol_analysis.get(string2).get(string3).get(3)).append(Strings.LN);
                    stringBuilder.append("-------------------").append(Strings.LN);
                }
            }
        } else {
            stringBuilder.append("output").append(c);
            stringBuilder.append("parameter").append(c);
            stringBuilder.append("first order").append(c);
            stringBuilder.append("first order confidence").append(c);
            stringBuilder.append("Total order").append(c);
            stringBuilder.append("Total order confidence").append(Strings.LN);
            for (String string4 : this.sobol_analysis.keySet()) {
                for (String string5 : this.sobol_analysis.get(string4).keySet()) {
                    stringBuilder.append(string4).append(c);
                    stringBuilder.append(string5);
                    for (Double d : this.sobol_analysis.get(string4).get(string5)) {
                        stringBuilder.append(c).append(d);
                    }
                    stringBuilder.append(Strings.LN);
                }
            }
        }
        return stringBuilder.toString();
    }

    private String buildSaltelliReport() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this._sample) {
            int n2 = 0;
            while (n2 < this.parameters.size()) {
                stringBuilder.append(this.saltelli[n][n2]);
                if (n2 != this.parameters.size() - 1) {
                    stringBuilder.append(", ");
                }
                ++n2;
            }
            if (n != this._sample - 1) {
                stringBuilder.append(System.lineSeparator());
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private void parseSaltelli(File file2) throws GamaRuntimeException {
        this.saltelli = new double[this._sample][this.parameters.size()];
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));){
                String string;
                int n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(",");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        this.saltelli[n][n2] = Double.parseDouble(stringArray[n2]);
                        ++n2;
                    }
                    ++n;
                }
                bufferedReader.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error("File " + file2.toString() + "not found", this.scope);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw GamaRuntimeException.error("Format of the provided saltelli file doesn't match to the number of sample or number of variable of the experiment", this.scope);
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error(exception.toString(), this.scope);
        }
    }

    private void roll(String string, Double d, List<Object> list) {
        Object object = null;
        if (list.stream().allMatch(Double.class::isInstance)) {
            Double d2 = (Double)list.get(0);
            Double d3 = (Double)list.get(1);
            object = d2 + d * (d3 - d2);
        } else if (list.stream().allMatch(Integer.class::isInstance)) {
            int n = (Integer)list.get(0);
            int n2 = (Integer)list.get(1);
            object = (int)Math.floor((double)n + d * (double)(n2 - n));
        } else if (list.stream().allMatch(Boolean.class::isInstance)) {
            object = d > 0.5;
        } else if (list.size() > 2) {
            int n = (int)Math.floor(d * (double)list.size());
            object = list.get(n);
        } else {
            throw GamaRuntimeException.error("Uknown type for " + string + " : " + list.toString(), this.scope);
        }
        this.parameters.get(string).add(object);
    }

    private double computeFirstOrderConfidence(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = this.scope.getRandom().getGenerator().nextInt(n);
                dArray4[n4] = dArray[n5];
                dArray5[n4] = dArray2[n5];
                dArray6[n4] = dArray3[n5];
                ++n4;
            }
            dArray7[n3] = this.computeFirstOrder(dArray4, dArray5, dArray6, n);
            ++n3;
        }
        double d = Arrays.stream(dArray7).sum() / (double)n2;
        double d2 = 0.0;
        int n6 = 0;
        while (n6 < n2) {
            d2 += Math.pow(dArray7[n6] - d, 2.0);
            ++n6;
        }
        return 1.96 * Math.sqrt(d2 / (double)(n2 - 1));
    }

    private double computeFirstOrder(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2];
            ++n2;
        }
        d /= (double)n;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            d5 += (dArray[n3] - d) * (dArray3[n3] - d);
            d2 += (dArray3[n3] - d) * (dArray3[n3] - d);
            d3 += dArray3[n3] - d;
            d4 += (dArray2[n3] - d) * (dArray3[n3] - d);
            ++n3;
        }
        double d6 = d2 / (double)(n - 1) - Math.pow(d3 / (double)n, 2.0);
        double d7 = d4 / (double)(n - 1);
        return (d7 - (d5 /= (double)n)) / d6;
    }

    private double computeTotalOrder(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2];
            ++n2;
        }
        d /= (double)n;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            d2 += (dArray[n3] - d) * (dArray[n3] - d);
            d3 += (dArray[n3] - d) * (dArray2[n3] - d);
            d4 += dArray[n3] - d;
            ++n3;
        }
        double d5 = Math.pow(d4 / (double)n, 2.0);
        double d6 = d2 / (double)(n - 1) - d5;
        double d7 = d3 / (double)(n - 1);
        return 1.0 - (d7 - d5) / d6;
    }

    private double computeTotalOrderConfidence(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = this.scope.getRandom().getGenerator().nextInt(n);
                dArray4[n4] = dArray[n5];
                dArray5[n4] = dArray2[n5];
                dArray6[n4] = dArray3[n5];
                ++n4;
            }
            dArray7[n3] = this.computeTotalOrder(dArray4, dArray5, dArray6, n);
            ++n3;
        }
        double d = Arrays.stream(dArray7).sum() / (double)n2;
        double d2 = 0.0;
        int n6 = 0;
        while (n6 < n2) {
            d2 += Math.pow(dArray7[n6] - d, 2.0);
            ++n6;
        }
        return 1.96 * Math.sqrt(d2 / (double)(n2 - 1));
    }

    private double computeSecondOrder(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2];
            ++n2;
        }
        d /= (double)n;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            d2 += (dArray[n3] - d) * (dArray5[n3] - d);
            d3 += (dArray2[n3] - d) * (dArray4[n3] - d);
            d4 += (dArray2[n3] - d) * (dArray2[n3] - d);
            d5 += dArray2[n3] - d;
            d6 += (dArray2[n3] - d) * (dArray3[n3] - d);
            d7 += (dArray3[n3] - d) * (dArray5[n3] - d);
            d8 += (dArray4[n3] - d) * (dArray5[n3] - d);
            ++n3;
        }
        double d9 = d4 / (double)(n - 1) - Math.pow(d5 / (double)n, 2.0);
        double d10 = d6 / (double)(n - 1) - (d3 /= (double)n);
        double d11 = d7 / (double)(n - 1) - (d2 /= (double)n);
        double d12 = d8 / (double)(n - 1) - d3;
        return (d10 - d11 - d12) / d9;
    }

    private double computeSecondOrderConfidence(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n, int n2) {
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[] dArray9 = new double[n];
        double[] dArray10 = new double[n];
        double[] dArray11 = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = this.scope.getRandom().getGenerator().nextInt(n);
                dArray6[n4] = dArray[n5];
                dArray7[n4] = dArray2[n5];
                dArray8[n4] = dArray3[n5];
                dArray9[n4] = dArray4[n5];
                dArray10[n4] = dArray5[n5];
                ++n4;
            }
            dArray11[n3] = this.computeSecondOrder(dArray6, dArray7, dArray8, dArray9, dArray10, n);
            ++n3;
        }
        double d = Arrays.stream(dArray11).sum() / (double)n2;
        double d2 = 0.0;
        int n6 = 0;
        while (n6 < n2) {
            d2 += Math.pow(dArray11[n6] - d, 2.0);
            ++n6;
        }
        return 1.96 * Math.sqrt(d2 / (double)(n2 - 1));
    }
}

