/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Dates;
import gama.gaml.types.GamaDateType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import org.apache.commons.lang3.StringUtils;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="day_of_week", type=1, doc={@GamlAnnotations.doc(value="Returns the index of the day of the week (with Monday being 1)")}), @GamlAnnotations.variable(name="date", type=23, doc={@GamlAnnotations.doc(value="Returns a new date object with only the year-month-day components of this date")}), @GamlAnnotations.variable(name="leap", type=3, doc={@GamlAnnotations.doc(value="Returns true if the year is a leap year")}), @GamlAnnotations.variable(name="days_in_month", type=1, doc={@GamlAnnotations.doc(value="Returns the number of days of the month (28-31) of this date")}), @GamlAnnotations.variable(name="day_of_year", type=1, doc={@GamlAnnotations.doc(value="Returns the current day number of the year of this date")}), @GamlAnnotations.variable(name="days_in_year", type=1, doc={@GamlAnnotations.doc(value="Returns the number of days of the year (365-366) of this date")}), @GamlAnnotations.variable(name="week_of_year", type=1, doc={@GamlAnnotations.doc(value="Returns the week (1-52) of the year")}), @GamlAnnotations.variable(name="second", type=1, doc={@GamlAnnotations.doc(value="Returns the second of minute (0-59) of this date")}), @GamlAnnotations.variable(name="second_of_day", type=1, doc={@GamlAnnotations.doc(value="Returns the second of day (0-86399) of this date")}), @GamlAnnotations.variable(name="minute", type=1, doc={@GamlAnnotations.doc(value="Returns the minute of hour (0-59) of this date")}), @GamlAnnotations.variable(name="minute_of_day", type=1, doc={@GamlAnnotations.doc(value="Returns the minute of day (0-1439) of this date")}), @GamlAnnotations.variable(name="hour", type=1, doc={@GamlAnnotations.doc(value="Returns the hour of the day (0-23) of this date")}), @GamlAnnotations.variable(name="day", type=1, doc={@GamlAnnotations.doc(value="Returns the day of month (1-31) of this date")}), @GamlAnnotations.variable(name="month", type=1, doc={@GamlAnnotations.doc(value="Returns the month of year (1-12) of this date")}), @GamlAnnotations.variable(name="year", type=1, doc={@GamlAnnotations.doc(value="Returns the year")})})
public class GamaDate
implements IValue,
Temporal,
Comparable<GamaDate> {
    private static final String THE_DATE = "The date ";
    final Temporal internal;

    public static GamaDate of(Temporal temporal) {
        return new GamaDate(temporal);
    }

    private GamaDate(Temporal temporal) {
        this(null, temporal);
    }

    public GamaDate(IScope iScope, GamaDate gamaDate) {
        this(iScope, LocalDateTime.from(gamaDate));
    }

    public GamaDate(IScope iScope, Temporal temporal) {
        ZoneId zoneId = temporal instanceof ChronoZonedDateTime ? ZonedDateTime.from(temporal).getZone() : (temporal.isSupported(ChronoField.OFFSET_SECONDS) ? ZoneId.ofOffset("", ZoneOffset.ofTotalSeconds(temporal.get(ChronoField.OFFSET_SECONDS))) : GamaDateType.DEFAULT_ZONE);
        this.internal = !temporal.isSupported(ChronoField.MINUTE_OF_HOUR) ? ZonedDateTime.of(LocalDate.from(temporal), LocalTime.of(0, 0), zoneId) : (!temporal.isSupported(ChronoField.DAY_OF_MONTH) ? ZonedDateTime.of(LocalDate.from(iScope == null || iScope.getSimulation() == null ? (TemporalAccessor)Dates.DATES_STARTING_DATE.getValue() : iScope.getSimulation().getStartingDate()), LocalTime.from(temporal), zoneId) : temporal);
    }

    public GamaDate(IScope iScope, String string) {
        this(iScope, GamaDate.parse(iScope, string, null));
    }

    public GamaDate(IScope iScope, String string, String string2) {
        this(iScope, string, string2, null);
    }

    public GamaDate(IScope iScope, String string, String string2, String string3) {
        this(iScope, GamaDate.parse(iScope, string, Dates.getFormatter(string2, string3)));
    }

    public GamaDate(IScope iScope, double d) {
        this(iScope, iScope.getSimulation().getStartingDate().plus(d * 1000.0, (TemporalUnit)ChronoUnit.MILLIS));
    }

    public GamaDate(IScope iScope, IList<?> iList) {
        this(iScope, GamaDate.computeFromList(iScope, iList));
    }

    private static Temporal parse(IScope iScope, String string, DateTimeFormatter dateTimeFormatter) {
        String string2;
        if (string == null || string.isEmpty() || "now".equals(string)) {
            return LocalDateTime.now(GamaDateType.DEFAULT_ZONE);
        }
        Comparable<ChronoLocalDateTime<?>> comparable = null;
        if (dateTimeFormatter != null) {
            try {
                TemporalAccessor temporalAccessor = dateTimeFormatter.parse(string);
                if (temporalAccessor instanceof Temporal) {
                    Temporal temporal = (Temporal)temporalAccessor;
                    return temporal;
                }
                if (!temporalAccessor.isSupported(ChronoField.YEAR) && !temporalAccessor.isSupported(ChronoField.MONTH_OF_YEAR) && !temporalAccessor.isSupported(ChronoField.DAY_OF_MONTH) && temporalAccessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                    return LocalTime.from(temporalAccessor);
                }
                if (!(temporalAccessor.isSupported(ChronoField.HOUR_OF_DAY) || temporalAccessor.isSupported(ChronoField.MINUTE_OF_HOUR) || temporalAccessor.isSupported(ChronoField.SECOND_OF_MINUTE))) {
                    return LocalDate.from(temporalAccessor);
                }
                return LocalDateTime.from(temporalAccessor);
            }
            catch (DateTimeParseException dateTimeParseException) {
                dateTimeParseException.printStackTrace();
                GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning(THE_DATE + string + " can not correctly be parsed by the pattern provided", iScope), false);
                return GamaDate.parse(iScope, string, null);
            }
        }
        try {
            Object object;
            Object object2;
            Object object3;
            String string3 = string;
            if (!string.contains("T") && string.contains(" ")) {
                string3 = StringUtils.replaceOnce((String)string, (String)" ", (String)"T");
            }
            String[] stringArray = string3.split("T");
            String[] stringArray2 = stringArray[0].split("-");
            String string4 = stringArray.length == 1 ? "00:00:00" : stringArray[1];
            if (stringArray2.length == 1) {
                object3 = stringArray2[0].substring(0, 4);
                object2 = stringArray2[0].substring(4, 6);
                object = stringArray2[0].substring(6, 8);
            } else {
                object3 = stringArray2[0];
                object2 = stringArray2[1];
                object = stringArray2[2];
            }
            if (((String)object3).length() == 2) {
                object3 = "20" + (String)object3;
            }
            if (((String)object2).length() == 1) {
                object2 = "0" + (String)object2;
            }
            if (((String)object).length() == 1) {
                object = "0" + (String)object;
            }
            string2 = (String)object3 + "-" + (String)object2 + "-" + (String)object + "T" + string4;
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error(THE_DATE + string + " is not correctly formatted. Please refer to the ISO date/time format", iScope);
        }
        try {
            comparable = LocalDateTime.parse(string2);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                comparable = OffsetDateTime.parse(string2);
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    comparable = ZonedDateTime.parse(string2);
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    throw GamaRuntimeException.error(THE_DATE + string + " is not correctly formatted. Please refer to the ISO date/time format", iScope);
                }
            }
        }
        return comparable;
    }

    public GamaDate(IScope iScope, int n, int n2, int n3, int n4, int n5, int n6) {
        this(iScope, LocalDateTime.of(n6, n5, n4, n3, n2));
    }

    @Override
    public double floatValue(IScope iScope) {
        SimulationAgent simulationAgent = iScope.getSimulation();
        if (simulationAgent == null) {
            return Dates.DATES_STARTING_DATE.getValue().until(this, ChronoUnit.SECONDS);
        }
        return simulationAgent.getStartingDate().until(this, ChronoUnit.SECONDS);
    }

    @Override
    public int intValue(IScope iScope) {
        return (int)this.floatValue(iScope);
    }

    public IList<?> listValue(IScope iScope, IType<?> iType) {
        LocalDateTime localDateTime = LocalDateTime.from(this.internal);
        return GamaListFactory.create(iScope, iType, localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
    }

    private static LocalDateTime computeFromList(IScope iScope, IList<?> iList) {
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = iList.size();
        if (n7 > 0) {
            n = Cast.asInt(iScope, iList.get(0));
            if (n7 > 1) {
                n2 = Cast.asInt(iScope, iList.get(1));
                if (n7 > 2) {
                    n3 = Cast.asInt(iScope, iList.get(2));
                    if (n7 > 3) {
                        n4 = Cast.asInt(iScope, iList.get(3));
                        if (n7 > 4) {
                            n5 = Cast.asInt(iScope, iList.get(4));
                            if (n7 > 5) {
                                n6 = Cast.asInt(iScope, iList.get(5));
                            }
                        }
                    }
                }
            }
        }
        return LocalDateTime.of(n, n2, n3, n4, n5, n6);
    }

    public String toString() {
        return this.toString(null, null);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "date ('" + this.toString() + "')";
    }

    @Override
    public String stringValue(IScope iScope) {
        return this.toString();
    }

    @Override
    public IType<?> getGamlType() {
        return Types.DATE;
    }

    @Override
    public GamaDate copy(IScope iScope) throws GamaRuntimeException {
        return new GamaDate(iScope, this.internal);
    }

    @GamlAnnotations.getter(value="year")
    public int getYear() {
        return this.internal.get(ChronoField.YEAR);
    }

    @GamlAnnotations.getter(value="date")
    public GamaDate getDate() {
        return GamaDate.of(LocalDate.of(this.getYear(), this.getMonth(), this.getDay()));
    }

    @GamlAnnotations.getter(value="day_of_year")
    public int getDayOfYear() {
        return this.internal.get(ChronoField.DAY_OF_YEAR);
    }

    @GamlAnnotations.getter(value="second_of_day")
    public int getSecondOfDay() {
        return this.internal.get(ChronoField.SECOND_OF_DAY);
    }

    @GamlAnnotations.getter(value="month")
    public int getMonth() {
        return this.internal.get(ChronoField.MONTH_OF_YEAR);
    }

    @GamlAnnotations.getter(value="day")
    public int getDay() {
        return this.internal.get(ChronoField.DAY_OF_MONTH);
    }

    @GamlAnnotations.getter(value="hour")
    public int getHour() {
        return this.internal.get(ChronoField.HOUR_OF_DAY);
    }

    @GamlAnnotations.getter(value="minute")
    public int getMinute() {
        return this.internal.get(ChronoField.MINUTE_OF_HOUR);
    }

    @GamlAnnotations.getter(value="minute_of_day")
    public int getMinuteOfDay() {
        return this.internal.get(ChronoField.MINUTE_OF_DAY);
    }

    @GamlAnnotations.getter(value="second")
    public int getSecond() {
        return this.internal.get(ChronoField.SECOND_OF_MINUTE);
    }

    @GamlAnnotations.getter(value="day_of_week")
    public int getDayWeek() {
        return this.internal.get(ChronoField.DAY_OF_WEEK);
    }

    @GamlAnnotations.getter(value="leap")
    public boolean getIsLeap() {
        return LocalDate.from(this.internal).isLeapYear();
    }

    @GamlAnnotations.getter(value="week_of_year")
    public int getWeekYear() {
        return this.internal.get(WeekFields.ISO.weekOfYear());
    }

    @GamlAnnotations.getter(value="days_in_month")
    public int getDaysMonth() {
        return LocalDate.from(this.internal).lengthOfMonth();
    }

    @GamlAnnotations.getter(value="days_in_year")
    public int getDaysInYear() {
        return LocalDate.from(this.internal).lengthOfYear();
    }

    public Temporal getTemporal() {
        return this.internal;
    }

    public LocalDateTime getLocalDateTime() {
        return LocalDateTime.from(this.internal);
    }

    public ZonedDateTime getZonedDateTime() {
        return ZonedDateTime.from(this.internal);
    }

    public OffsetDateTime getOffsetDateTime() {
        return OffsetDateTime.from(this.internal);
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        return this.internal.isSupported(temporalField) || ChronoField.OFFSET_SECONDS.equals(temporalField) || ChronoField.INSTANT_SECONDS.equals(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (this.internal.isSupported(temporalField)) {
            return this.internal.getLong(temporalField);
        }
        if (ChronoField.OFFSET_SECONDS.equals(temporalField)) {
            return GamaDateType.DEFAULT_OFFSET_IN_SECONDS.getTotalSeconds();
        }
        if (ChronoField.INSTANT_SECONDS.equals(temporalField)) {
            return GamaDateType.EPOCH.until(this.internal, ChronoUnit.SECONDS);
        }
        return 0L;
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        return this.internal.isSupported(temporalUnit);
    }

    @Override
    public GamaDate with(TemporalField temporalField, long l) {
        return GamaDate.of(this.internal.with(temporalField, l));
    }

    @Override
    public GamaDate plus(long l, TemporalUnit temporalUnit) {
        return GamaDate.of(this.internal.plus(l, temporalUnit));
    }

    @Override
    public GamaDate minus(long l, TemporalUnit temporalUnit) {
        return GamaDate.of(this.internal.minus(l, temporalUnit));
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        return temporalUnit.between(this.internal, temporal);
    }

    public String toString(String string, String string2) {
        return Dates.getFormatter(string, string2).format(this);
    }

    public boolean isGreaterThan(GamaDate gamaDate, boolean bl) {
        boolean bl2 = this.getLocalDateTime().isAfter(gamaDate.getLocalDateTime());
        return bl ? bl2 : bl2 || this.equals(gamaDate);
    }

    public boolean isSmallerThan(GamaDate gamaDate, boolean bl) {
        boolean bl2 = this.getLocalDateTime().isBefore(gamaDate.getLocalDateTime());
        return bl ? bl2 : bl2 || this.equals(gamaDate);
    }

    public boolean equals(Object object) {
        if (object instanceof GamaDate) {
            GamaDate gamaDate = (GamaDate)object;
            LocalDateTime localDateTime = this.getLocalDateTime();
            LocalDateTime localDateTime2 = gamaDate.getLocalDateTime();
            return ((Object)localDateTime).equals(localDateTime2);
        }
        return false;
    }

    public int hashCode() {
        return this.internal.hashCode();
    }

    public GamaDate plus(double d, TemporalUnit temporalUnit) {
        return this.plus((long)d, temporalUnit);
    }

    @Override
    public GamaDate plus(TemporalAmount temporalAmount) {
        return GamaDate.of(this.internal.plus(temporalAmount));
    }

    @Override
    public GamaDate minus(TemporalAmount temporalAmount) {
        return GamaDate.of(this.internal.minus(temporalAmount));
    }

    public GamaDate plusMillis(double d) {
        return this.plus((long)d, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public GamaDate minusMillis(double d) {
        return this.minus((long)d, ChronoUnit.MILLIS);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isIntervalReached(IScope var1_1, IExpression var2_2) {
        var3_3 = var1_1.getClock().getCurrentDate();
        if (this.equals(var3_3)) {
            return true;
        }
        if (this.isGreaterThan(var3_3, true)) {
            return false;
        }
        var4_4 = this.plus(var1_1, var2_2);
        if (this.equals(var4_4)) {
            return false;
        }
        if (!var4_4.equals(var3_3)) ** GOTO lbl12
        return true;
lbl-1000:
        // 1 sources

        {
            var4_4 = var4_4.plus(var1_1, var2_2);
lbl12:
            // 2 sources

            ** while (var4_4.isSmallerThan((GamaDate)var3_3, (boolean)true))
        }
lbl13:
        // 1 sources

        var5_5 = var1_1.getClock().getStepInMillis();
        var7_6 = var3_3.plus(var5_5, (TemporalUnit)ChronoUnit.MILLIS);
        return var7_6.isGreaterThan(var4_4, true);
    }

    public boolean isIntervalReachedOptimized(IScope iScope, IExpression iExpression) {
        long l;
        GamaDate gamaDate = iScope.getClock().getCurrentDate();
        if (this.equals(gamaDate)) {
            return true;
        }
        if (this.isGreaterThan(gamaDate, true)) {
            return false;
        }
        long l2 = (long)(iScope.getSimulation().getTimeStep(iScope) * 1000.0);
        if (l2 >= (l = (long)(Cast.asFloat(iScope, iExpression.value(iScope)) * 1000.0))) {
            return true;
        }
        long l3 = iScope.getSimulation().getStartingDate().until(iScope.getSimulation().getCurrentDate(), ChronoUnit.MILLIS);
        long l4 = l3 % l;
        if (l4 == 0L) {
            return true;
        }
        return l4 - l2 > 0L && l4 + l2 > l;
    }

    public GamaDate plus(IScope iScope, IExpression iExpression) {
        long l = (long)(Cast.asFloat(iScope, iExpression.value(iScope)) * 1000.0);
        if (l == 0L) {
            return this;
        }
        return this.plus(l, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public GamaDate plus(double d, int n, ChronoUnit chronoUnit) {
        GamaDate gamaDate = this;
        int n2 = 0;
        while (n2 < n) {
            gamaDate = gamaDate.plus(d, (TemporalUnit)chronoUnit);
            ++n2;
        }
        return gamaDate;
    }

    @Override
    public int compareTo(GamaDate gamaDate) {
        return this.isSmallerThan(gamaDate, true) ? -1 : (this.isGreaterThan(gamaDate, true) ? 1 : 0);
    }

    public boolean isBefore(GamaDate gamaDate) {
        return this.isSmallerThan(gamaDate, true);
    }

    public boolean isAfter(GamaDate gamaDate) {
        return this.isGreaterThan(gamaDate, true);
    }

    public String toISOString() {
        return this.toString("ISO_OFFSET_DATE_TIME", null);
    }

    public static GamaDate fromISOString(String string) {
        try {
            TemporalAccessor temporalAccessor = Dates.getFormatter("ISO_OFFSET_DATE_TIME", null).parse(string);
            if (temporalAccessor instanceof Temporal) {
                Temporal temporal = (Temporal)temporalAccessor;
                return GamaDate.of(temporal);
            }
        }
        catch (DateTimeParseException dateTimeParseException) {}
        return new GamaDate(null, string);
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "iso", this.toISOString());
    }
}

