/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import gama.core.common.util.StringUtils;
import gama.gaml.descriptions.BasicExpressionDescription;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.LabelExpressionDescription;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class StringBasedExpressionDescription
extends BasicExpressionDescription {
    String string;

    private StringBasedExpressionDescription(String string) {
        super((EObject)null);
        this.string = string;
    }

    @Override
    public String toOwnString() {
        return this.string;
    }

    @Override
    public IExpressionDescription compileAsLabel() {
        return LabelExpressionDescription.create(this.string);
    }

    public Set<String> getStrings(IDescription iDescription, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = this.string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case ' ': 
                case '[': {
                    break;
                }
                case ',': 
                case ']': {
                    hashSet.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            ++n2;
        }
        return hashSet;
    }

    @Override
    public IExpressionDescription cleanCopy() {
        StringBasedExpressionDescription stringBasedExpressionDescription = new StringBasedExpressionDescription(this.string);
        stringBasedExpressionDescription.setTarget(this.target);
        return stringBasedExpressionDescription;
    }

    public static IExpressionDescription create(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("nil".equals(string2)) {
            return ConstantExpressionDescription.create(null);
        }
        if ("false".equals(string2)) {
            return ConstantExpressionDescription.create(false);
        }
        if ("true".equals(string2)) {
            return ConstantExpressionDescription.create(true);
        }
        if (StringUtils.isGamaString(string2)) {
            return LabelExpressionDescription.create(StringUtils.toJavaString(string2));
        }
        return new StringBasedExpressionDescription(string);
    }

    @Override
    public IType<?> getDenotedType(IDescription iDescription) {
        if ("0".equals(this.string)) {
            return Types.NO_TYPE;
        }
        IType<?> iType = iDescription.getTypeNamed(this.string);
        if (iType == Types.NO_TYPE) {
            iType = super.getDenotedType(iDescription);
        }
        return iType;
    }
}

