/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Comparison;

public class Maths {
    public static final double PI = Math.PI;
    public static final double PI_4 = 0.7853981633974483;
    public static final int PRECISION = 360;
    public static final double PI_2 = Math.PI * 2;
    public static final double PI_2_OVER1 = 0.15915494309189535;
    public static final double PI_2_OVER1_P = 57.29577951308232;
    public static final double PI_34 = 2.356194490192345;
    public static final int PREC_MIN_1 = 359;
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double toDeg = 57.29577951308232;
    public static final double toRad = Math.PI / 180;
    public static final long[] TENS = new long[100];

    static {
        int n = 0;
        while (n < TENS.length) {
            Maths.TENS[n] = (long)Math.pow(10.0, n);
            ++n;
        }
    }

    @GamlAnnotations.operator(value={"^"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (always a float) of the left operand raised to the power of the right operand.", masterDoc=true, usages={@GamlAnnotations.usage(value="if the right-hand operand is equal to 0, returns 1"), @GamlAnnotations.usage(value="if it is equal to 1, returns the left-hand operand."), @GamlAnnotations.usage(value="Various examples of power", examples={@GamlAnnotations.example(value="2 ^ 3", equals="8.0")})}, see={"*", "sqrt"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="8^0 = 1.0"), @GamlAnnotations.test(value="2^2 = 4.0")})
    public static Double pow(Integer n, Integer n2) {
        return Maths.pow((Double)n.doubleValue(), (Double)n2.doubleValue());
    }

    @GamlAnnotations.operator(value={"^"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the value (always a float) of the left operand raised to the power of the right operand.")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="4.0^2 = 16.0"), @GamlAnnotations.test(value="8.0^0 = 1.0"), @GamlAnnotations.test(value="8.0^1 = 8.0")})
    public static Double pow(Double d, Integer n) {
        return Maths.pow(d, (Double)n.doubleValue());
    }

    @GamlAnnotations.operator(value={"^"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the value (always a float) of the left operand raised to the power of the right operand.")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="2^0.5 = sqrt(2)"), @GamlAnnotations.test(value="2^0.0 = 1.0"), @GamlAnnotations.test(value="2^1.0 = 2.0")})
    public static Double pow(Integer n, Double d) {
        return Maths.pow((Double)n.doubleValue(), d);
    }

    @GamlAnnotations.operator(value={"^"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the value (always a float) of the left operand raised to the power of the right operand.", usages={@GamlAnnotations.usage(value="", examples={@GamlAnnotations.example(value="4.84 ^ 0.5", equals="2.2")})})
    @GamlAnnotations.test(value="16.81^0.5 = sqrt(16.81)")
    public static Double pow(Double d, Double d2) {
        return Math.pow(d, d2);
    }

    @GamlAnnotations.operator(value={"abs"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the absolute value of the operand (so a positive int or float depending on the type of the operand).", masterDoc=true, usages={@GamlAnnotations.usage(value="", examples={@GamlAnnotations.example(value="abs (200 * -1 + 0.5)", equals="199.5")})})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="abs(1.9) = 1.9"), @GamlAnnotations.test(value="abs(-2.0) = 2.0"), @GamlAnnotations.test(value="abs(0.0) = 0.0"), @GamlAnnotations.test(value="abs(-0.0) = 0.0")})
    public static Double abs(Double d) {
        return Math.abs(d);
    }

    @GamlAnnotations.operator(value={"abs"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the absolute value of the operand (so a positive int or float depending on the type of the operand).", usages={@GamlAnnotations.usage(value="", examples={@GamlAnnotations.example(value="abs (-10)", equals="10"), @GamlAnnotations.example(value="abs (10)", equals="10")})})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="abs(1) = 1"), @GamlAnnotations.test(value="abs(-2) = 2"), @GamlAnnotations.test(value="abs(0) = 0"), @GamlAnnotations.test(value="abs(-0) = 0")})
    public static Integer abs(Integer n) {
        int n2 = n;
        return (n2 ^ n2 >> 31) - (n2 >> 31);
    }

    @GamlAnnotations.operator(value={"acos"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in the interval [0,180], in decimal degrees) of the arccos of the operand (which should be in [-1,1]).", masterDoc=true, usages={@GamlAnnotations.usage(value="if the right-hand operand is outside of the [-1,1] interval, returns NaN")}, examples={@GamlAnnotations.example(value="acos (0)", equals="90.0")}, see={"asin", "atan", "cos"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="acos(0.0) = 90.0"), @GamlAnnotations.test(value="acos(-1.0) = 180.0"), @GamlAnnotations.test(value="acos(1.0) = 0.0"), @GamlAnnotations.test(value="not(is_number(acos(-10.0)))"), @GamlAnnotations.test(value="not(is_number(acos(10.0)))")})
    public static Double acos(Double d) {
        return Math.acos(d) * 57.29577951308232;
    }

    @GamlAnnotations.operator(value={"acos"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the arccos of the operand ")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="acos(0) = 90.0"), @GamlAnnotations.test(value="acos(-1) = 180.0"), @GamlAnnotations.test(value="acos(1) = 0.0"), @GamlAnnotations.test(value="not(is_number(acos(-10)))"), @GamlAnnotations.test(value="not(is_number(acos(10)))")})
    public static Double acos(Integer n) {
        return Math.acos(n.intValue()) * 57.29577951308232;
    }

    @GamlAnnotations.operator(value={"asin"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in the interval [-90,90], in decimal degrees) of the arcsin of the operand (which should be in [-1,1]).", usages={@GamlAnnotations.usage(value="if the right-hand operand is outside of the [-1,1] interval, returns NaN")}, examples={@GamlAnnotations.example(value="asin (0)", equals="0.0")}, see={"acos", "atan", "sin"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="asin(0.0) = 0.0"), @GamlAnnotations.test(value="asin(-1.0) = -90.0"), @GamlAnnotations.test(value="asin(1.0) = 90.0"), @GamlAnnotations.test(value="not(is_number(asin(-10.0)))"), @GamlAnnotations.test(value="not(is_number(asin(10.0)))")})
    public static Double asin(Double d) {
        return Math.asin(d) * 57.29577951308232;
    }

    @GamlAnnotations.operator(value={"asin"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the arcsin of the operand", masterDoc=true, examples={@GamlAnnotations.example(value="asin (90)", equals="#nan", test=false)}, see={"acos", "atan"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="asin(0) = 0.0"), @GamlAnnotations.test(value="asin(-1) = -90.0"), @GamlAnnotations.test(value="asin(1) = 90.0"), @GamlAnnotations.test(value="not(is_number(asin(-10)))"), @GamlAnnotations.test(value="not(is_number(asin(10)))")})
    public static Double asin(Integer n) {
        return Math.asin(n.intValue()) * 57.29577951308232;
    }

    @GamlAnnotations.operator(value={"atan"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in the interval [-90,90], in decimal degrees) of the arctan of the operand (which can be any real number).", masterDoc=true, examples={@GamlAnnotations.example(value="atan (1)", equals="45.0")}, see={"acos", "asin", "tan"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="atan(0.0) = 0.0"), @GamlAnnotations.test(value="atan(-1.0) = -45.0"), @GamlAnnotations.test(value="atan(1.0) = 45.0")})
    public static Double atan(Double d) {
        return Math.atan(d) * 57.29577951308232;
    }

    @GamlAnnotations.operator(value={"atan"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the arctan of the operand")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="atan(0) = 0.0"), @GamlAnnotations.test(value="atan(-1) = -45.0"), @GamlAnnotations.test(value="atan(1) = 45.0")})
    public static Double atan(Integer n) {
        return Math.atan(n.intValue()) * 57.29577951308232;
    }

    @GamlAnnotations.operator(value={"tanh"}, can_be_const=true, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in the interval [-1,1]) of the hyperbolic tangent of the operand (which can be any real number, expressed in decimal degrees).", masterDoc=true, examples={@GamlAnnotations.example(value="tanh(0)", equals="0.0"), @GamlAnnotations.example(value="tanh(100)", equals="1.0")})
    public static Double tanh(Double d) {
        return Math.tanh(d);
    }

    @GamlAnnotations.operator(value={"tanh"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the hyperbolic tangent of the operand (which has to be expressed in decimal degrees).")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="tanh(100) = 1.0"), @GamlAnnotations.test(value="tanh(0) = 0.0")})
    public static Double tanh(Integer n) {
        return Math.tanh(n.intValue());
    }

    @GamlAnnotations.operator(value={"cos_rad"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in [-1,1]) of the cosinus of the operand (in radians). ", masterDoc=true, special_cases={"Operand values out of the range [0-359] are normalized."}, see={"sin", "tan"}, examples={@GamlAnnotations.example(value="cos_rad(0.0)", equals="1.0"), @GamlAnnotations.example(value="cos_rad(#pi)", equals="-1.0")})
    public static Double cos_rad(Double d) {
        return Math.cos(d);
    }

    @GamlAnnotations.operator(value={"sin_rad"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in [-1,1]) of the sinus of the operand (in radians). ", masterDoc=true, examples={@GamlAnnotations.example(value="sin_rad(0)", equals="0.0"), @GamlAnnotations.example(value="sin_rad(#pi/2)", equals="1.0")}, see={"cos_rad", "tan_rad"})
    public static Double sin_rad(Double d) {
        return Math.sin(d);
    }

    @GamlAnnotations.operator(value={"tan_rad"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in [-1,1]) of the trigonometric tangent of the operand (in radians). ", masterDoc=true, examples={@GamlAnnotations.example(value="tan_rad(0)", equals="0.0")}, see={"cos_rad", "sin_rad"})
    public static Double tan_rad(Double d) {
        return Math.tan(d);
    }

    @GamlAnnotations.operator(value={"cos"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in [-1,1]) of the cosinus of the operand (in decimal degrees).  The argument is casted to an int before being evaluated.", masterDoc=true, special_cases={"Operand values out of the range [0-359] are normalized."}, examples={@GamlAnnotations.example(value="cos (0.0)", equals="1.0"), @GamlAnnotations.example(value="cos(360.0)", equals="1.0"), @GamlAnnotations.example(value="cos(-720.0)", equals="1.0")}, see={"sin", "tan"})
    public static Double cos(Double d) {
        return Math.cos(d * (Math.PI / 180));
    }

    @GamlAnnotations.operator(value={"cos"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the cosinus of the operand.", examples={@GamlAnnotations.example(value="cos (0)", equals="1.0"), @GamlAnnotations.example(value="cos(360)", equals="1.0"), @GamlAnnotations.example(value="cos(-720)", equals="1.0")})
    public static Double cos(Integer n) {
        return Math.cos((double)n.intValue() * (Math.PI / 180));
    }

    @GamlAnnotations.operator(value={"sin"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in [-1,1]) of the sinus of the operand (in decimal degrees). The argument is casted to an int before being evaluated.", masterDoc=true, usages={@GamlAnnotations.usage(value="Operand values out of the range [0-359] are normalized.")}, examples={@GamlAnnotations.example(value="sin(360) with_precision 10 with_precision 10", equals="0.0")}, see={"cos", "tan"})
    public static Double sin(Double d) {
        return Math.sin(d * (Math.PI / 180));
    }

    @GamlAnnotations.operator(value={"sin"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the sinus of the operand (in decimal degrees).", examples={@GamlAnnotations.example(value="sin (0)", equals="0.0")})
    public static Double sin(Integer n) {
        return Math.sin((double)n.intValue() * (Math.PI / 180));
    }

    @GamlAnnotations.operator(value={"tan"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the value (in [-1,1]) of the trigonometric tangent of the operand (in decimal degrees). ", masterDoc=true, usages={@GamlAnnotations.usage(value="Operand values out of the range [0-359] are normalized. Notice that tan(360) does not return 0.0 but -2.4492935982947064E-16"), @GamlAnnotations.usage(value="The tangent is only defined for any real number except 90 + k `*` 180 (k an positive or negative integer). Nevertheless notice that tan(90) returns 1.633123935319537E16 (whereas we could except infinity).")}, see={"cos", "sin"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="tan(90.0) = 1.633123935319537E16"), @GamlAnnotations.test(value="tan(0.0) = 0.0")})
    public static Double tan(Double d) {
        return Math.tan(Math.PI / 180 * d);
    }

    @GamlAnnotations.operator(value={"tan"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the value (in [-1,1]) of the trigonometric tangent of the operand (in decimal degrees). The argument is casted to an int before being evaluated.", examples={@GamlAnnotations.example(value="tan (0)", equals="0.0"), @GamlAnnotations.example(value="tan(90)", equals="1.633123935319537E16")})
    public static Double tan(Integer n) {
        return Math.tan(Math.PI / 180 * (double)n.intValue());
    }

    @GamlAnnotations.operator(value={"even"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns true if the operand is even and false if it is odd.", usages={@GamlAnnotations.usage(value="if the operand is equal to 0, it returns true."), @GamlAnnotations.usage(value="if the operand is a float, it is truncated before")}, examples={@GamlAnnotations.example(value="even (3)", equals="false"), @GamlAnnotations.example(value="even(-12)", equals="true")})
    public static Boolean even(Integer n) {
        if ((n & 1) == 0) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"exp"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns Euler's number e raised to the power of the operand.", masterDoc=true, usages={@GamlAnnotations.usage(value="the operand is casted to a float before being evaluated.")}, examples={@GamlAnnotations.example(value="exp (0.0)", equals="1.0")}, see={"ln"})
    public static Double exp(Double d) {
        return Math.exp(d);
    }

    @GamlAnnotations.operator(value={"exp"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="returns Euler's number e raised to the power of the operand.")
    @GamlAnnotations.test(value="exp (0) = 1.0")
    public static Double exp(Integer n) {
        return Math.exp(n.doubleValue());
    }

    @GamlAnnotations.operator(value={"fact"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the factorial of the operand.", usages={@GamlAnnotations.usage(value="if the operand is less than 0, fact returns 0.")}, examples={@GamlAnnotations.example(value="fact(4)", equals="24")})
    public static Double fact(Integer n) {
        if (n < 0) {
            return 0.0;
        }
        double d = 1.0;
        int n2 = 2;
        while (n2 <= n) {
            d *= (double)n2;
            ++n2;
        }
        return d;
    }

    @GamlAnnotations.operator(value={"ln"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the natural logarithm (base e) of the operand.", masterDoc=true, usages={@GamlAnnotations.usage(value="an exception is raised if the operand is less than zero.")}, examples={@GamlAnnotations.example(value="ln(exp(1))", equals="1.0")}, see={"exp"})
    public static Double ln(IScope iScope, Double d) {
        if (d <= 0.0) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("The ln operator cannot accept negative or null inputs", iScope), false);
        }
        return Math.log(d);
    }

    @GamlAnnotations.operator(value={"ln"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="returns the natural logarithm (base e) of the operand.", examples={@GamlAnnotations.example(value="ln(1)", equals="0.0")})
    public static Double ln(IScope iScope, Integer n) {
        if (n <= 0) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("The ln operator cannot accept negative or null inputs", iScope), false);
        }
        return Math.log(n.intValue());
    }

    @GamlAnnotations.operator(value={"log"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the logarithm (base 10) of the operand.", masterDoc=true, usages={@GamlAnnotations.usage(value="an exception is raised if the operand is equals or less than zero.")}, examples={@GamlAnnotations.example(value="log(10)", equals="1.0")}, see={"ln"})
    public static Double log(IScope iScope, Double d) {
        if (d <= 0.0) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("The log operator cannot accept negative or null inputs", iScope), false);
        }
        return Math.log10(d);
    }

    @GamlAnnotations.operator(value={"log"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="returns the logarithm (base 10) of the operand.", examples={@GamlAnnotations.example(value="log(1)", equals="0.0")})
    public static Double log(IScope iScope, Integer n) {
        if (n <= 0) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("The log operator cannot accept negative or null inputs", iScope), false);
        }
        return Math.log10(n.intValue());
    }

    @GamlAnnotations.operator(value={"log"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="returns the logarithm in base b of the operand.", examples={@GamlAnnotations.example(value="log(100, 100)", equals="1.0")})
    public static Double log(IScope iScope, Integer n, Integer n2) {
        if (n <= 0) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("The log operator cannot accept negative or null inputs", iScope), false);
        }
        return Math.log(n.intValue()) / Math.log(n2.intValue());
    }

    @GamlAnnotations.operator(value={"log"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="returns the logarithm in base b of the operand.", examples={@GamlAnnotations.example(value="log(100, 100.0)", equals="1.0")})
    public static Double log(IScope iScope, Integer n, Double d) {
        if (n <= 0) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("The log operator cannot accept negative or null inputs", iScope), false);
        }
        return Math.log(n.intValue()) / Math.log(d);
    }

    @GamlAnnotations.operator(value={"log"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="returns the logarithm in base b of the operand.", examples={@GamlAnnotations.example(value="log(100.0, 100.0)", equals="1.0")})
    public static Double log(IScope iScope, Double d, Double d2) {
        if (d <= 0.0) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("The log operator cannot accept negative or null inputs", iScope), false);
        }
        return Math.log(d) / Math.log(d2);
    }

    @GamlAnnotations.operator(value={"log"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="returns the logarithm in base b of the operand.", examples={@GamlAnnotations.example(value="log(100.0, 100)", equals="1.0")})
    public static Double log(IScope iScope, Double d, Integer n) {
        if (d <= 0.0) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("The log operator cannot accept negative or null inputs", iScope), false);
        }
        return Math.log(d) / Math.log(n.intValue());
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="If it is used as a unary operator, it returns the opposite of the operand.", masterDoc=true)
    @GamlAnnotations.test(value="-(-90.0) = 90.0")
    public static Double negate(Double d) {
        return -d.doubleValue();
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the opposite of the operand.", examples={@GamlAnnotations.example(value="- (-56)", equals="56")})
    public static Integer negate(Integer n) {
        return -n.intValue();
    }

    @GamlAnnotations.operator(value={"round"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the rounded value of the operand.", masterDoc=true, examples={@GamlAnnotations.example(value="round (0.51)", equals="1"), @GamlAnnotations.example(value="round (100.2)", equals="100"), @GamlAnnotations.example(value="round(-0.51)", equals="-1")}, see={"int", "with_precision"})
    public static Integer round(Double d) {
        int n = d >= 0.0 ? (int)(d + 0.5) : (int)(d - 0.5);
        return n;
    }

    @GamlAnnotations.operator(value={"round"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(special_cases={"if the operand is an int, round returns it"})
    @GamlAnnotations.test(value="round (100) = 100")
    public static Integer round(Integer n) {
        return n;
    }

    @GamlAnnotations.operator(value={"sqrt"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the square root of the operand.", masterDoc=true, usages={@GamlAnnotations.usage(value="if the operand is negative, an exception is raised")}, examples={@GamlAnnotations.example(value="sqrt(4)", equals="2.0")})
    public static Double sqrt(IScope iScope, Integer n) throws GamaRuntimeException {
        if (n < 0) {
            throw GamaRuntimeException.warning("The sqrt operator cannot accept negative inputs", iScope);
        }
        return Math.sqrt(n.intValue());
    }

    @GamlAnnotations.operator(value={"sqrt"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the square root of the operand.", examples={@GamlAnnotations.example(value="sqrt(4)", equals="2.0")})
    public static Double sqrt(IScope iScope, Double d) throws GamaRuntimeException {
        if (d < 0.0) {
            throw GamaRuntimeException.warning("The sqrt operator cannot accept negative inputs", iScope);
        }
        return Math.sqrt(d);
    }

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the division of the two operands.", masterDoc=true, usages={@GamlAnnotations.usage(value="if both operands are numbers (float or int), performs a normal arithmetic division and returns a float.", examples={@GamlAnnotations.example(value="3 / 5.0", equals="0.6")})}, special_cases={"if the right-hand operand is equal to zero, raises a \"Division by zero\" exception"}, see={"+", "-", "*"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="0/1=0"), @GamlAnnotations.test(value="is_error(1/0)"), @GamlAnnotations.test(value="3/5=0.6")})
    public static Double opDivide(IScope iScope, Integer n, Integer n2) throws GamaRuntimeException {
        if (n2 == 0) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return n.doubleValue() / n2.doubleValue();
    }

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns a float, equal to the division of the left-hand operand by the right-hand operand.", see={"*"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="0.2/2=0.1"), @GamlAnnotations.test(value="is_error(1.5/0)"), @GamlAnnotations.test(value="0.0/5=0.0")})
    public static Double opDivide(IScope iScope, Double d, Integer n) throws GamaRuntimeException {
        if (n == 0) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return d / n.doubleValue();
    }

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns a float, equal to the division of the left-hand operand by the right-hand operand.", see={"*"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="0.2/0.5=0.4"), @GamlAnnotations.test(value="is_error(1.5/0.0)"), @GamlAnnotations.test(value="0.0/1.0=0.0")})
    public static Double opDivide(IScope iScope, Double d, Double d2) throws GamaRuntimeException {
        if (d2.equals(0.0)) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return d / d2;
    }

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns a float, equal to the division of the left-hand operand by the right-hand operand.", see={"*"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="1/0.5=2.0"), @GamlAnnotations.test(value="is_error(2/0.0)"), @GamlAnnotations.test(value="0/0.3=0.0")})
    public static Double opDivide(IScope iScope, Integer n, Double d) throws GamaRuntimeException {
        if (d.equals(0.0)) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return n.doubleValue() / d;
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the product of the two operands.", masterDoc=true, usages={@GamlAnnotations.usage(value="if both operands are numbers (float or int), performs a normal arithmetic product and returns a float if one of them is a float.", examples={@GamlAnnotations.example(value="1 * 1", equals="1")})}, see={"+", "-", "/"})
    public static Integer opTimes(Integer n, Integer n2) {
        return n * n2;
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the product of the two operands", examples={@GamlAnnotations.example(value="2.5 * 2", equals="5.0")}, see={"/"})
    public static Double opTimes(Double d, Integer n) {
        return d * (double)n.intValue();
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the product of the two operands", examples={}, see={"/"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="2.0 * 2.0 = 4.0"), @GamlAnnotations.test(value="1.5 * (- 1.0) = -1.5"), @GamlAnnotations.test(value="1.5 * 0.0 = 0.0")})
    public static Double opTimes(Double d, Double d2) {
        return d * d2;
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, concept={})
    @GamlAnnotations.doc(value="Returns the product of the two operands", examples={}, see={"/"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="2 * 2.0 = 4.0"), @GamlAnnotations.test(value="1 * (- 1.0) = -1.0"), @GamlAnnotations.test(value="1 * 0.0 = 0.0")})
    public static Double opTimes(Integer n, Double d) {
        return (double)n.intValue() * d;
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, content_type=-298, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if one operand is a matrix and the other a number (float or int), performs a normal arithmetic product of the number with each element of the matrix (results are float if the number is a float.", examples={@GamlAnnotations.example(value="2 * matrix([[2,5],[3,4]])", equals="matrix([[4,10],[6,8]])")})})
    public static IMatrix opTimes(Integer n, IMatrix iMatrix) {
        return iMatrix.times(n);
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, content_type=-199, category={"Arithmetic operators"}, concept={"matrix"}, doc={@GamlAnnotations.doc(value="Multiply all the elements in the matrix operand by the first operand")})
    @GamlAnnotations.test(value="2.0 * matrix([[2,5],[3,4]]) =  matrix([[4.0,10.0],[6.0,8.0]])")
    public static IMatrix opTimes(Double d, IMatrix iMatrix) {
        return iMatrix.times(d);
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the sum, union or concatenation of the two operands.", masterDoc=true, usages={@GamlAnnotations.usage(value="if both operands are numbers (float or int), performs a normal arithmetic sum and returns a float if one of them is a float.", examples={@GamlAnnotations.example(value="1 + 1", equals="2")})}, see={"-", "*", "/"})
    public static Integer opPlus(Integer n, Integer n2) {
        return n + n2;
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the sum, union or concatenation of the two operands.", examples={@GamlAnnotations.example(value="1.0 + 1", equals="2.0"), @GamlAnnotations.example(value="1.0 + 2.5", equals="3.5")})
    public static Double opPlus(Double d, Integer n) {
        return d + (double)n.intValue();
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the sum, union or concatenation of the two operands.")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="1.0 + (- 1.0) = 0.0"), @GamlAnnotations.test(value="1.0 + 1.0 = 2.0")})
    public static Double opPlus(Double d, Double d2) {
        return d + d2;
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the sum, union or concatenation of the two operands.")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="1 + (- 1.0) = 0.0"), @GamlAnnotations.test(value="1 + 1.0 = 2.0")})
    public static Double opPlus(Integer n, Double d) {
        return (double)n.intValue() + d;
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, content_type=-298, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if one operand is a matrix and the other a number (float or int), performs a normal arithmetic sum of the number with each element of the matrix (results are float if the number is a float.", examples={@GamlAnnotations.example(value="3.5 + matrix([[2,5],[3,4]])", equals="matrix([[5.5,8.5],[6.5,7.5]])")})})
    public static IMatrix opPlus(Integer n, IMatrix iMatrix) {
        return iMatrix.plus(n);
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, content_type=-199, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the sum of the two operands", examples={}, see={"/"})
    @GamlAnnotations.test(value="1.0 + matrix([[5.5,8.5],[6.5,7.5]]) = matrix([[6.5,9.5],[7.5,8.5]])")
    public static IMatrix opPlus(Double d, IMatrix iMatrix) {
        return iMatrix.plus(d);
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the difference of the two operands.", masterDoc=true, usages={@GamlAnnotations.usage(value="if both operands are numbers, performs a normal arithmetic difference and returns a float if one of them is a float.", examples={@GamlAnnotations.example(value="1 - 1", equals="0")})}, see={"+", "*", "/"})
    public static Integer opMinus(Integer n, Integer n2) {
        return n - n2;
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the difference of the two operands", examples={@GamlAnnotations.example(value="1.0 - 1", equals="0.0"), @GamlAnnotations.example(value="3.7 - 1", equals="2.7"), @GamlAnnotations.example(value="3.0 - 1", equals="2.0")})
    public static Double opMinus(Double d, Integer n) {
        return d - (double)n.intValue();
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the difference of the two operands", examples={@GamlAnnotations.example(value="1.0 - 1.0", equals="0.0"), @GamlAnnotations.example(value="3.7 - 1.2", equals="2.5"), @GamlAnnotations.example(value="3.0 - 1.2", equals="1.8")})
    public static Double opMinus(Double d, Double d2) {
        return d - d2;
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the difference of the two operands", examples={@GamlAnnotations.example(value="1 - 1.0", equals="0.0"), @GamlAnnotations.example(value="3 - 1.2", equals="1.8")})
    public static Double opMinus(Integer n, Double d) {
        return (double)n.intValue() - d;
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=-298, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the difference of the two operands", usages={@GamlAnnotations.usage(value="if one operand is a matrix and the other a number (float or int), performs a normal arithmetic difference of the number with each element of the matrix (results are float if the number is a float.", examples={@GamlAnnotations.example(value="3.5 - matrix([[2,5],[3,4]])", equals="matrix([[1.5,-1.5],[0.5,-0.5]])")})})
    public static IMatrix opMinus(Integer n, IMatrix iMatrix) {
        return iMatrix.times(-1).plus(n);
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=-199, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="the difference of the two operands", examples={@GamlAnnotations.example(value="(10.0 - (3.0 as_matrix({2,3})))", equals="matrix([[7.0,7.0,7.0],[7.0,7.0,7.0]])")})
    public static IMatrix opMinus(Double d, IMatrix iMatrix) {
        return iMatrix.times(-1).plus(d);
    }

    public static Double opTruncate(Double d, Integer n) {
        double d2;
        double d3;
        double d4 = d;
        int n2 = n;
        if (d4 > 0.0) {
            d3 = Maths.floor(d4);
            double d5 = Maths.pow((Double)10.0, (Integer)n2);
            d2 = (double)Maths.floor((d4 - d3) * d5) / d5;
        } else {
            d3 = Maths.ceil(d4);
            double d6 = Maths.pow((Integer)10, (Integer)n2);
            d2 = Maths.ceil((d4 - d3) * d6) / d6;
        }
        return d3 + d2;
    }

    @GamlAnnotations.operator(value={"with_precision"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Rounds off the value of left-hand operand to the precision given by the value of right-hand operand", examples={@GamlAnnotations.example(value="12345.78943 with_precision 2", equals="12345.79"), @GamlAnnotations.example(value="123 with_precision 2", equals="123.00")}, see={"round"})
    public static double round(Double d, Integer n) {
        long l = TENS[n];
        return (double)((long)(d > 0.0 ? d * (double)l + 0.5 : d * (double)l - 0.5)) / (double)l;
    }

    @GamlAnnotations.operator(value={"floor"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Maps the operand to the largest previous following integer, i.e. the largest integer not greater than x.", examples={@GamlAnnotations.example(value="floor(3)", equals="3"), @GamlAnnotations.example(value="floor(3.5)", equals="3"), @GamlAnnotations.example(value="floor(-4.7)", equals="-5")}, see={"ceil", "round"})
    public static final int floor(double d) {
        int n = (int)d;
        return d < (double)n ? n - 1 : n;
    }

    @GamlAnnotations.operator(value={"ceil"}, can_be_const=true, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Maps the operand to the smallest following integer, i.e. the smallest integer not less than x.", examples={@GamlAnnotations.example(value="ceil(3)", equals="3.0"), @GamlAnnotations.example(value="ceil(3.5)", equals="4.0"), @GamlAnnotations.example(value="ceil(-4.7)", equals="-4.0")}, see={"floor", "round"})
    public static final double ceil(double d) {
        return Math.ceil(d);
    }

    @GamlAnnotations.operator(value={"mod"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the remainder of the integer division of the left-hand operand by the right-hand operand.", usages={@GamlAnnotations.usage(value="if operands are float, they are truncated"), @GamlAnnotations.usage(value="if the right-hand operand is equal to zero, raises an exception.")}, examples={@GamlAnnotations.example(value="40 mod 3", equals="1")}, see={"div"})
    public static Integer opMod(IScope iScope, Integer n, Integer n2) {
        return n % n2;
    }

    @GamlAnnotations.operator(value={"div"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns the truncation of the division of the left-hand operand by the right-hand operand.", masterDoc=true, usages={@GamlAnnotations.usage(value="if the right-hand operand is equal to zero, raises an exception.")}, examples={@GamlAnnotations.example(value="40 div 3", equals="13")}, see={"mod"})
    public static Integer div(IScope iScope, Integer n, Integer n2) throws GamaRuntimeException {
        if (n2 == 0) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return n / n2;
    }

    @GamlAnnotations.operator(value={"div"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="an int, equal to the truncation of the division of the left-hand operand by the right-hand operand.", examples={@GamlAnnotations.example(value="40.5 div 3", equals="13")}, see={"mod"})
    public static Integer div(IScope iScope, Double d, Integer n) throws GamaRuntimeException {
        if (n == 0) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return (int)(d / (double)n.intValue());
    }

    @GamlAnnotations.operator(value={"div"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="an int, equal to the truncation of the division of the left-hand operand by the right-hand operand.", examples={@GamlAnnotations.example(value="40 div 4.1", equals="9")})
    public static Integer div(IScope iScope, Integer n, Double d) throws GamaRuntimeException {
        if (d.equals(0.0)) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return (int)((double)n.intValue() / d);
    }

    @GamlAnnotations.operator(value={"div"}, can_be_const=true, category={"Arithmetic operators"}, concept={})
    @GamlAnnotations.doc(value="an int, equal to the truncation of the division of the left-hand operand by the right-hand operand.", examples={@GamlAnnotations.example(value="40.1 div 4.5", equals="8")})
    public static Integer div(IScope iScope, Double d, Double d2) throws GamaRuntimeException {
        if (d2.equals(0.0)) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return (int)(d / d2);
    }

    @GamlAnnotations.operator(value={"atan2"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="the atan2 value of the two operands.", comment="The function atan2 is the arctangent function with two arguments. The purpose of using two arguments instead of one is to gather information on the signs of the inputs in order to return the appropriate quadrant of the computed angle, which is not possible for the single-argument arctangent function. Beware: the first argument is y and the second is x", masterDoc=true, examples={@GamlAnnotations.example(value="atan2 (0,0)", equals="0.0"), @GamlAnnotations.example(value="atan2 (0,1)", equals="0.0"), @GamlAnnotations.example(value="atan2 (0,-1)", equals="180.0"), @GamlAnnotations.example(value="atan2 (1,0)", equals="90.0"), @GamlAnnotations.example(value="atan2 (1,1)", equals="45.0"), @GamlAnnotations.example(value="atan2 (1,-1)", equals="135.0"), @GamlAnnotations.example(value="atan2 (-1,0)", equals="-90.0"), @GamlAnnotations.example(value="atan2 (-1,1)", equals="-45.0"), @GamlAnnotations.example(value="atan2 (-1,-1)", equals="-135.0")}, see={"atan", "acos", "asin"})
    public static double atan2(double d, double d2) {
        return Math.atan2(d, d2) * 57.29577951308232;
    }

    public static double checkHeading(int n) {
        double d = n;
        while (d < 0.0) {
            d += 360.0;
        }
        return d % 360.0;
    }

    public static double checkHeading(double d) {
        double d2 = d;
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        while (d2 > 360.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    @GamlAnnotations.operator(value={"hypot"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns sqrt(x2 +y2) without intermediate overflow or underflow.", special_cases={"If either argument is infinite, then the result is positive infinity. If either argument is NaN and neither argument is infinite, then the result is NaN."}, examples={@GamlAnnotations.example(value="hypot(0,1,0,1)", equals="sqrt(2)")})
    public static double hypot(IScope iScope, double d, double d2, double d3, double d4) {
        double d5 = d2 - d;
        double d6 = d4 - d3;
        return Maths.sqrt(iScope, d5 * d5 + d6 * d6);
    }

    @GamlAnnotations.operator(value={"is_number"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic", "type"})
    @GamlAnnotations.doc(value="Returns whether the argument is a real number or not", examples={@GamlAnnotations.example(value="is_number(4.66)", equals="true"), @GamlAnnotations.example(value="is_number(#infinity)", equals="true"), @GamlAnnotations.example(value="is_number(#nan)", equals="false")})
    public static Boolean is_number(Double d) {
        return !Double.isNaN(d);
    }

    @GamlAnnotations.operator(value={"is_finite"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns whether the argument is a finite number or not", examples={@GamlAnnotations.example(value="is_finite(4.66)", equals="true"), @GamlAnnotations.example(value="is_finite(#infinity)", equals="false")})
    public static Boolean is_finite(Double d) {
        return !Double.isInfinite(d);
    }

    @GamlAnnotations.operator(value={"signum"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns -1 if the argument is negative, +1 if it is positive, 0 if it is equal to zero or not a number", examples={@GamlAnnotations.example(value="signum(-12.8)", equals="-1"), @GamlAnnotations.example(value="signum(14.5)", equals="1"), @GamlAnnotations.example(value="signum(0.0)", equals="0")})
    public static Integer signum(Double d) {
        if (d == null || d.isNaN() || Comparison.equal(d, (Double)0.0).booleanValue()) {
            return 0;
        }
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    @GamlAnnotations.operator(value={"signum"}, can_be_const=true, category={"Arithmetic operators"}, concept={"math", "arithmetic"})
    @GamlAnnotations.doc(value="Returns -1 if the argument is negative, +1 if it is positive, 0 if it is equal to zero or not a number", examples={@GamlAnnotations.example(value="signum(-12)", equals="-1"), @GamlAnnotations.example(value="signum(14)", equals="1"), @GamlAnnotations.example(value="signum(0)", equals="0")})
    public static Integer signum(Integer n) {
        int n2 = n;
        return n2 < 0 ? -1 : (n2 == 0 ? 0 : 1);
    }
}

