/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.types.Types;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@GamlAnnotations.inside(symbols={"switch"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="value", type={0}, optional=true, doc={@GamlAnnotations.doc(value="The value or values this statement tries to match")})}, omissible="value")
@GamlAnnotations.doc(value="In a switch...match structure, the value of each match block is compared to the value in the switch. If they match, the embedded statement set is executed. Four kinds of match can be used, equality, containment, betweenness and regex matching", usages={@GamlAnnotations.usage(value="match block is executed if the switch value is equals to the value of the match:", examples={@GamlAnnotations.example(value="switch 3 {", test=false), @GamlAnnotations.example(value="   match 1 {write \"Match 1\"; }", test=false), @GamlAnnotations.example(value="   match 3 {write \"Match 2\"; }", test=false), @GamlAnnotations.example(value="}", test=false)}), @GamlAnnotations.usage(value="match_between block is executed if the switch value is in the interval given in value of the match_between:", examples={@GamlAnnotations.example(value="switch 3 {", test=false), @GamlAnnotations.example(value="   match_between [1,2] {write \"Match OK between [1,2]\"; }", test=false), @GamlAnnotations.example(value="   match_between [2,5] {write \"Match OK between [2,5]\"; }", test=false), @GamlAnnotations.example(value="}", test=false)}), @GamlAnnotations.usage(value="match_one block is executed if the switch value is equals to one of the values of the match_one:", examples={@GamlAnnotations.example(value="switch 3 {", test=false), @GamlAnnotations.example(value="   match_one [0,1,2] {write \"Match OK with one of [0,1,2]\"; }", test=false), @GamlAnnotations.example(value="   match_between [2,3,4,5] {write \"Match OK with one of [2,3,4,5]\"; }", test=false), @GamlAnnotations.example(value="}", test=false)})}, see={"switch", "default"})
public class MatchStatement
extends AbstractStatementSequence {
    final IExpression value = this.getFacet("value");
    Object constantValue;
    final MatchExecuter executer;

    public MatchStatement(IDescription iDescription) {
        super(iDescription);
        String string = iDescription.getKeyword();
        this.setName(string + " " + (this.value == null ? "" : this.value.serializeToGaml(false)));
        MatchExecuter matchExecuter = "match".equals(string) ? new SimpleMatch() : ("match_one".equals(string) ? new MatchOne() : ("match_between".equals(string) ? new MatchBetween() : (this.executer = "match_regex".equals(string) ? new MatchRegex() : null)));
        if (this.executer != null) {
            this.executer.acceptValue();
        }
    }

    public boolean matches(IScope iScope, Object object) throws GamaRuntimeException {
        if (this.executer == null) {
            return false;
        }
        return this.executer.matches(iScope, object);
    }

    class MatchBetween
    extends MatchExecuter {
        MatchBetween() {
        }

        @Override
        public boolean matches(IScope iScope, Object object) throws GamaRuntimeException {
            if (!(object instanceof Number)) {
                throw GamaRuntimeException.error("Can only match if a number is in an interval. " + String.valueOf(object) + " is not a number", iScope);
            }
            Object object2 = MatchStatement.this.value.value(iScope);
            if (!(object2 instanceof GamaPoint)) {
                object2 = Cast.asPoint(iScope, object2);
            }
            double d = ((GamaPoint)object2).getX();
            double d2 = ((GamaPoint)object2).getY();
            double d3 = ((Number)object).doubleValue();
            return d3 >= d && d3 <= d2;
        }

        @Override
        public void acceptValue() {
            super.acceptValue();
            if (MatchStatement.this.constantValue != null && !(MatchStatement.this.constantValue instanceof GamaPoint)) {
                MatchStatement.this.constantValue = Types.POINT.cast(null, MatchStatement.this.constantValue, null, false);
            }
        }
    }

    abstract class MatchExecuter {
        MatchExecuter() {
        }

        abstract boolean matches(IScope var1, Object var2) throws GamaRuntimeException;

        void acceptValue() {
            if (MatchStatement.this.value.isConst()) {
                MatchStatement.this.constantValue = MatchStatement.this.value.getConstValue();
            }
        }

        Object getValue(IScope iScope) throws GamaRuntimeException {
            return MatchStatement.this.constantValue == null ? MatchStatement.this.value.value(iScope) : MatchStatement.this.constantValue;
        }
    }

    class MatchOne
    extends MatchExecuter {
        MatchOne() {
        }

        @Override
        public boolean matches(IScope iScope, Object object) throws GamaRuntimeException {
            Object object2 = this.getValue(iScope);
            if (object2 instanceof IContainer) {
                return ((IContainer)object2).contains(iScope, object);
            }
            return Cast.asList(iScope, object2).contains(object);
        }

        @Override
        public void acceptValue() {
            super.acceptValue();
            if (MatchStatement.this.constantValue != null && !(MatchStatement.this.constantValue instanceof IContainer) && !(MatchStatement.this.constantValue instanceof GamaPoint)) {
                MatchStatement.this.constantValue = Types.LIST.cast(null, MatchStatement.this.constantValue, null, false);
            }
        }
    }

    class MatchRegex
    extends MatchExecuter {
        MatchRegex() {
        }

        @Override
        public boolean matches(IScope iScope, Object object) throws GamaRuntimeException {
            Object object2 = this.getValue(iScope);
            if (!(object instanceof String)) {
                throw GamaRuntimeException.error("Can only match strings against a regular expression. " + String.valueOf(object) + " is not a string", iScope);
            }
            if (!(object2 instanceof String)) {
                throw GamaRuntimeException.error("Can only match strings against a regular expression. " + String.valueOf(object2) + " is not a string", iScope);
            }
            String string = (String)object;
            String string2 = (String)object2;
            if (string2.isEmpty()) {
                return false;
            }
            try {
                Pattern pattern = Pattern.compile(string2);
                return pattern.matcher(string).find();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return string.contains(string2);
            }
        }

        @Override
        public void acceptValue() {
            super.acceptValue();
            if (MatchStatement.this.constantValue != null && !(MatchStatement.this.constantValue instanceof String)) {
                MatchStatement.this.constantValue = Types.STRING.cast(null, MatchStatement.this.constantValue, null, false);
            }
        }
    }

    class SimpleMatch
    extends MatchExecuter {
        SimpleMatch() {
        }

        @Override
        public boolean matches(IScope iScope, Object object) throws GamaRuntimeException {
            Object object2 = this.getValue(iScope);
            return object2 == null ? object == null : object2.equals(object);
        }
    }
}

