/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.MatchStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;

@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="value", type={0}, optional=false, doc={@GamlAnnotations.doc(value="an expression")})}, omissible="value")
@GamlAnnotations.doc(value="The \"switch... match\" statement is a powerful replacement for imbricated \"if ... else ...\" constructs. All the blocks that match are executed in the order they are defined, unless one invokes 'break', in which case the switch statement is exited. The block prefixed by default is executed only if none have matched (otherwise it is not).", usages={@GamlAnnotations.usage(value="The prototypical syntax is as follows:", examples={@GamlAnnotations.example(value="switch an_expression {", isExecutable=false), @GamlAnnotations.example(value="        match value1 {...}", isExecutable=false), @GamlAnnotations.example(value="        match_one [value1, value2, value3] {...}", isExecutable=false), @GamlAnnotations.example(value="        match_between [value1, value2] {...}", isExecutable=false), @GamlAnnotations.example(value="        default {...}", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="Example:", examples={@GamlAnnotations.example(value="switch 3 {", test=false), @GamlAnnotations.example(value="   match 1 {write \"Match 1\"; }", test=false), @GamlAnnotations.example(value="   match 2 {write \"Match 2\"; }", test=false), @GamlAnnotations.example(value="   match 3 {write \"Match 3\"; }", test=false), @GamlAnnotations.example(value="   match_one [4,4,6,3,7]  {write \"Match one_of\"; }", test=false), @GamlAnnotations.example(value="   match_between [2, 4] {write \"Match between\"; }", test=false), @GamlAnnotations.example(value="   default {write \"Match Default\"; }", test=false), @GamlAnnotations.example(value="}", test=false), @GamlAnnotations.example(value="string val1 <- \"\";", test=false, isTestOnly=true), @GamlAnnotations.example(value="switch 1 {", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match 1 {val1 <- val1 + \"1\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match 2 {val1 <- val1 + \"2\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match_one [1,1,6,4,7]  {val1 <- val1 + \"One_of\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match_between [2, 4] {val1 <- val1 + \"Between\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   default {val1 <- val1 + \"Default\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="}", test=false, isTestOnly=true), @GamlAnnotations.example(var="val1", equals="'1One_of'", isTestOnly=true), @GamlAnnotations.example(value="string val2 <- \"\";", test=false, isTestOnly=true), @GamlAnnotations.example(value="switch 2 {", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match 1 {val2 <- val2 + \"1\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match 2 {val2 <- val2 + \"2\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match_one [1,1,6,4,7]  {val2 <- val2 + \"One_of\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match_between [2, 4] {val2 <- val2 + \"Between\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   default {val2 <- val2 + \"Default\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="}", test=false, isTestOnly=true), @GamlAnnotations.example(var="val2", equals="'2Between'", isTestOnly=true), @GamlAnnotations.example(value="string val10 <- \"\";", test=false, isTestOnly=true), @GamlAnnotations.example(value="switch 10 {", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match 1 {val10 <- val10 + \"1\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match 2 {val10 <- val10 + \"2\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match_one [1,1,6,4,7]  {val10 <- val10 + \"One_of\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   match_between [2, 4] {val10 <- val10 + \"Between\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="   default {val10 <- val10 + \"Default\"; }", test=false, isTestOnly=true), @GamlAnnotations.example(value="}", test=false, isTestOnly=true), @GamlAnnotations.example(var="val10", equals="'Default'", isTestOnly=true)})}, see={"match", "default", "if"})
@validator(value=SwitchValidator.class)
public class SwitchStatement
extends AbstractStatementSequence
implements IStatement.Breakable {
    public MatchStatement[] matches;
    public MatchStatement defaultMatch;
    final IExpression value = this.getFacet("value");

    public SwitchStatement(IDescription iDescription) {
        super(iDescription);
        this.setName("switch" + this.value.serializeToGaml(false));
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        ArrayList<MatchStatement> arrayList = new ArrayList<MatchStatement>();
        for (ISymbol iSymbol2 : iterable) {
            if (!(iSymbol2 instanceof MatchStatement)) continue;
            if ("default".equals(((MatchStatement)iSymbol2).getKeyword())) {
                this.defaultMatch = (MatchStatement)iSymbol2;
                continue;
            }
            arrayList.add((MatchStatement)iSymbol2);
        }
        this.matches = arrayList.toArray(new MatchStatement[arrayList.size()]);
        super.setChildren(Iterables.filter(iterable, iSymbol -> iSymbol != this.defaultMatch || !arrayList.contains(iSymbol)));
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        boolean bl = false;
        Object object = this.value.value(iScope);
        Object object2 = null;
        try {
            MatchStatement[] matchStatementArray = this.matches;
            int n = this.matches.length;
            int n2 = 0;
            while (n2 < n) {
                MatchStatement matchStatement = matchStatementArray[n2];
                if (matchStatement.matches(iScope, object)) {
                    ExecutionResult executionResult = iScope.execute(matchStatement);
                    if (!executionResult.passed()) {
                        Object object3 = object2;
                        return object3;
                    }
                    object2 = executionResult.getValue();
                    bl = true;
                }
                if (iScope.getAndClearBreakStatus() == FlowStatus.BREAK || iScope.interrupted()) {
                    Object object4 = object2;
                    return object4;
                }
                ++n2;
            }
            if (!bl && this.defaultMatch != null) {
                Object object5 = iScope.execute(this.defaultMatch).getValue();
                return object5;
            }
            Object object6 = object2;
            return object6;
        }
        finally {
            iScope.getAndClearBreakStatus();
        }
    }

    @Override
    public void leaveScope(IScope iScope) {
        super.leaveScope(iScope);
    }

    @Override
    public void dispose() {
        if (this.matches != null) {
            MatchStatement[] matchStatementArray = this.matches;
            int n = this.matches.length;
            int n2 = 0;
            while (n2 < n) {
                MatchStatement matchStatement = matchStatementArray[n2];
                matchStatement.dispose();
                ++n2;
            }
        }
        this.matches = null;
        if (this.defaultMatch != null) {
            this.defaultMatch.dispose();
        }
        this.defaultMatch = null;
        super.dispose();
    }

    public static class SwitchValidator
    implements IDescriptionValidator {
        public void validate(IDescription iDescription) {
            Iterable<IDescription> iterable = iDescription.getChildrenWithKeyword("match");
            IExpression iExpression = iDescription.getFacetExpr("value");
            if (iExpression == null) {
                return;
            }
            IType<?> iType = iExpression.getGamlType();
            if (iType.equals(Types.NO_TYPE)) {
                return;
            }
            for (IDescription iDescription2 : iterable) {
                IExpression iExpression2 = iDescription2.getFacetExpr("value");
                if (iExpression2 == null) continue;
                IType<?> iType2 = iExpression2.getGamlType();
                if (Types.intFloatCase(iType2, iType)) {
                    iDescription2.warning("The value " + iExpression2.serializeToGaml(false) + " of type " + String.valueOf(iType2) + " is compared to a value of type " + String.valueOf(iType) + ", which will never match ", "gaml.casting.issue", "value", iType.toString());
                    continue;
                }
                if (iType2.isTranslatableInto(iType)) continue;
                iDescription2.warning("The value " + iExpression2.serializeToGaml(false) + " of type " + String.valueOf(iType2) + " is compared to a value of type " + String.valueOf(iType) + ", which will never match ", "gaml.casting.issue", "value", iType.toString());
            }
        }
    }
}

