/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IMap;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.types.GamaType;

@GamlAnnotations.type(name="action", id=26, wraps={IDescription.class}, kind=104, doc={@GamlAnnotations.doc(value="The type of the variables that denote an action or an aspect of a species")}, concept={"type", "action", "species"})
public class GamaActionType
extends GamaType<IDescription> {
    @Override
    public boolean canCastToConst() {
        return false;
    }

    @Override
    @GamlAnnotations.doc(value="Converts the argument into the reference to an action. If it is a string, its name is looked up in the current agent species")
    public IDescription cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        if (object == null) {
            return null;
        }
        if (object instanceof IDescription) {
            return (IDescription)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            ActionDescription actionDescription = iScope.getAgent().getSpecies().getDescription().getAction(string);
            if (actionDescription != null) {
                return actionDescription;
            }
            return iScope.getAgent().getSpecies().getDescription().getAspect(string);
        }
        return null;
    }

    @Override
    public IDescription getDefault() {
        return null;
    }

    @Override
    public boolean isDrawable() {
        return true;
    }

    @Override
    public IDescription deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        return this.cast(iScope, iMap.get("name"), null, false);
    }
}

