/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.agent;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.IScoped;
import gama.core.common.interfaces.IStepable;
import gama.core.common.interfaces.IVarAndActionSupport;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.AgentReference;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.agent.ISerialisedAgent;
import gama.core.metamodel.agent.SerialisedAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.interfaces.IAttributed;
import gama.gaml.interfaces.INamed;
import gama.gaml.species.ISpecies;
import gama.gaml.variables.IVariable;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="name", type=4, doc={@GamlAnnotations.doc(value="Returns the name of the agent (not necessarily unique in its population)")}), @GamlAnnotations.variable(name="index", type=1, constant=true, doc={@GamlAnnotations.doc(value="Returns the unique index of this agent in its population. Read-only attribute")}), @GamlAnnotations.variable(name="peers", type=5, of=-199, doc={@GamlAnnotations.doc(value="Returns the population of agents of the same species, in the same host, minus the receiver agent")}), @GamlAnnotations.variable(name="host", type=-29, doc={@GamlAnnotations.doc(value="Returns the agent that hosts the population of the receiver agent")}), @GamlAnnotations.variable(name="location", type=7, depends_on={"shape"}, doc={@GamlAnnotations.doc(value="Returns the location of the agent")}), @GamlAnnotations.variable(name="shape", type=13, doc={@GamlAnnotations.doc(value="Returns the shape of the receiver agent")})})
@GamlAnnotations.doc(value="The species hierarchy derives from a single built-in species, which is 'agent'. All its components (attributes, actions) will then be inherited by all direct or indirect children species (including 'model' and 'experiment' except species that explicitly set 'use_minimal_agents' facet to 'true', which inherit from a stripped-down version of 'agent'. ")
public interface IAgent
extends IShape,
INamed,
IAttributed,
Comparable<IAgent>,
IStepable,
IContainer.Addressable<String, Object>,
IVarAndActionSupport,
IScoped {
    public ITopology getTopology();

    @GamlAnnotations.setter(value="peers")
    public void setPeers(IList<IAgent> var1);

    @GamlAnnotations.getter(value="peers")
    public IList<IAgent> getPeers() throws GamaRuntimeException;

    @Override
    @GamlAnnotations.getter(value="name", initializer=true)
    public String getName();

    @Override
    @GamlAnnotations.setter(value="name")
    public void setName(String var1);

    @Override
    default public GamaPoint getLocation() {
        return this.getLocation(this.getScope());
    }

    @GamlAnnotations.getter(value="location", initializer=true)
    public GamaPoint getLocation(IScope var1);

    @GamlAnnotations.setter(value="location")
    public GamaPoint setLocation(IScope var1, GamaPoint var2);

    @Override
    default public GamaPoint setLocation(GamaPoint gamaPoint) {
        return this.setLocation(this.getScope(), gamaPoint);
    }

    @GamlAnnotations.getter(value="shape")
    public IShape getGeometry(IScope var1);

    @Override
    default public IShape getGeometry() {
        return this.getGeometry(this.getScope());
    }

    @GamlAnnotations.setter(value="shape")
    public void setGeometry(IScope var1, IShape var2);

    @Override
    default public void setGeometry(IShape iShape) {
        this.setGeometry(this.getScope(), iShape);
    }

    public boolean dead();

    @GamlAnnotations.getter(value="host")
    public IMacroAgent getHost();

    default public ITopLevelAgent getTopLevelHost() {
        IMacroAgent iMacroAgent = this.getHost();
        if (iMacroAgent instanceof ITopLevelAgent) {
            ITopLevelAgent iTopLevelAgent = (ITopLevelAgent)iMacroAgent;
            return iTopLevelAgent;
        }
        if (iMacroAgent == null) {
            return null;
        }
        return iMacroAgent.getTopLevelHost();
    }

    @GamlAnnotations.setter(value="host")
    public void setHost(IMacroAgent var1);

    public void schedule(IScope var1);

    @GamlAnnotations.getter(value="index")
    public int getIndex();

    public String getSpeciesName();

    public ISpecies getSpecies();

    public IPopulation<? extends IAgent> getPopulation();

    public boolean isInstanceOf(ISpecies var1, boolean var2);

    public Object getDirectVarValue(IScope var1, String var2) throws GamaRuntimeException;

    public void setDirectVarValue(IScope var1, String var2, Object var3) throws GamaRuntimeException;

    default public void notifyVarValueChange(String string, Object object) {
        IVariable iVariable = this.getSpecies().getVar(string);
        if (iVariable == null) {
            return;
        }
        iVariable.notifyOfValueChange(this.getScope(), this, null, object);
    }

    public List<IAgent> getMacroAgents();

    public IModel getModel();

    public boolean isInstanceOf(String var1, boolean var2);

    public IPopulation<? extends IAgent> getPopulationFor(ISpecies var1);

    public IPopulation<? extends IAgent> getPopulationFor(String var1);

    public void updateWith(IScope var1, ISerialisedAgent var2);

    @Override
    default public Double getArea() {
        return this.getGeometry().getArea();
    }

    @Override
    default public Double getVolume() {
        return this.getGeometry().getVolume();
    }

    @Override
    default public double getPerimeter() {
        return this.getGeometry().getPerimeter();
    }

    @Override
    default public IList<GamaShape> getHoles() {
        return this.getGeometry().getHoles();
    }

    @Override
    default public GamaPoint getCentroid() {
        return this.getGeometry().getCentroid();
    }

    @Override
    default public GamaShape getExteriorRing(IScope iScope) {
        return this.getGeometry().getExteriorRing(iScope);
    }

    @Override
    default public Double getWidth() {
        return this.getGeometry().getWidth();
    }

    @Override
    default public Double getHeight() {
        return this.getGeometry().getHeight();
    }

    @Override
    default public Double getDepth() {
        return this.getGeometry().getDepth();
    }

    @Override
    default public GamaShape getGeometricEnvelope() {
        return this.getGeometry().getGeometricEnvelope();
    }

    @Override
    default public IList<? extends IShape> getGeometries() {
        return this.getGeometry().getGeometries();
    }

    @Override
    default public boolean isMultiple() {
        return this.getGeometry().isMultiple();
    }

    @Override
    default public boolean isPoint() {
        return this.getGeometry().isPoint();
    }

    @Override
    default public boolean isLine() {
        return this.getGeometry().isLine();
    }

    @Override
    default public Geometry getInnerGeometry() {
        return this.getGeometry().getInnerGeometry();
    }

    @Override
    default public Envelope3D getEnvelope() {
        IShape iShape = this.getGeometry();
        return iShape == null ? null : iShape.getEnvelope();
    }

    @Override
    default public boolean covers(IShape iShape) {
        return this.getGeometry().covers(iShape);
    }

    @Override
    default public double euclidianDistanceTo(IShape iShape) {
        return this.getGeometry().euclidianDistanceTo(iShape);
    }

    @Override
    default public double euclidianDistanceTo(GamaPoint gamaPoint) {
        return this.getGeometry().euclidianDistanceTo(gamaPoint);
    }

    @Override
    default public boolean intersects(IShape iShape) {
        return this.getGeometry().intersects(iShape);
    }

    @Override
    default public boolean partiallyOverlaps(IShape iShape) {
        return this.getGeometry().partiallyOverlaps(iShape);
    }

    @Override
    default public boolean touches(IShape iShape) {
        return this.getGeometry().touches(iShape);
    }

    @Override
    default public boolean crosses(IShape iShape) {
        return this.getGeometry().crosses(iShape);
    }

    @Override
    default public void setInnerGeometry(Geometry geometry) {
        this.getGeometry().setInnerGeometry(geometry);
    }

    @Override
    default public IList<GamaPoint> getPoints() {
        if (this.getGeometry() == null) {
            return GamaListFactory.EMPTY_LIST;
        }
        return this.getGeometry().getPoints();
    }

    @Override
    default public void setDepth(double d) {
        if (this.getGeometry() == null) {
            return;
        }
        this.getGeometry().setDepth(d);
    }

    @Override
    default public void setGeometricalType(IShape.Type type2) {
        this.getGeometry().setGeometricalType(type2);
    }

    @GamlAnnotations.action(name="die", doc={@GamlAnnotations.doc(value="Kills the agent and disposes of it. Once dead, the agent cannot behave anymore")})
    public Object primDie(IScope var1);

    @Override
    default public int intValue(IScope iScope) {
        return this.getIndex();
    }

    default public SimulationAgent getSimulation() {
        return this.getPopulation().getHost().getSimulation();
    }

    @Override
    default public JsonValue serializeToJson(Json json) {
        AgentReference agentReference = AgentReference.of(this);
        json.addRef(agentReference.toString(), () -> SerialisedAgent.of(this, false));
        return json.valueOf(agentReference);
    }
}

