/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.projection;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.IScope;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.geotools.geometry.jts.DefaultCoordinateSequenceTransformer;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class Projection
implements IProjection {
    private final ProjectionFactory factory;
    private GeometryCoordinateSequenceTransformer transformer;
    private GeometryCoordinateSequenceTransformer inverseTransformer;
    CoordinateReferenceSystem initialCRS;
    Envelope3D projectedEnv;
    final IProjection referenceProjection;

    Projection(IProjection iProjection, ProjectionFactory projectionFactory) {
        this.referenceProjection = iProjection;
        this.factory = projectionFactory;
    }

    Projection(IScope iScope, IProjection iProjection, CoordinateReferenceSystem coordinateReferenceSystem, Envelope3D envelope3D, ProjectionFactory projectionFactory) {
        this.factory = projectionFactory;
        this.referenceProjection = iProjection;
        this.initialCRS = coordinateReferenceSystem;
        if (envelope3D != null) {
            if (this.initialCRS != null && !this.initialCRS.equals(this.getTargetCRS(iScope))) {
                this.createTransformation(this.computeProjection(iScope));
            }
            this.projectedEnv = this.transform(envelope3D);
        }
    }

    @Override
    public void createTransformation(MathTransform mathTransform) {
        if (mathTransform != null) {
            this.transformer = new GeometryCoordinateSequenceTransformer((CoordinateSequenceTransformer)new DefaultCoordinateSequenceTransformer((CoordinateSequenceFactory)GeometryUtils.GEOMETRY_FACTORY.getCoordinateSequenceFactory()));
            this.transformer.setMathTransform(mathTransform);
            try {
                this.inverseTransformer = new GeometryCoordinateSequenceTransformer((CoordinateSequenceTransformer)new DefaultCoordinateSequenceTransformer((CoordinateSequenceFactory)GeometryUtils.GEOMETRY_FACTORY.getCoordinateSequenceFactory()));
                this.inverseTransformer.setMathTransform(mathTransform.inverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
    }

    @Override
    public Geometry transform(Geometry geometry) {
        if (geometry instanceof GeometryCollection && geometry.getNumGeometries() == 1) {
            return this.transform(geometry.getGeometryN(0));
        }
        return this.transform(geometry, true);
    }

    public Geometry transform(Geometry geometry, boolean bl) {
        Geometry geometry2 = GeometryUtils.GEOMETRY_FACTORY.createGeometry(geometry);
        if (this.transformer != null) {
            try {
                geometry2 = this.transformer.transform(geometry2);
            }
            catch (TransformException transformException) {
                transformException.printStackTrace();
            }
        }
        if (bl) {
            this.translate(geometry2);
            this.convertUnit(geometry2);
        }
        return geometry2;
    }

    Envelope3D transform(Envelope3D envelope3D) {
        if (this.transformer == null) {
            return envelope3D;
        }
        return Envelope3D.of(this.transform((Geometry)JTS.toGeometry((Envelope)envelope3D)).getEnvelopeInternal());
    }

    @Override
    public Geometry inverseTransform(Geometry geometry) {
        Geometry geometry2 = GeometryUtils.GEOMETRY_FACTORY.createGeometry(geometry);
        this.inverseConvertUnit(geometry2);
        this.inverseTranslate(geometry2);
        if (this.inverseTransformer != null) {
            try {
                geometry2 = this.inverseTransformer.transform(geometry2);
            }
            catch (TransformException transformException) {
                transformException.printStackTrace();
            }
        }
        return geometry2;
    }

    MathTransform computeProjection(IScope iScope) {
        MathTransform mathTransform = null;
        if (this.initialCRS == null) {
            return null;
        }
        try {
            mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.initialCRS, (CoordinateReferenceSystem)this.getTargetCRS(iScope), (boolean)true);
        }
        catch (FactoryException factoryException) {
            factoryException.printStackTrace();
            return null;
        }
        return mathTransform;
    }

    @Override
    public CoordinateReferenceSystem getInitialCRS(IScope iScope) {
        return this.initialCRS;
    }

    @Override
    public Envelope3D getProjectedEnvelope() {
        return this.projectedEnv;
    }

    @Override
    public CoordinateReferenceSystem getTargetCRS(IScope iScope) {
        if (this.referenceProjection != null) {
            return this.referenceProjection.getTargetCRS(iScope);
        }
        return this.factory.getTargetCRS(iScope);
    }

    @Override
    public void translate(Geometry geometry) {
        if (this.referenceProjection != null) {
            this.referenceProjection.translate(geometry);
        }
    }

    @Override
    public void inverseTranslate(Geometry geometry) {
        if (this.referenceProjection != null) {
            this.referenceProjection.inverseTranslate(geometry);
        }
    }

    @Override
    public void convertUnit(Geometry geometry) {
        if (this.referenceProjection != null) {
            this.referenceProjection.convertUnit(geometry);
        }
    }

    @Override
    public void inverseConvertUnit(Geometry geometry) {
        if (this.referenceProjection != null) {
            this.referenceProjection.inverseConvertUnit(geometry);
        }
    }
}

