/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.runtime.IScope;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonAbstractObject;
import gama.core.util.file.json.JsonObjectMember;
import gama.core.util.file.json.JsonWriter;
import gama.gaml.types.IType;
import gama.gaml.types.ITypesManager;
import gama.gaml.types.Types;
import java.io.IOException;

public class JsonGamlObject
extends JsonAbstractObject {
    final String type;

    public JsonGamlObject(String string, Json json) {
        super(json);
        this.type = string;
    }

    public JsonGamlObject(String string, JsonAbstractObject jsonAbstractObject, Json json) {
        this(string, json);
        for (JsonObjectMember jsonObjectMember : jsonAbstractObject) {
            this.add(jsonObjectMember.getName(), jsonObjectMember.getValue());
        }
    }

    @Override
    public Object toGamlValue(IScope iScope) {
        ITypesManager iTypesManager = iScope == null ? Types.builtInTypes : iScope.getTypes();
        IType iType = iTypesManager.decodeType(this.type);
        return iType.deserializeFromJson(iScope, this.toMap(iScope));
    }

    @Override
    protected void writeMembers(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeMemberName("gaml_type");
        jsonWriter.writeMemberSeparator();
        jsonWriter.writeString(this.type);
        jsonWriter.writeObjectSeparator();
        super.writeMembers(jsonWriter);
    }

    @Override
    public boolean isGamlObject() {
        return true;
    }

    @Override
    public JsonGamlObject asGamlObject() {
        return this;
    }
}

