/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.weighted_tasks;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.architecture.weighted_tasks.WeightedTaskStatement;
import gama.gaml.architecture.weighted_tasks.WeightedTasksArchitecture;
import gama.gaml.compilation.ISymbol;
import gama.gaml.statements.IExecutable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

@GamlAnnotations.skill(name="sorted_tasks", concept={"architecture", "behavior", "task_based"})
@GamlAnnotations.doc(value="A control architecture, based on the concept of tasks, which are executed in an order defined by their weight. This skill extends the WeightedTasksArchitecture skill and take all his actions and variables")
public class SortedTasksArchitecture
extends WeightedTasksArchitecture {
    public static final String ST = "sorted_tasks";
    final Map<WeightedTaskStatement, Double> weights = new HashMap<WeightedTaskStatement, Double>();
    Comparator<WeightedTaskStatement> sortBlock = (weightedTaskStatement, weightedTaskStatement2) -> this.weights.get(weightedTaskStatement).compareTo(this.weights.get(weightedTaskStatement2));

    /*
     * WARNING - void declaration
     */
    @Override
    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        void var2_6;
        super.executeOn(iScope);
        for (Map.Entry<WeightedTaskStatement, Double> object2 : this.weights.entrySet()) {
            object2.setValue(object2.getKey().computeWeight(iScope));
        }
        Collections.sort(this.tasks, this.sortBlock);
        Object var2_5 = null;
        int n = this.tasks.size() - 1;
        while (n >= 0) {
            ExecutionResult executionResult = iScope.execute((IExecutable)this.tasks.get(n));
            if (!executionResult.passed()) {
                return var2_6;
            }
            Object object = executionResult.getValue();
            --n;
        }
        return var2_6;
    }

    @Override
    protected WeightedTaskStatement chooseTask(IScope iScope) throws GamaRuntimeException {
        return null;
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        super.setChildren(iterable);
        for (WeightedTaskStatement weightedTaskStatement : this.tasks) {
            this.weights.put(weightedTaskStatement, 0.0);
        }
    }
}

