/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation.ast;

import gama.core.common.interfaces.IDisposable;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.interfaces.INamed;
import gama.gaml.statements.Facets;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;

public interface ISyntacticElement
extends INamed,
IDisposable {
    public static final SyntacticVisitor DISPOSE_VISITOR = IDisposable::dispose;
    public static final Predicate<ISyntacticElement> SPECIES_FILTER = iSyntacticElement -> iSyntacticElement.isSpecies() && !"grid".equals(iSyntacticElement.getKeyword());
    public static final Predicate<ISyntacticElement> GRID_FILTER = iSyntacticElement -> "grid".equals(iSyntacticElement.getKeyword());
    public static final Predicate<ISyntacticElement> EXPERIMENT_FILTER = ISyntacticElement::isExperiment;
    public static final Predicate<ISyntacticElement> OTHER_FILTER = iSyntacticElement -> !iSyntacticElement.isExperiment() && !iSyntacticElement.isSpecies();

    public void setKeyword(String var1);

    public String getKeyword();

    public boolean hasFacet(String var1);

    public IExpressionDescription getExpressionAt(String var1);

    public Facets copyFacets(SymbolProto var1);

    public void setFacet(String var1, IExpressionDescription var2);

    public void visitFacets(IDescription.IFacetVisitor var1);

    @Override
    public String getName();

    public EObject getElement();

    public void addChild(ISyntacticElement var1);

    public boolean isSpecies();

    public boolean isExperiment();

    public boolean hasFacets();

    public void computeStats(Map<String, Integer> var1);

    public void visitThisAndAllChildrenRecursively(SyntacticVisitor var1);

    public void visitChildren(SyntacticVisitor var1);

    public void visitSpecies(SyntacticVisitor var1);

    public void visitExperiments(SyntacticVisitor var1);

    public void visitGrids(SyntacticVisitor var1);

    public void compact();

    public boolean hasChildren();

    public void visitAllChildren(SyntacticVisitor var1);

    default public Map<String, List<String>> getPragmas() {
        return null;
    }

    default public void clear() {
    }

    public static interface SyntacticVisitor {
        public void visit(ISyntacticElement var1);
    }
}

