/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.StatementWithChildrenDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.Facets;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class ActionDescription
extends StatementWithChildrenDescription {
    public static final Arguments NULL_ARGS = new Arguments();

    public ActionDescription(String string, IDescription iDescription, Iterable<IDescription> iterable, EObject eObject, Facets facets2) {
        super(string, iDescription, iterable, true, eObject, facets2, null);
        this.setIf(IDescription.Flag.Abstract, "true".equals(this.getLitteral("virtual")));
        if (this.getName() != null && this.getName().startsWith("__synthetic__")) {
            this.set(IDescription.Flag.Synthetic);
            this.unSet(IDescription.Flag.BuiltIn);
        }
        this.removeFacets("virtual");
    }

    @Override
    public ActionDescription copy(IDescription iDescription) {
        ActionDescription actionDescription = new ActionDescription(this.getKeyword(), iDescription, this.children, this.element, this.getFacetsCopy());
        actionDescription.originName = this.getOriginName();
        return actionDescription;
    }

    public boolean isAbstract() {
        return this.isSet(IDescription.Flag.Abstract);
    }

    @Override
    protected boolean isSynthetic() {
        return this.isSet(IDescription.Flag.Synthetic);
    }

    public List<String> getArgNames() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.getFormalArgs(), (Function)TO_NAME));
    }

    public boolean verifyArgs(IDescription iDescription2, Arguments arguments) {
        Iterable<String> iterable;
        Arguments arguments2 = arguments == null ? NULL_ARGS : arguments;
        Iterable<IDescription> iterable2 = this.getFormalArgs();
        boolean bl = arguments2.isEmpty();
        if (bl && Iterables.isEmpty(iterable = Iterables.filter(iterable2, iDescription -> !iDescription.hasFacet("default")))) {
            return true;
        }
        iterable = this.getArgNames();
        if (iDescription2.isInvocation() && arguments2.containsKey("0")) {
            this.replaceNumberedArgs(arguments2, (List<String>)iterable);
        }
        if (iterable2 != null) {
            for (IDescription iDescription3 : iterable2) {
                String string2 = iDescription3.getName();
                if (iDescription3.hasFacet("default")) {
                    iDescription3.getFacet("default").compile(this);
                    continue;
                }
                if (arguments2.containsKey(string2) || (!iDescription3.hasFacet("optional") || !iDescription3.getFacet("optional").equalsString("false")) && iDescription3.hasFacet("optional")) continue;
                iDescription2.error("Missing argument " + string2 + " in call to " + this.getName() + ". Arguments passed are : " + String.valueOf(arguments2), "gaml.missing.argument.issue", iDescription2.getUnderlyingElement(), string2);
                return false;
            }
        }
        return arguments2.forEachFacet((string, iExpressionDescription) -> {
            if (iExpressionDescription != null) {
                if (!iterable.contains(string)) {
                    iDescription2.error("Unknown argument " + string + " in call to " + this.getName(), "gaml.unknonw.argument.issue", iExpressionDescription.getTarget(), (String)string);
                    return false;
                }
                if (iExpressionDescription.getExpression() != null) {
                    IType<?> iType;
                    IDescription iDescription3 = (IDescription)Iterables.find((Iterable)iterable2, iDescription -> iDescription.getName().equals(string));
                    if (iDescription3.isID()) {
                        return true;
                    }
                    IType<?> iType2 = iDescription3.getGamlType();
                    if (!Types.intFloatCase(iType2, iType = iExpressionDescription.getExpression().getGamlType())) {
                        boolean bl = iType2 == Types.NO_TYPE || iType.isTranslatableInto(iType2);
                        boolean bl2 = bl = bl || iType == Types.NO_TYPE && iType2.getDefault() == null;
                        if (!bl) {
                            iDescription2.error("The type of argument " + string + " should be " + String.valueOf(iType2), "gaml.wrong.type.issue", iExpressionDescription.getTarget(), new String[0]);
                            return false;
                        }
                        return true;
                    }
                    iDescription2.warning("The argument " + string + " (of type " + String.valueOf(iType) + ") will be casted to " + String.valueOf(iType2), "gaml.wrong.type.issue", iExpressionDescription.getTarget(), new String[0]);
                }
                return true;
            }
            return false;
        });
    }

    private void replaceNumberedArgs(Arguments arguments, List<String> list) {
        int n = 0;
        for (String string : list) {
            String string2;
            IExpressionDescription iExpressionDescription;
            if ((iExpressionDescription = (IExpressionDescription)arguments.get(string2 = String.valueOf(n++))) == null) continue;
            arguments.put(string, iExpressionDescription);
            arguments.remove(string2);
        }
    }

    public boolean containsArg(String string) {
        IDescription iDescription2 = (IDescription)Iterables.find(this.getFormalArgs(), iDescription -> iDescription.getName().equals(string));
        return iDescription2 != null;
    }

    @Override
    public Arguments createCompiledArgs() {
        Arguments arguments = new Arguments();
        for (IDescription iDescription : this.getFormalArgs()) {
            String string = iDescription.getName();
            IExpression iExpression = null;
            IDescription iDescription2 = this.getEnclosingDescription();
            IExpressionDescription iExpressionDescription = iDescription.getFacet("value", "default");
            if (iExpressionDescription != null) {
                iExpression = iExpressionDescription.compile(iDescription2);
            }
            arguments.putExpression(string, iExpression);
        }
        return arguments;
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        IGamlDescription.Doc doc2 = this.getShortDocumentation(false);
        if (this.getArgNames().size() > 0) {
            this.getFormalArgs().forEach(iDescription -> {
                StringBuilder stringBuilder = new StringBuilder(100);
                stringBuilder.append(iDescription.getGamlType());
                if (iDescription.hasFacet("default") && iDescription.getFacetExpr("default") != null) {
                    stringBuilder.append(" <i>(default: ").append(iDescription.getFacetExpr("default").serializeToGaml(false)).append(")</i>");
                }
                doc2.set("Arguments accepted: ", iDescription.getName(), new IGamlDescription.ConstantDoc(stringBuilder.toString()));
            });
        }
        return doc2;
    }

    public IGamlDescription.Doc getShortDocumentation(boolean bl) {
        CharSequence charSequence;
        IGamlDescription.RegularDoc regularDoc = new IGamlDescription.RegularDoc();
        Iterable<IDescription> iterable = this.getFormalArgs();
        if (bl && Iterables.size(iterable) > 0) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("(");
            for (IDescription object2 : iterable) {
                ((StringBuilder)charSequence).append(object2.getGamlType()).append(" ").append(object2.getName()).append(", ");
            }
            if (((StringBuilder)charSequence).length() > 0) {
                ((StringBuilder)charSequence).setLength(((StringBuilder)charSequence).length() - 2);
            }
            ((StringBuilder)charSequence).append(")");
            regularDoc.append(((StringBuilder)charSequence).toString());
        } else {
            regularDoc.append("no arguments");
        }
        charSequence = this.getGamlType().equals(Types.NO_TYPE) ? ", no value returned" : ", returns a result of type " + this.getGamlType().getName();
        regularDoc.append((String)charSequence);
        String string = this.getBuiltInDoc();
        if (string != null && !string.isBlank()) {
            regularDoc.append(". ").append(string);
        }
        regularDoc.append("<br/>");
        return regularDoc;
    }

    protected String getBuiltInDoc() {
        return null;
    }
}

