/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.operators;

import gama.annotations.precompiler.GamlProperties;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.ICollector;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.AbstractExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.operators.IOperator;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.GamaType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.function.Predicate;

public abstract class AbstractNAryOperator
extends AbstractExpression
implements IOperator {
    public final IExpression[] exprs;
    protected OperatorProto prototype;

    public AbstractNAryOperator(OperatorProto operatorProto, IExpression ... iExpressionArray) {
        this.exprs = iExpressionArray.length == 0 || iExpressionArray[0] == null ? null : iExpressionArray;
        this.prototype = operatorProto;
        this.type = this.computeType();
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        this.prototype.collectMetaInformation(gamlProperties);
        if (this.exprs != null) {
            IExpression[] iExpressionArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                iExpression.collectMetaInformation(gamlProperties);
                ++n2;
            }
        }
    }

    @Override
    public OperatorProto getPrototype() {
        return this.prototype;
    }

    protected IType computeType() {
        if (this.prototype == null) {
            return Types.NO_TYPE;
        }
        IType<?> iType = this.computeType(this.prototype.typeProvider, 0, this.prototype.returnType, 0);
        if (iType.isContainer()) {
            IType iType2 = this.computeType(this.prototype.contentTypeProvider, this.prototype.contentTypeContentTypeProvider, iType.getContentType(), 1);
            IType iType3 = this.computeType(this.prototype.keyTypeProvider, 0, iType.getKeyType(), 2);
            iType = GamaType.from(iType, iType3, iType2);
        }
        return iType;
    }

    protected IType computeType(int n, int n2, IType iContainerType, int n3) {
        IType iType;
        boolean bl;
        IContainerType<?> iContainerType2 = iContainerType;
        int n4 = n;
        boolean bl2 = bl = n4 < -1000;
        if (bl) {
            n4 += 1000;
        }
        if (n4 >= 0) {
            iContainerType2 = Types.get(n4);
        } else if (this.exprs != null) {
            switch (n4) {
                case -30: {
                    iContainerType2 = this.exprs[0].getGamlType().getWrappedType();
                    break;
                }
                case -21: {
                    iContainerType2 = GamaType.findCommonType(this.exprs, n3);
                    break;
                }
                case -26: {
                    iContainerType2 = this.processFirstContentTypeOrType();
                    break;
                }
                case -32: {
                    iContainerType2 = this.exprs[1].getDenotedType();
                    break;
                }
                case -25: {
                    iContainerType2 = this.processSecondContentTypeOrType();
                    break;
                }
                default: {
                    if (n4 >= -100) break;
                    iContainerType2 = this.processIndexedTypeProvider(iContainerType2, n4);
                }
            }
        }
        if (n2 != -13 && iContainerType2.isContainer() && (iType = this.computeType(n2, -13, iContainerType2.getContentType(), 1)) != Types.NO_TYPE) {
            iContainerType2 = ((IContainerType)iContainerType2).of(iType);
        }
        if (bl && iContainerType2 == Types.INT) {
            return Types.FLOAT;
        }
        return iContainerType2;
    }

    private IType processIndexedTypeProvider(IType iType, int n) {
        int n2 = -1;
        int n3 = -1;
        if (n > -200) {
            n2 = n - -200 - 1;
            n3 = 0;
        } else if (n > -300) {
            n2 = n - -300 - 1;
            n3 = 1;
        } else if (n > -350) {
            n2 = n - -350 - 1;
            n3 = 3;
        } else if (n > -400) {
            n2 = n - -400 - 1;
            n3 = 2;
        } else if (n > -450) {
            n2 = n - -450 - 1;
            n3 = 4;
        }
        if (n2 > -1 && n2 < this.exprs.length) {
            IExpression iExpression = this.exprs[n2];
            switch (n3) {
                case 0: {
                    iType = iExpression.getGamlType();
                    break;
                }
                case 1: {
                    iType = iExpression.getGamlType().getContentType();
                    break;
                }
                case 2: {
                    iType = iExpression.getGamlType().getKeyType();
                    break;
                }
                case 3: {
                    iType = iExpression.getDenotedType();
                    break;
                }
                case 4: {
                    iType = Types.PAIR.of(iExpression.getGamlType().getKeyType(), iExpression.getGamlType().getContentType());
                }
            }
        }
        return iType;
    }

    private IType processSecondContentTypeOrType() {
        IType<?> iType = this.exprs[1].getGamlType();
        IType<?> iType2 = iType.getContentType();
        IType<?> iType3 = iType2 == Types.NO_TYPE ? iType : iType2;
        return iType3;
    }

    private IType processFirstContentTypeOrType() {
        IType<?> iType = this.exprs[0].getGamlType();
        IType<?> iType2 = iType.getContentType();
        IType<?> iType3 = iType2 == Types.NO_TYPE ? iType : iType2;
        return iType3;
    }

    protected abstract AbstractNAryOperator copy();

    @Override
    public IOperator resolveAgainst(IScope iScope) {
        AbstractNAryOperator abstractNAryOperator = this.copy();
        if (this.exprs != null) {
            int n = 0;
            while (n < this.exprs.length) {
                abstractNAryOperator.exprs[n] = this.exprs[n].resolveAgainst(iScope);
                ++n;
            }
        }
        return abstractNAryOperator;
    }

    @Override
    public boolean isConst() {
        if (!this.prototype.canBeConst) {
            return false;
        }
        if (this.exprs != null) {
            IExpression[] iExpressionArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                if (!iExpression.isConst()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return this.prototype.getName();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.literalValue()).append("(");
        if (this.exprs != null) {
            int n = 0;
            while (n < this.exprs.length) {
                String string = this.exprs[n] == null ? "null" : this.exprs[n].toString();
                stringBuilder.append(string).append(n != this.exprs.length - 1 ? "," : "");
                ++n;
            }
        }
        return stringBuilder.append(")").toString();
    }

    @Override
    public String serializeToGaml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.literalValue());
        AbstractNAryOperator.parenthesize(stringBuilder, this.exprs);
        return stringBuilder.toString();
    }

    public int numArg() {
        return this.exprs == null ? 0 : this.exprs.length;
    }

    @Override
    public IExpression arg(int n) {
        if (this.exprs == null || n >= this.exprs.length) {
            return null;
        }
        return this.exprs[n];
    }

    @Override
    public String getTitle() {
        if ("as".equals(this.getName())) {
            return this.getTitleForCasting();
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("operator ").append(this.getName()).append(" (");
        if (this.exprs != null) {
            IExpression[] iExpressionArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                stringBuilder.append(iExpression == null ? "nil" : iExpression.getGamlType().getName());
                stringBuilder.append(',');
                ++n2;
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        } else if (this.prototype.signature != null) {
            stringBuilder.append("Argument types: " + this.prototype.signature.toString());
        }
        stringBuilder.append(") returns ");
        stringBuilder.append(this.type.getName());
        return stringBuilder.toString();
    }

    private String getTitleForCasting() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("operator for casting ").append(this.exprs[0].getGamlType().getName()).append(" into ").append(this.type.getName());
        return stringBuilder.toString();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return this.prototype.getDocumentation();
    }

    @Override
    public String getDefiningPlugin() {
        return this.prototype.getDefiningPlugin();
    }

    @Override
    public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        this.prototype.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
        if (this.exprs != null) {
            IExpression[] iExpressionArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                if (iExpression != null) {
                    iExpression.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isContextIndependant() {
        if (this.exprs != null) {
            IExpression[] iExpressionArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                if (iExpression != null && !iExpression.isContextIndependant()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public boolean isAllowedInParameters() {
        if (this.exprs != null) {
            IExpression[] iExpressionArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                if (iExpression != null && !iExpression.isAllowedInParameters()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public void visitSuboperators(IOperator.IOperatorVisitor iOperatorVisitor) {
        if (this.exprs != null) {
            IExpression[] iExpressionArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                if (iExpression instanceof IOperator) {
                    iOperatorVisitor.visit((IOperator)iExpression);
                }
                ++n2;
            }
        }
    }

    @Override
    public Object _value(IScope iScope) throws GamaRuntimeException {
        Object[] objectArray = new Object[this.exprs == null ? 0 : this.exprs.length];
        try {
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = this.prototype.getLazyness()[n] ? this.exprs[n] : this.exprs[n].value(iScope);
                ++n;
            }
            return this.prototype.getHelper().get(iScope, objectArray);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("when applying the " + this.literalValue() + " operator on " + Arrays.toString(objectArray));
            throw gamaRuntimeException;
        }
        catch (Throwable throwable) {
            GamaRuntimeException gamaRuntimeException = GamaRuntimeException.create(throwable, iScope);
            gamaRuntimeException.addContext("when applying the " + this.literalValue() + " operator on " + Arrays.toString(objectArray));
            throw gamaRuntimeException;
        }
    }

    @Override
    public boolean findAny(Predicate<IExpression> predicate) {
        if (predicate.test(this)) {
            return true;
        }
        if (this.exprs != null) {
            IExpression[] iExpressionArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                if (iExpression.findAny(predicate)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

