/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.util.GamaMapFactory;
import gama.core.util.IModifiableContainer;
import gama.core.util.file.GamaFolderFile;
import gama.core.util.file.IGamaFile;
import gama.gaml.compilation.GamaGetter;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaContainerType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.ParametricFileType;
import gama.gaml.types.ParametricType;
import gama.gaml.types.Types;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.Path;

@GamlAnnotations.type(name="file", id=12, wraps={IGamaFile.class}, kind=102, concept={"type", "file"}, doc={@GamlAnnotations.doc(value="Generic super-type of all file types")})
public class GamaFileType
extends GamaContainerType<IGamaFile> {
    public static final Map<String, ParametricFileType> extensionsToFullType = GamaMapFactory.createUnordered();
    static final Map<String, ParametricFileType> aliasesToFullType = GamaMapFactory.createUnordered();
    static final Multimap<String, String> aliasesToExtensions = HashMultimap.create();
    static int currentFileTypeIndex = 1000;

    public static void addFileTypeDefinition(String string, IType<?> iType, IType<?> iType2, IType<?> iType3, Class clazz, GamaGetter<IGamaFile<?, ?>> gamaGetter, String[] stringArray, String string2) {
        Object object;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            String string3 = ((String)object).toLowerCase();
            if (string3.startsWith(".")) {
                string3 = string3.substring(1);
            }
            aliasesToExtensions.put((Object)string, (Object)string3);
            ++n2;
        }
        object = new ParametricFileType(string + "_file", clazz, gamaGetter, iType, iType2, iType3);
        ((ParametricFileType)object).setDefiningPlugin(string2);
        aliasesToFullType.put(string, (ParametricFileType)object);
        for (String string4 : aliasesToExtensions.get((Object)string)) {
            extensionsToFullType.put(string4, (ParametricFileType)object);
        }
        ((ParametricType)object).setParent(Types.FILE);
        Types.builtInTypes.initType(string + "_file", object, 50 + ++currentFileTypeIndex, 102, clazz, string2);
    }

    public static ParametricFileType getTypeFromAlias(String string) {
        ParametricFileType parametricFileType = aliasesToFullType.get(string);
        if (parametricFileType == null) {
            return ParametricFileType.getGenericInstance();
        }
        return parametricFileType;
    }

    public static ParametricFileType getTypeFromFileName(String string) {
        Path path = new Path(string);
        String string2 = path.getFileExtension();
        ParametricFileType parametricFileType = extensionsToFullType.get(string2);
        if (parametricFileType == null) {
            parametricFileType = ParametricFileType.getGenericInstance();
        }
        return parametricFileType;
    }

    public static boolean verifyExtension(String string, String string2) {
        ParametricFileType parametricFileType = GamaFileType.getTypeFromAlias(string);
        ParametricFileType parametricFileType2 = GamaFileType.getTypeFromFileName(string2);
        return parametricFileType.equals(parametricFileType2);
    }

    public static boolean managesExtension(String string) {
        return extensionsToFullType.containsKey(string);
    }

    public static IGamaFile createFile(IScope iScope, String string, boolean bl, IModifiableContainer iModifiableContainer) {
        if (new File(string).isDirectory()) {
            if (bl) {
                return new GamaFolderFile(iScope, string);
            }
            return null;
        }
        ParametricFileType parametricFileType = GamaFileType.getTypeFromFileName(string);
        return parametricFileType.createFile(iScope, string, iModifiableContainer);
    }

    @Override
    public IGamaFile cast(IScope iScope, Object object, Object object2, IType iType, IType iType2, boolean bl) {
        if (object == null) {
            return (IGamaFile)this.getDefault();
        }
        if (object instanceof IGamaFile) {
            return (IGamaFile)object;
        }
        if (object instanceof String) {
            if (object2 == null) {
                return GamaFileType.createFile(iScope, (String)object, true, null);
            }
            if (object2 instanceof IModifiableContainer) {
                return GamaFileType.createFile(iScope, (String)object, true, (IModifiableContainer)object2);
            }
        }
        return (IGamaFile)this.getDefault();
    }

    @Override
    public boolean canCastToConst() {
        return false;
    }

    @Override
    public IContainerType typeIfCasting(IExpression iExpression) {
        if (iExpression.isConst() && iExpression.isContextIndependant()) {
            String string = Cast.asString(null, iExpression.getConstValue());
            return GamaFileType.getTypeFromFileName(string);
        }
        return super.typeIfCasting(iExpression);
    }
}

