/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.path.GamaPath;
import gama.core.util.path.IPath;
import gama.core.util.path.PathFactory;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaType;
import gama.gaml.types.Types;
import java.util.List;

@GamlAnnotations.type(name="path", id=17, wraps={IPath.class, GamaPath.class}, kind=104, concept={"type"}, doc={@GamlAnnotations.doc(value="Ordered lists of objects that represent a path in a graph")})
public class GamaPathType
extends GamaType<IPath> {
    @Override
    @GamlAnnotations.doc(value="Cast any object as a path", usages={@GamlAnnotations.usage(value="if the operand is a path, returns this path"), @GamlAnnotations.usage(value="if the operand is a geometry of an agent, returns a path from the list of points of the geometry"), @GamlAnnotations.usage(value="if the operand is a list, cast each element of the list as a point and create a path from these points", examples={@GamlAnnotations.example(value="path p <- path([{12,12},{30,30},{50,50}]);")})})
    public IPath cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaPathType.staticCast(iScope, object, object2, bl);
    }

    @Override
    public IPath getDefault() {
        return null;
    }

    public static IPath staticCast(IScope iScope, Object object, Object object2, boolean bl) {
        if (object instanceof IPath) {
            return (IPath)object;
        }
        if (object instanceof IShape) {
            IShape iShape = (IShape)object;
            return PathFactory.newInstance(iScope, iShape.getPoints(), false);
        }
        if (object instanceof List) {
            IList iList = GamaListFactory.create(Types.GEOMETRY);
            boolean bl2 = true;
            for (Object e : (List)object) {
                iList.add(Cast.asPoint(iScope, e));
                if (!bl2 || e instanceof IShape && ((IShape)e).isLine()) continue;
                bl2 = false;
            }
            return PathFactory.newInstance(iScope, bl2 ? (IList)object : iList, bl2);
        }
        return null;
    }

    @Override
    public boolean isDrawable() {
        return true;
    }

    @Override
    public boolean canCastToConst() {
        return false;
    }
}

