/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gama.annotations.precompiler.GamlProperties;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.types.TypeExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.GamaType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ParametricType
implements IContainerType<IContainer<?, ?>> {
    static Cache<Integer, ParametricType> CACHE2;
    static boolean USE_CACHE;
    private final IContainerType<IContainer<?, ?>> type;
    private final IType<?> contentsType;
    private final IType<?> keyType;
    private final IExpression expression;

    static {
        DEBUG.OFF();
        CACHE2 = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        USE_CACHE = true;
    }

    static boolean useCacheFor(IType<?> iType) {
        boolean bl = Types.builtInTypes.containsType(iType.getName());
        return iType.isCompoundType() ? bl && ParametricType.useCacheFor(iType.getContentType()) && ParametricType.useCacheFor(iType.getKeyType()) : bl;
    }

    public static ParametricType createParametricType(IContainerType<IContainer<?, ?>> iContainerType, IType<?> iType, IType<?> iType2) {
        Integer n;
        ParametricType parametricType;
        if (USE_CACHE && (parametricType = (ParametricType)CACHE2.getIfPresent((Object)(n = Integer.valueOf(31 * (31 * (31 + iContainerType.hashCode()) + iType.hashCode()) + iType2.hashCode())))) == null && ParametricType.useCacheFor(iContainerType) && ParametricType.useCacheFor(iType) && ParametricType.useCacheFor(iType2)) {
            parametricType = new ParametricType(iContainerType, iType, iType2);
            CACHE2.put((Object)n, (Object)parametricType);
            return parametricType;
        }
        return new ParametricType(iContainerType, iType, iType2);
    }

    protected ParametricType(IContainerType<IContainer<?, ?>> iContainerType, IType<?> iType, IType<?> iType2) {
        this.type = iContainerType;
        this.contentsType = iType2;
        this.keyType = iType;
        this.expression = new TypeExpression(this);
    }

    @Override
    public int getNumberOfParameters() {
        return this.type.getNumberOfParameters();
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ParametricType) {
            return this.type.equals(((ParametricType)object).getGamlType()) && this.keyType.equals(((ParametricType)object).getKeyType()) && this.contentsType.equals(((ParametricType)object).getContentType());
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 * (31 + this.type.hashCode()) + this.keyType.hashCode()) + this.contentsType.hashCode();
    }

    @Override
    public String getDefiningPlugin() {
        return this.type.getDefiningPlugin();
    }

    @Override
    public IContainerType<IContainer<?, ?>> getGamlType() {
        return this.type;
    }

    @Override
    public IContainer<?, ?> cast(IScope iScope, Object object, Object object2, IType<?> iType, IType<?> iType2, boolean bl) throws GamaRuntimeException {
        return this.type.cast(iScope, object, object2, (IType)this.keyType, (IType)this.contentsType, bl);
    }

    @Override
    public int id() {
        return this.type.id();
    }

    @Override
    public Class<? extends IContainer<?, ?>> toClass() {
        return this.type.toClass();
    }

    @Override
    public IContainer<?, ?> getDefault() {
        return (IContainer)this.type.getDefault();
    }

    @Override
    public int getVarKind() {
        return 102;
    }

    @Override
    public OperatorProto getGetter(String string) {
        return this.type.getGetter(string);
    }

    @Override
    public boolean isAgentType() {
        return this.type.isAgentType();
    }

    @Override
    public boolean isSkillType() {
        return false;
    }

    @Override
    public IType<?> getContentType() {
        return this.contentsType;
    }

    @Override
    public IType<?> getKeyType() {
        return this.keyType;
    }

    @Override
    public String getSpeciesName() {
        return this.type.getSpeciesName();
    }

    @Override
    public SpeciesDescription getSpecies() {
        return this.type.getSpecies();
    }

    @Override
    public SpeciesDescription getDenotedSpecies() {
        SpeciesDescription speciesDescription = this.type.getSpecies();
        if (speciesDescription != null) {
            return speciesDescription;
        }
        return this.contentsType.getSpecies();
    }

    @Override
    public boolean isAssignableFrom(IType<?> iType) {
        return this.type.isAssignableFrom(iType.getGamlType()) && this.contentsType.isAssignableFrom(iType.getContentType()) && this.keyType.isAssignableFrom(iType.getKeyType());
    }

    @Override
    public boolean isTranslatableInto(IType<?> iType) {
        return this.type.isTranslatableInto(iType.getGamlType()) && this.contentsType.isTranslatableInto(iType.getContentType()) && this.keyType.isTranslatableInto(iType.getKeyType());
    }

    @Override
    public boolean isParametricFormOf(IType<?> iType) {
        return !iType.isParametricType() && this.type.equals(iType);
    }

    @Override
    public boolean isParametricType() {
        return true;
    }

    @Override
    public void setParent(IType<? super IContainer<?, ?>> iType) {
    }

    @Override
    public IType<?> getParent() {
        return this.type;
    }

    @Override
    public IType<?> coerce(IType<?> iType, IDescription iDescription) {
        return null;
    }

    @Override
    public int distanceTo(IType<?> iType) {
        return iType.getGamlType().distanceTo(this.type) + iType.getContentType().distanceTo(this.contentsType) + iType.getKeyType().distanceTo(this.keyType);
    }

    @Override
    public void setFieldGetters(Map<String, OperatorProto> map) {
    }

    @Override
    public boolean canBeTypeOf(IScope iScope, Object object) {
        return this.type.canBeTypeOf(iScope, object);
    }

    @Override
    public void init(int n, int n2, String string, Class<IContainer<?, ?>> clazz) {
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isFixedLength() {
        return this.type.isFixedLength();
    }

    @Override
    public IType<? super IContainer<?, ?>> findCommonSupertypeWith(IType<?> iType) {
        if (iType instanceof ParametricType) {
            IType<?> iType2 = iType;
            IType iType3 = this.type.findCommonSupertypeWith(iType2.getGamlType());
            if (iType3.isContainer()) {
                IType<?> iType4 = this.keyType.findCommonSupertypeWith(iType2.getKeyType());
                IType<?> iType5 = this.contentsType.findCommonSupertypeWith(iType2.getContentType());
                return GamaType.from(iType3, iType4, iType5);
            }
            return iType3;
        }
        if (iType.isContainer()) {
            IType iType6 = this.type.findCommonSupertypeWith(iType);
            return iType6;
        }
        return this.type.findCommonSupertypeWith(iType);
    }

    @Override
    public boolean isDrawable() {
        return this.type.isDrawable();
    }

    @Override
    public void setSupport(Class<IContainer<?, ?>> clazz) {
    }

    @Override
    public IContainer<?, ?> cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return this.cast(iScope, object, object2, (IType)this.keyType, (IType)this.contentsType, bl);
    }

    public String toString() {
        if (this.type.id() == 5 || this.type.id() == 8 || this.type.id() == 16 && this.keyType == Types.NO_TYPE) {
            return this.type.toString() + "<" + this.contentsType.toString() + ">";
        }
        if (this.type.id() == 14) {
            return this.type.toString() + "<" + this.contentsType.toString() + ">";
        }
        return this.type.toString() + "<" + this.keyType.toString() + ", " + this.contentsType.toString() + ">";
    }

    @Override
    public String asPattern() {
        boolean bl = StringUtils.startsWithAny((CharSequence)this.type.getName(), (CharSequence[])vowels);
        return "${" + (bl ? "an_" : "a_") + this.serializeToGaml(true) + "}";
    }

    @Override
    public String serializeToGaml(boolean bl) {
        if (this.type.id() == 5 || this.type.id() == 8 || this.type.id() == 16 && this.keyType == Types.NO_TYPE) {
            return this.type.toString() + "<" + this.contentsType.toString() + ">";
        }
        if (this.type.id() == 14) {
            return this.type.toString() + "<" + this.contentsType.toString() + ">";
        }
        return this.type.toString() + "<" + this.keyType.serializeToGaml(bl) + ", " + this.contentsType.serializeToGaml(bl) + ">";
    }

    @Override
    public IContainerType<?> typeIfCasting(IExpression iExpression) {
        if (this.contentsType == Types.NO_TYPE || this.keyType == Types.NO_TYPE) {
            IType iType = this.type.typeIfCasting(iExpression);
            IType<?> iType2 = this.contentsType == Types.NO_TYPE ? iType.getContentType() : this.contentsType;
            IType<?> iType3 = this.keyType == Types.NO_TYPE ? iType.getKeyType() : this.keyType;
            return ParametricType.createParametricType(this.type, iType3, iType2);
        }
        return this;
    }

    @Override
    public String getTitle() {
        return "Parametric data type " + this.toString().replace('<', '[').replace('>', ']');
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return this.type.getDocumentation();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public boolean canCastToConst() {
        return this.type.canCastToConst() && this.contentsType.canCastToConst() && this.keyType.canCastToConst();
    }

    @Override
    public IContainerType<?> of(IType<?> iType) {
        IType<?> iType2 = this.getKeyType();
        IType<?> iType3 = iType;
        if (iType3 == Types.NO_TYPE) {
            if (iType2 == Types.NO_TYPE) {
                return this;
            }
            iType3 = this.getContentType();
        }
        if (iType2 == Types.NO_TYPE) {
            iType2 = this.getKeyType();
        }
        return ParametricType.createParametricType(this, iType2, iType3);
    }

    @Override
    public IContainerType<?> of(IType<?> iType, IType<?> iType2) {
        IType<?> iType3 = iType;
        IType<?> iType4 = iType2;
        if (iType4 == Types.NO_TYPE) {
            if (iType3 == Types.NO_TYPE) {
                return this;
            }
            iType4 = this.getContentType();
        }
        if (iType3 == Types.NO_TYPE) {
            iType3 = this.getKeyType();
        }
        return ParametricType.createParametricType(this, iType3, iType4);
    }

    @Override
    public void setDefiningPlugin(String string) {
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        this.type.collectMetaInformation(gamlProperties);
        this.contentsType.collectMetaInformation(gamlProperties);
        this.keyType.collectMetaInformation(gamlProperties);
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public IType<?> getWrappedType() {
        return Types.NO_TYPE;
    }

    @Override
    public Map<String, OperatorProto> getFieldGetters() {
        return this.type.getFieldGetters();
    }

    @Override
    public IContainer<?, ?> deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        iMap.put("requested_type", this);
        return (IContainer)this.type.deserializeFromJson(iScope, iMap);
    }

    @Override
    public IExpression getExpression() {
        return this.expression;
    }
}

