/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.batch.StoppingCriterion;
import gama.core.kernel.batch.StoppingCriterionMaxIt;
import gama.core.kernel.batch.optimization.ALocalSearchAlgorithm;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true), @GamlAnnotations.facet(name="iter_max", type={1}, optional=true, doc={@GamlAnnotations.doc(value="number of iterations. this number corresponds to the number of \"moves\" in the parameter space. For each move, the algorithm will test the whole neighborhood of the current solution, each neighbor corresponding to a particular set of parameters and thus to a run. Thus, there can be several runs per iteration (maximum: 2^(number of parameters)).")}), @GamlAnnotations.facet(name="init_solution", type={10}, optional=true, doc={@GamlAnnotations.doc(value="init solution: key: name of the variable, value: value of the variable")}), @GamlAnnotations.facet(name="tabu_list_size_init", type={1}, optional=true, doc={@GamlAnnotations.doc(value="initial size of the tabu list")}), @GamlAnnotations.facet(name="tabu_list_size_max", type={1}, optional=true, doc={@GamlAnnotations.doc(value="maximal size of the tabu list")}), @GamlAnnotations.facet(name="tabu_list_size_min", type={1}, optional=true, doc={@GamlAnnotations.doc(value="minimal size of the tabu list")}), @GamlAnnotations.facet(name="nb_tests_wthout_col_max", type={1}, optional=true, doc={@GamlAnnotations.doc(value="number of movements without collision before shortening the tabu list")}), @GamlAnnotations.facet(name="cycle_size_max", type={1}, optional=true, doc={@GamlAnnotations.doc(value="minimal size of the considered cycles")}), @GamlAnnotations.facet(name="cycle_size_min", type={1}, optional=true, doc={@GamlAnnotations.doc(value="maximal size of the considered cycles")}), @GamlAnnotations.facet(name="maximize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to maximize")}), @GamlAnnotations.facet(name="minimize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to minimize")}), @GamlAnnotations.facet(name="aggregation", type={-200}, optional=true, values={"min", "max", "avr"}, doc={@GamlAnnotations.doc(value="the agregation method")})}, omissible="name")
@GamlAnnotations.doc(value="This algorithm is a simple implementation of the Reactive Tabu Search algorithm ((Battiti et al., 1993)). This Reactive Tabu Search is an enhance version of the Tabu search. It adds two new elements to the classic Tabu Search. The first one concerns the size of the tabu list: in the Reactive Tabu Search, this one is not constant anymore but it dynamically evolves according to the context. Thus, when the exploration process visits too often the same solutions, the tabu list is extended in order to favor the diversification of the search process. On the other hand, when the process has not visited an already known solution for a high number of iterations, the tabu list is shortened in order to favor the intensification of the search process. The second new element concerns the adding of cycle detection capacities. Thus, when a cycle is detected, the process applies random movements in order to break the cycle. See the batch dedicated page.", usages={@GamlAnnotations.usage(value="As other batch methods, the basic syntax of the reactive_tabu statement uses `method reactive_tabu` instead of the expected `reactive_tabu name: id` : ", examples={@GamlAnnotations.example(value="method reactive_tabu [facet: value];", isExecutable=false)}), @GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method reactive_tabu iter_max: 50 tabu_list_size_init: 5 tabu_list_size_min: 2 tabu_list_size_max: 10 nb_tests_wthout_col_max: 20 cycle_size_min: 2 cycle_size_max: 20 maximize: food_gathered;", isExecutable=false)})})
public class TabuSearchReactive
extends ALocalSearchAlgorithm {
    int tabuListSizeInit = 5;
    int tabuListSizeMax = 2;
    int tabuListSizeMin = 10;
    int nbTestWithoutCollisionMax = 20;
    int cycleSizeMax = 20;
    int cycleSizeMin = 2;
    StoppingCriterion stoppingCriterion = new StoppingCriterionMaxIt(100);
    protected static final String ITER_MAX = "iter_max";
    protected static final String LIST_SIZE_INIT = "tabu_list_size_init";
    protected static final String LIST_SIZE_MAX = "tabu_list_size_max";
    protected static final String LIST_SIZE_MIN = "tabu_list_size_min";
    protected static final String NB_TESTS_MAX = "nb_tests_wthout_col_max";
    protected static final String CYCLE_SIZE_MAX = "cycle_size_max";
    protected static final String CYCLE_SIZE_MIN = "cycle_size_min";
    int iterMax = 100;

    public TabuSearchReactive(IDescription iDescription) {
        super(iDescription);
        this.initParams();
    }

    @Override
    public void initParams(IScope iScope) {
        IExpression iExpression;
        IExpression iExpression2;
        IExpression iExpression3;
        IExpression iExpression4;
        IExpression iExpression5;
        IExpression iExpression6;
        IExpression iExpression7 = this.getFacet(ITER_MAX);
        if (iExpression7 != null) {
            this.iterMax = Cast.asInt(iScope, iExpression7.value(iScope));
            this.stoppingCriterion = new StoppingCriterionMaxIt(this.iterMax);
        }
        if ((iExpression6 = this.getFacet(LIST_SIZE_INIT)) != null) {
            this.tabuListSizeInit = Cast.asInt(iScope, iExpression6.value(iScope));
        }
        if ((iExpression5 = this.getFacet(LIST_SIZE_MAX)) != null) {
            this.tabuListSizeMax = Cast.asInt(iScope, iExpression5.value(iScope));
        }
        if ((iExpression4 = this.getFacet(LIST_SIZE_MIN)) != null) {
            this.tabuListSizeMin = Cast.asInt(iScope, iExpression4.value(iScope));
        }
        if ((iExpression3 = this.getFacet(NB_TESTS_MAX)) != null) {
            this.nbTestWithoutCollisionMax = Cast.asInt(iScope, iExpression3.value(iScope));
        }
        if ((iExpression2 = this.getFacet(CYCLE_SIZE_MAX)) != null) {
            this.cycleSizeMax = Cast.asInt(iScope, iExpression2.value(iScope));
        }
        if ((iExpression = this.getFacet(CYCLE_SIZE_MIN)) != null) {
            this.cycleSizeMin = Cast.asInt(iScope, iExpression.value(iScope));
        }
    }

    public boolean keepSol(ParametersSet parametersSet, Double d, Double d2) {
        return this.isMaximize() && d > d2 || !this.isMaximize() && d < d2;
    }

    @Override
    public ParametersSet findBestSolution(IScope iScope) throws GamaRuntimeException {
        this.initializeTestedSolutions();
        int n = this.tabuListSizeInit;
        ParametersSet parametersSet = this.solutionInit;
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return this.solutionInit;
        }
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>();
        arrayList.add(parametersSet);
        double d = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(parametersSet));
        this.testedSolutions.put(parametersSet, d);
        this.setBestSolution(new ParametersSet(parametersSet));
        this.setBestFitness(d);
        this.testedSolutions.put(this.getBestSolution(), d);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ParametersSet parametersSet2 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Iteration", n2);
        while (!this.stoppingCriterion.stopSearchProcess(hashMap)) {
            List<ParametersSet> list;
            ++n3;
            List<ParametersSet> list2 = this.neighborhood.neighbor(iScope, this.getBestSolution());
            list2.removeAll(arrayList);
            if (list2.isEmpty()) break;
            double d2 = this.isMaximize() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            ParametersSet parametersSet3 = null;
            if (GamaExecutorService.shouldRunAllSimulationsInParallel(batchAgent) && !batchAgent.getParametersToExplore().isEmpty()) {
                Map<ParametersSet, Double> map = this.testSolutions(list2);
                list = map.keySet().iterator();
                while (list.hasNext()) {
                    ParametersSet parametersSet4 = list.next();
                    if (!this.keepSol(parametersSet4, map.get(parametersSet4), d2)) continue;
                    parametersSet3 = parametersSet4;
                    if (!this.testedSolutions.containsKey(parametersSet4)) continue;
                    n3 = 0;
                    if (n >= this.tabuListSizeMax) continue;
                    ++n;
                }
            } else {
                for (ParametersSet parametersSet5 : list2) {
                    if (parametersSet5 == null) continue;
                    if (this.testedSolutions.containsKey(parametersSet5)) {
                        n3 = 0;
                        if (n < this.tabuListSizeMax) {
                            ++n;
                        }
                    }
                    if ((list = (Double)this.testedSolutions.get(parametersSet5)) == null || (Double)((Object)list) == Double.MAX_VALUE) {
                        list = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(parametersSet5));
                    }
                    this.testedSolutions.put(parametersSet5, list);
                    if (!this.keepSol(parametersSet5, (Double)((Object)list), d2)) continue;
                    parametersSet3 = parametersSet5;
                }
            }
            if (parametersSet3 == null) break;
            if (this.testedSolutions.containsKey(parametersSet3)) {
                ++n4;
            } else {
                parametersSet2 = null;
                n4 = 0;
                n5 = 0;
            }
            if (n4 == this.cycleSizeMin) {
                parametersSet2 = parametersSet3;
            } else if (n4 > this.cycleSizeMin && n4 <= this.cycleSizeMax) {
                if (parametersSet2 != null && !parametersSet2.equals(parametersSet3)) {
                    ++n5;
                } else {
                    int n6 = (int)(1.0 + iScope.getRandom().next() * (double)n5 / 2.0);
                    int n7 = 0;
                    while (n7 < n6) {
                        list = this.neighborhood.neighbor(iScope, parametersSet);
                        list.removeAll(arrayList);
                        if (list.isEmpty()) break;
                        parametersSet = list.get(iScope.getRandom().between(0, list.size() - 1));
                        if (arrayList.size() == n) {
                            arrayList.remove(0);
                        }
                        arrayList.add(parametersSet);
                        ++n7;
                    }
                    d = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(parametersSet));
                    this.testedSolutions.put(parametersSet, d);
                    if (n2 > this.iterMax) break;
                }
            }
            parametersSet = parametersSet3;
            arrayList.add(parametersSet);
            if (arrayList.size() > n) {
                arrayList.remove(0);
            }
            if (n3 == this.nbTestWithoutCollisionMax) {
                n3 = 0;
                if (n > this.tabuListSizeMin) {
                    --n;
                }
            }
            hashMap.put("Iteration", ++n2);
        }
        return this.getBestSolution();
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        list.add(new ParameterAdapter("Tabu list initial size", "Calibration experiment", 1){

            @Override
            public Object value() {
                return TabuSearchReactive.this.tabuListSizeInit;
            }
        });
        list.add(new ParameterAdapter("Tabu list maximum size", "Calibration experiment", 1){

            @Override
            public Object value() {
                return TabuSearchReactive.this.tabuListSizeMax;
            }
        });
        list.add(new ParameterAdapter("Tabu list minimum size", "Calibration experiment", 1){

            @Override
            public Object value() {
                return TabuSearchReactive.this.tabuListSizeMin;
            }
        });
        list.add(new ParameterAdapter("Maximum number of tests without collision", "Calibration experiment", 1){

            @Override
            public Object value() {
                return TabuSearchReactive.this.nbTestWithoutCollisionMax;
            }
        });
        list.add(new ParameterAdapter("Maximum cycle size", "Calibration experiment", 1){

            @Override
            public Object value() {
                return TabuSearchReactive.this.cycleSizeMax;
            }
        });
        list.add(new ParameterAdapter("Minimum cycle size", "Calibration experiment", 1){

            @Override
            public Object value() {
                return TabuSearchReactive.this.cycleSizeMin;
            }
        });
        list.add(new ParameterAdapter("Maximum number of iterations", "Calibration experiment", 2){

            @Override
            public Object value() {
                return TabuSearchReactive.this.iterMax;
            }
        });
    }
}

