/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.grid;

import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.topology.grid.GridPopulation;
import gama.core.metamodel.topology.grid.IGridAgent;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

public class GamlGridAgent
extends GamlAgent
implements IGridAgent {
    public GamlGridAgent(GridPopulation gridPopulation, int n) {
        super(gridPopulation, n, gridPopulation.grid.matrix[n].getGeometry());
    }

    public GridPopulation getPopulation() {
        return (GridPopulation)super.getPopulation();
    }

    @Override
    public GamaColor getColor() {
        if (this.getPopulation().grid.isHexagon.booleanValue()) {
            return (GamaColor)this.getAttribute("color");
        }
        return GamaColor.get(this.getPopulation().grid.supportImagePixels[this.getIndex()]);
    }

    @Override
    public void setColor(GamaColor gamaColor) {
        if (this.getPopulation().grid.isHexagon.booleanValue()) {
            this.setAttribute("color", gamaColor);
        } else {
            this.getPopulation().grid.supportImagePixels[this.getIndex()] = gamaColor.getRGB();
        }
    }

    @Override
    public final int getX() {
        if (this.getPopulation().grid.isHexagon().booleanValue()) {
            return this.getPopulation().grid.getX(this.getGeometry());
        }
        return (int)(this.getLocation().getX() / this.getPopulation().grid.cellWidth);
    }

    @Override
    public final int getY() {
        if (this.getPopulation().grid.isHexagon().booleanValue()) {
            return this.getPopulation().grid.getY(this.getGeometry());
        }
        return (int)(this.getLocation().getY() / this.getPopulation().grid.cellHeight);
    }

    @Override
    public double getValue() {
        if (this.getPopulation().grid.gridValue != null) {
            return this.getPopulation().grid.gridValue[this.getIndex()];
        }
        return 0.0;
    }

    @Override
    public IList<Double> getBands() {
        if (this.getPopulation().grid.nbBands == 1) {
            IList<Double> iList = GamaListFactory.create(null, (IType)Types.FLOAT, new Double[0]);
            iList.add(this.getValue());
            return iList;
        }
        return this.getPopulation().grid.bands.get(this.getIndex());
    }

    @Override
    public void setValue(double d) {
        if (this.getPopulation().grid.gridValue != null) {
            this.getPopulation().grid.gridValue[this.getIndex()] = d;
        }
    }

    @Override
    public IList<IAgent> getNeighbors(IScope iScope) {
        return Cast.asList(iScope, this.getPopulation().grid.getNeighborhood().getNeighborsIn(iScope, this.getIndex(), 1));
    }
}

