/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.AbstractLayer;
import gama.core.outputs.layers.EventLayerStatement;
import gama.core.outputs.layers.IEventLayerListener;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.IExecutable;

public class EventLayer
extends AbstractLayer
implements IEventLayerListener {
    IScope.IGraphicsScope executionScope;
    private int listenedEvent;
    private IDisplaySurface surface;
    private String event;

    static {
        DEBUG.OFF();
    }

    public EventLayer(ILayerStatement iLayerStatement) {
        super(iLayerStatement);
    }

    @Override
    public void enableOn(IDisplaySurface iDisplaySurface) {
        iDisplaySurface.addListener(this);
    }

    @Override
    public void disableOn(IDisplaySurface iDisplaySurface) {
        super.disableOn(iDisplaySurface);
        iDisplaySurface.removeListener(this);
    }

    private int getListeningEvent(String string) {
        return switch (string) {
            case "mouse_down" -> 0;
            case "mouse_up" -> 1;
            case "mouse_click" -> 2;
            case "mouse_move" -> 4;
            case "mouse_enter" -> 5;
            case "mouse_exit" -> 6;
            case "mouse_menu" -> 7;
            case "mouse_drag" -> 8;
            case "arrow_down" -> 13;
            case "arrow_up" -> 12;
            case "arrow_left" -> 10;
            case "arrow_right" -> 11;
            case "escape" -> 15;
            case "page_down" -> 17;
            case "page_up" -> 16;
            case "enter" -> 18;
            case "tab" -> 14;
            case "shift" -> 22;
            case "cmd" -> 20;
            case "ctrl" -> 19;
            case "alt" -> 21;
            default -> 3;
        };
    }

    @Override
    public void firstLaunchOn(IDisplaySurface iDisplaySurface) {
        super.firstLaunchOn(iDisplaySurface);
        this.surface = iDisplaySurface;
        IExpression iExpression = this.definition.getFacet("name");
        if (this.executionScope != null) {
            GAMA.releaseScope(this.executionScope);
        }
        this.executionScope = iDisplaySurface.getScope().copy("of event layer");
        this.event = Cast.asString(iDisplaySurface.getScope(), iExpression.value(iDisplaySurface.getScope()));
        this.listenedEvent = this.getListeningEvent(this.event);
        iDisplaySurface.addListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public String getType() {
        return "Event layer";
    }

    @Override
    public GamaPoint getModelCoordinatesFrom(int n, int n2, IDisplaySurface iDisplaySurface) {
        if (n == -1 && n2 == -1) {
            return new GamaPoint(0.0, 0.0);
        }
        return iDisplaySurface.getModelCoordinates();
    }

    @Override
    public boolean containsScreenPoint(int n, int n2) {
        return false;
    }

    @Override
    public void mouseClicked(int n, int n2, int n3) {
        if (2 == this.listenedEvent && n3 == 1) {
            this.executeEvent(n, n2);
        }
    }

    @Override
    public void mouseDown(int n, int n2, int n3) {
        if (this.listenedEvent == 0 && n3 == 1) {
            this.executeEvent(n, n2);
        }
    }

    @Override
    public void mouseUp(int n, int n2, int n3) {
        if (1 == this.listenedEvent && n3 == 1) {
            this.executeEvent(n, n2);
        }
    }

    @Override
    public void mouseMove(int n, int n2) {
        if (4 == this.listenedEvent) {
            this.executeEvent(n, n2);
        }
    }

    @Override
    public void mouseDrag(int n, int n2, int n3) {
        if (8 == this.listenedEvent && n3 == 1) {
            this.executeEvent(n, n2);
        }
    }

    @Override
    public void mouseEnter(int n, int n2) {
        if (5 == this.listenedEvent) {
            this.executeEvent(n, n2);
        }
    }

    @Override
    public void mouseExit(int n, int n2) {
        if (6 == this.listenedEvent) {
            this.executeEvent(n, n2);
        }
    }

    @Override
    public void mouseMenu(int n, int n2) {
        if (7 == this.listenedEvent) {
            this.executeEvent(n, n2);
        }
    }

    private void executeEvent(int n, int n2) {
        IAgent iAgent = ((EventLayerStatement)this.definition).getExecuter(this.executionScope);
        if (iAgent == null) {
            return;
        }
        IExecutable iExecutable = ((EventLayerStatement)this.definition).getExecutable(this.executionScope);
        if (iExecutable == null) {
            return;
        }
        GamaPoint gamaPoint = this.getModelCoordinatesFrom(n, n2, this.surface);
        if (gamaPoint == null) {
            return;
        }
        GAMA.runAndUpdateAll(() -> {
            ExecutionResult executionResult = this.executionScope.execute(iExecutable, iAgent, null);
        });
    }

    @Override
    public void keyPressed(String string) {
        if (string.equals(this.event)) {
            this.executeEvent(-1, -1);
        }
    }

    @Override
    protected void privateDraw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) throws GamaRuntimeException {
    }

    @Override
    public void draw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) throws GamaRuntimeException {
    }

    @Override
    public Boolean isControllable() {
        return false;
    }

    public String getEvent() {
        return this.event;
    }

    @Override
    public void specialKeyPressed(int n) {
        if (n == this.listenedEvent) {
            this.executeEvent(-1, -1);
        }
    }
}

