/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.path;

import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.continuous.AmorphousTopology;
import gama.core.metamodel.topology.continuous.ContinuousTopology;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.metamodel.topology.graph.GraphTopology;
import gama.core.metamodel.topology.grid.GridTopology;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.graph.IGraph;
import gama.core.util.path.GamaPath;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.IPath;

public class PathFactory {
    public static <V, E> GamaPath<V, E, IGraph<V, E>> newInstance(IGraph<V, E> iGraph, IList<? extends V> iList) {
        if (iList.isEmpty() && iGraph instanceof GamaSpatialGraph || iList.get(0) instanceof GamaPoint || iGraph instanceof GamaSpatialGraph) {
            return new GamaSpatialPath((GamaSpatialGraph)iGraph, iList);
        }
        return new GamaPath(iGraph, iList);
    }

    public static <V, E> GamaPath<V, E, IGraph<V, E>> newInstance(IGraph<V, E> iGraph, V v, V v2, IList<E> iList) {
        if (iGraph instanceof GamaSpatialGraph) {
            iList.removeIf(object -> object == null);
            return new GamaSpatialPath((GamaSpatialGraph)iGraph, (IShape)v, (IShape)v2, iList);
        }
        return new GamaPath<V, E, IGraph<V, E>>(iGraph, v, v2, iList);
    }

    public static <V, E> GamaPath<V, E, IGraph<V, E>> newInstance(IGraph<V, E> iGraph, V v, V v2, IList<E> iList, boolean bl) {
        if (iGraph instanceof GamaSpatialGraph) {
            return new GamaSpatialPath((GamaSpatialGraph)iGraph, (IShape)v, (IShape)v2, iList, bl);
        }
        return new GamaPath<V, E, IGraph<V, E>>(iGraph, v, v2, iList, bl);
    }

    public static GamaSpatialPath newInstance(IScope iScope, ITopology iTopology, IList<? extends IShape> iList, double d) {
        GamaSpatialPath gamaSpatialPath;
        if (iTopology instanceof GraphTopology) {
            gamaSpatialPath = (GamaSpatialPath)PathFactory.newInstance(((GraphTopology)iTopology).getPlaces(), iList);
        } else if (iTopology instanceof ContinuousTopology || iTopology instanceof AmorphousTopology || iTopology instanceof GridTopology) {
            gamaSpatialPath = new GamaSpatialPath(null, iList);
        } else {
            throw GamaRuntimeException.error("Topologies that are not Graph are not yet taken into account", iScope);
        }
        gamaSpatialPath.setWeight(d);
        return gamaSpatialPath;
    }

    public static GamaSpatialPath newInstance(IScope iScope, ITopology iTopology, IShape iShape, IShape iShape2, IList<IShape> iList) {
        if (iTopology instanceof GraphTopology) {
            return (GamaSpatialPath)PathFactory.newInstance(((GraphTopology)iTopology).getPlaces(), iShape, iShape2, iList);
        }
        return new GamaSpatialPath(iShape, iShape2, iList);
    }

    public static GamaSpatialPath newInstance(IScope iScope, ITopology iTopology, IShape iShape, IShape iShape2, IList<IShape> iList, boolean bl) {
        if (iTopology instanceof GraphTopology) {
            return (GamaSpatialPath)PathFactory.newInstance(((GraphTopology)iTopology).getPlaces(), iShape, iShape2, iList, bl);
        }
        return new GamaSpatialPath(null, iShape, iShape2, iList, bl);
    }

    public static IPath newInstance(IScope iScope, IList<? extends IShape> iList, boolean bl) {
        if (bl) {
            GamaShape gamaShape = (GamaShape)((IShape)iList.get(0)).getGeometry();
            GamaShape gamaShape2 = (GamaShape)((IShape)iList.get(iList.size() - 1)).getGeometry();
            return new GamaSpatialPath(null, GeometryUtils.getFirstPointOf(gamaShape), GeometryUtils.getLastPointOf(gamaShape2), iList, false);
        }
        return new GamaSpatialPath(iList);
    }
}

