/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.data;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlProperties;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.ICollector;
import gama.core.util.IMap;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.AbstractExpression;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.operators.BinaryOperator;
import gama.gaml.expressions.operators.IOperator;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;
import java.util.function.Predicate;

public class MapExpression
extends AbstractExpression
implements IOperator {
    private final IExpression[] keys;
    private final IExpression[] vals;

    public static IExpression create(Iterable<? extends IExpression> iterable) {
        return new MapExpression(iterable);
    }

    MapExpression(Iterable<? extends IExpression> iterable) {
        int n = Iterables.size(iterable);
        this.keys = new IExpression[n];
        this.vals = new IExpression[n];
        int n2 = 0;
        for (IExpression iTyped2 : iterable) {
            if (iTyped2 instanceof BinaryOperator) {
                BinaryOperator binaryOperator = (BinaryOperator)iTyped2;
                this.keys[n2] = binaryOperator.exprs[0];
                this.vals[n2] = binaryOperator.exprs[1];
            } else if (iTyped2 instanceof ConstantExpression && iTyped2.getGamlType().getGamlType() == Types.PAIR) {
                GamaPair gamaPair = (GamaPair)iTyped2.getConstValue();
                Object k = gamaPair.key;
                Object v = gamaPair.value;
                this.keys[n2] = GAML.getExpressionFactory().createConst(k, iTyped2.getGamlType().getKeyType());
                this.vals[n2] = GAML.getExpressionFactory().createConst(v, iTyped2.getGamlType().getContentType());
            }
            ++n2;
        }
        IType<?> iType = GamaType.findCommonType(this.keys, 0);
        IType<?> iType2 = GamaType.findCommonType(this.vals, 0);
        this.type = Types.MAP.of(iType, iType2);
    }

    MapExpression(IMap<IExpression, IExpression> iMap) {
        this.keys = new IExpression[iMap.size()];
        this.vals = new IExpression[iMap.size()];
        int n = 0;
        for (Map.Entry object2 : iMap.entrySet()) {
            this.keys[n] = (IExpression)object2.getKey();
            this.vals[n] = (IExpression)object2.getValue();
            ++n;
        }
        IType<?> iType = GamaType.findCommonType(this.keys, 0);
        IType<?> iType2 = GamaType.findCommonType(this.vals, 0);
        this.type = Types.MAP.of(iType, iType2);
    }

    @Override
    public IExpression resolveAgainst(IScope iScope) {
        IMap iMap = GamaMapFactory.create(this.type.getKeyType(), this.type.getContentType(), this.keys.length);
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] != null && this.vals[n] != null) {
                iMap.put(this.keys[n].resolveAgainst(iScope), this.vals[n].resolveAgainst(iScope));
            }
            ++n;
        }
        return new MapExpression(this.getElements());
    }

    @Override
    public IMap _value(IScope iScope) throws GamaRuntimeException {
        IMap iMap = GamaMapFactory.create(this.type.getKeyType(), this.type.getContentType());
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] == null || this.vals[n] == null) {
                return GamaMapFactory.create();
            }
            iMap.put(this.keys[n].value(iScope), this.vals[n].value(iScope));
            ++n;
        }
        return iMap;
    }

    public String toString() {
        return this.serializeToGaml(false);
    }

    @Override
    public boolean isConst() {
        IExpression iExpression;
        IExpression[] iExpressionArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null && !iExpression.isConst()) {
                return false;
            }
            ++n2;
        }
        iExpressionArray = this.vals;
        n = this.vals.length;
        n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null && !iExpression.isConst()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(' ').append('[');
        int n = 0;
        while (n < this.keys.length) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            if (this.keys[n] != null && this.vals[n] != null) {
                stringBuilder.append(this.keys[n].serializeToGaml(bl));
                stringBuilder.append("::");
                stringBuilder.append(this.vals[n].serializeToGaml(bl));
            }
            ++n;
        }
        stringBuilder.append(']').append(' ');
        return stringBuilder.toString();
    }

    public IExpression[] keysArray() {
        return this.keys;
    }

    public IExpression[] valuesArray() {
        return this.vals;
    }

    public IMap<IExpression, IExpression> getElements() {
        IMap iMap = GamaMapFactory.create(this.type.getKeyType(), this.type.getContentType(), this.keys.length);
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] != null) {
                iMap.put(this.keys[n], this.vals[n]);
            }
            ++n;
        }
        return iMap;
    }

    @Override
    public String getTitle() {
        return "literal map of type " + this.getGamlType().getTitle();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return new IGamlDescription.ConstantDoc("Constant " + this.isConst() + "<br>Contains elements of type " + this.type.getContentType().getTitle());
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        IExpression iExpression;
        IExpression[] iExpressionArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null) {
                iExpression.collectMetaInformation(gamlProperties);
            }
            ++n2;
        }
        iExpressionArray = this.vals;
        n = this.vals.length;
        n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null) {
                iExpression.collectMetaInformation(gamlProperties);
            }
            ++n2;
        }
    }

    @Override
    public boolean isContextIndependant() {
        IExpression iExpression;
        IExpression[] iExpressionArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null && !iExpression.isContextIndependant()) {
                return false;
            }
            ++n2;
        }
        iExpressionArray = this.vals;
        n = this.vals.length;
        n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null && !iExpression.isContextIndependant()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isAllowedInParameters() {
        IExpression iExpression;
        IExpression[] iExpressionArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null && !iExpression.isAllowedInParameters()) {
                return false;
            }
            ++n2;
        }
        iExpressionArray = this.vals;
        n = this.vals.length;
        n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null && !iExpression.isAllowedInParameters()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        IExpression iExpression;
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        IExpression[] iExpressionArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null) {
                iExpression.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
            }
            ++n2;
        }
        iExpressionArray = this.vals;
        n = this.vals.length;
        n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression != null) {
                iExpression.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
            }
            ++n2;
        }
    }

    @Override
    public void visitSuboperators(IOperator.IOperatorVisitor iOperatorVisitor) {
        IExpression iExpression;
        IExpression[] iExpressionArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression instanceof IOperator) {
                iOperatorVisitor.visit((IOperator)iExpression);
            }
            ++n2;
        }
        iExpressionArray = this.vals;
        n = this.vals.length;
        n2 = 0;
        while (n2 < n) {
            iExpression = iExpressionArray[n2];
            if (iExpression instanceof IOperator) {
                iOperatorVisitor.visit((IOperator)iExpression);
            }
            ++n2;
        }
    }

    @Override
    public IExpression arg(int n) {
        if (n < 0 || n > this.vals.length) {
            return null;
        }
        return this.vals[n];
    }

    @Override
    public OperatorProto getPrototype() {
        return null;
    }

    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    @Override
    public boolean findAny(Predicate<IExpression> predicate) {
        IExpression iExpression;
        int n;
        int n2;
        IExpression[] iExpressionArray;
        if (predicate.test(this)) {
            return true;
        }
        if (this.keys != null) {
            iExpressionArray = this.keys;
            n2 = this.keys.length;
            n = 0;
            while (n < n2) {
                iExpression = iExpressionArray[n];
                if (iExpression.findAny(predicate)) {
                    return true;
                }
                ++n;
            }
        }
        if (this.vals != null) {
            iExpressionArray = this.vals;
            n2 = this.vals.length;
            n = 0;
            while (n < n2) {
                iExpression = iExpressionArray[n];
                if (iExpression.findAny(predicate)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

