/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.species;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.species.AbstractSpecies;
import gama.gaml.species.ISpecies;
import gama.gaml.types.IContainerType;
import java.util.Collection;
import one.util.streamex.StreamEx;

@GamlAnnotations.inside(kinds={1, 10, 0})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="parallel", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="(experimental) setting this facet to 'true' will allow this species to use concurrency when scheduling its agents; setting it to an integer will set the threshold under which they will be run sequentially (the default is initially 20, but can be fixed in the preferences). This facet has a default set in the preferences (Under Performances > Concurrency)")}), @GamlAnnotations.facet(name="width", type={1}, optional=true, doc={@GamlAnnotations.doc(value="(grid only), the width of the grid (in terms of agent number)")}), @GamlAnnotations.facet(name="height", type={1}, optional=true, doc={@GamlAnnotations.doc(value="(grid only),  the height of the grid (in terms of agent number)")}), @GamlAnnotations.facet(name="cell_width", type={2}, optional=true, doc={@GamlAnnotations.doc(value="(grid only), the width of the cells of the grid")}), @GamlAnnotations.facet(name="cell_height", type={2}, optional=true, doc={@GamlAnnotations.doc(value="(grid only), the height of the cells of the grid")}), @GamlAnnotations.facet(name="neighbors", type={1}, optional=true, doc={@GamlAnnotations.doc(value="(grid only), the chosen neighborhood (4, 6 or 8)")}), @GamlAnnotations.facet(name="horizontal_orientation", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(hexagonal grid only),(true by default). Allows use a hexagonal grid with a horizontal or vertical orientation. ")}), @GamlAnnotations.facet(name="use_individual_shapes", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(grid only),(true by default). Allows to specify whether or not the agents of the grid will have distinct geometries. If set to false, they will all have simpler proxy geometries", see={"use_regular_agents"}, comment="This facet, when set to true, allows to save memory by generating only one reference geometry and proxy geometries for the agents")}), @GamlAnnotations.facet(name="use_regular_agents", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(grid only),(true by default). Allows to specify if the agents of the grid are regular agents (like those of any other species) or minimal ones (which can't have sub-populations, can't inherit from a regular species, etc.)")}), @GamlAnnotations.facet(name="optimizer", type={4}, optional=true, doc={@GamlAnnotations.doc(value="(grid only),(\"A*\" by default). Allows to specify the algorithm for the shortest path computation (\"BF\", \"Dijkstra\", \"A*\" or \"JPS*\"")}), @GamlAnnotations.facet(name="use_neighbors_cache", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(grid only),(true by default). Allows to turn on or off the use of the neighbors cache used for grids. Note that if a diffusion of variable occurs, GAMA will emit a warning and automatically switch to a caching version")}), @GamlAnnotations.facet(name="file", type={12}, optional=true, doc={@GamlAnnotations.doc(value="(grid only), a bitmap file that will be loaded at runtime so that the value of each pixel can be assigned to the attribute 'grid_value'")}), @GamlAnnotations.facet(name="files", type={5}, of=12, optional=true, doc={@GamlAnnotations.doc(value="(grid only), a list of bitmap file that will be loaded at runtime so that the value of each pixel of each file can be assigned to the attribute 'bands'")}), @GamlAnnotations.facet(name="torus", type={3}, optional=true, doc={@GamlAnnotations.doc(value="is the topology toric (defaut: false). Needs to be defined on the global species.")}), @GamlAnnotations.facet(name="name", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the identifier of the species")}), @GamlAnnotations.facet(name="parent", type={14}, optional=true, doc={@GamlAnnotations.doc(value="the parent class (inheritance)")}), @GamlAnnotations.facet(name="edge_species", type={14}, optional=true, doc={@GamlAnnotations.doc(value="In the case of a species defining a graph topology for its instances (nodes of the graph), specifies the species to use for representing the edges")}), @GamlAnnotations.facet(name="skills", type={5}, of=22, optional=true, doc={@GamlAnnotations.doc(value="The list of skills that will be made available to the instances of this species. Each new skill provides attributes and actions that will be added to the ones defined in this species")}), @GamlAnnotations.facet(name="mirrors", type={5, 14}, of=11, optional=true, doc={@GamlAnnotations.doc(value="The species this species is mirroring. The population of this current species will be dependent of that of the species mirrored (i.e. agents creation and death are entirely taken in charge by GAMA with respect to the demographics of the species mirrored). In addition, this species is provided with an attribute called 'target', which allows each agent to know which agent of the mirrored species it is representing.")}), @GamlAnnotations.facet(name="control", type={22}, optional=true, doc={@GamlAnnotations.doc(value="defines the architecture of the species (e.g. fsm...)")}), @GamlAnnotations.facet(name="compile", type={3}, optional=true, doc={@GamlAnnotations.doc(value="")}, internal=true), @GamlAnnotations.facet(name="frequency", type={1}, optional=true, doc={@GamlAnnotations.doc(value="The execution frequency of the species (default value: 1). For instance, if frequency is set to 10, the population of agents will be executed only every 10 cycles.", see={"schedules"})}), @GamlAnnotations.facet(name="schedules", type={16}, of=11, optional=true, doc={@GamlAnnotations.doc(value="A container of agents (a species, a dynamic list, or a combination of species and containers) , which represents which agents will be actually scheduled when the population is scheduled for execution. Note that the world (or the simulation) is *always* scheduled first, so there is no need to explicitly mention it. Doing so would result in a runtime error. For instance, 'species a schedules: (10 among a)' will result in a population that schedules only 10 of its own agents every cycle. 'species b schedules: []' will prevent the agents of 'b' to be scheduled. Note that the scope of agents covered here can be larger than the population, which allows to build complex scheduling controls; for instance, defining 'global schedules: [] {...} species b schedules: []; species c schedules: b; ' allows to simulate a model where only the world and the agents of b are scheduled, without even having to create an instance of c.")}), @GamlAnnotations.facet(name="topology", type={18}, optional=true, doc={@GamlAnnotations.doc(value="The topology of the population of agents defined by this species. In case of nested species, it can for example be the shape of the macro-agent. In case of grid or graph species, the topology is automatically computed and cannot be redefined")}), @GamlAnnotations.facet(name="virtual", type={3}, optional=true, doc={@GamlAnnotations.doc(value="whether the species is virtual (cannot be instantiated, but only used as a parent) (false by default)")})}, omissible="name")
@GamlAnnotations.doc(value="The species statement allows modelers to define new species in the model. `global` and `grid` are speciel cases of species: `global` being the definition of the global agent (which has automatically one instance, world) and `grid` being a species with a grid topology.", usages={@GamlAnnotations.usage(value="Here is an example of a species definition with a FSM architecture and the additional skill moving:", examples={@GamlAnnotations.example(value="species ant skills: [moving] control: fsm { }", isExecutable=false)}), @GamlAnnotations.usage(value="In the case of a species aiming at mirroring another one:", examples={@GamlAnnotations.example(value="species node_agent mirrors: list(bug) parent: graph_node edge_species: edge_agent { }", isExecutable=false)}), @GamlAnnotations.usage(value="The definition of the single grid of a model will automatically create gridwidth x gridheight agents:", examples={@GamlAnnotations.example(value="grid ant_grid width: gridwidth height: gridheight file: grid_file neighbors: 8 use_regular_agents: false { }", isExecutable=false)}), @GamlAnnotations.usage(value="Using a file to initialize the grid can replace width/height facets:", examples={@GamlAnnotations.example(value="grid ant_grid file: grid_file neighbors: 8 use_regular_agents: false { }", isExecutable=false)})})
@validator(value=SpeciesValidator.class)
public class GamlSpecies
extends AbstractSpecies {
    protected IExpression concurrency = this.getFacet("parallel");
    private final IExpression schedule = this.isMirror() && !this.hasFacet("schedules") ? iScope -> {
        IList iList = GamaListFactory.create();
        for (IAgent iAgent : this.getPopulation(iScope)) {
            IAgent iAgent2;
            Object object = iAgent.getDirectVarValue(iScope, "target");
            if (!(object instanceof IAgent) || (iAgent2 = (IAgent)object).dead()) continue;
            iList.add(iAgent);
        }
        return iList;
    } : this.getFacet("schedules");
    private final IExpression frequency = this.getFacet("frequency");

    public GamlSpecies(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public String getArchitectureName() {
        return this.getLiteral("control");
    }

    @Override
    public IExpression getFrequency() {
        return this.frequency;
    }

    @Override
    public IExpression getSchedule() {
        return this.schedule;
    }

    @Override
    public IExpression getConcurrency() {
        return this.concurrency;
    }

    @Override
    public ISpecies getSpecies() {
        return this;
    }

    @Override
    public IContainer<?, ? extends IAgent> getAgents(IScope iScope) {
        return this;
    }

    @Override
    public boolean hasAgentList() {
        return true;
    }

    @Override
    public boolean accept(IScope iScope, IShape iShape, IShape iShape2) {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? false : iPopulation.accept(iScope, iShape, iShape2);
    }

    @Override
    public boolean containsKey(IScope iScope, Object object) {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? false : iPopulation.containsKey(iScope, object);
    }

    @Override
    public StreamEx<IAgent> stream(IScope iScope) {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? StreamEx.empty() : iPopulation.stream(iScope);
    }

    @Override
    public void filter(IScope iScope, IShape iShape, Collection<? extends IShape> collection) {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        if (iPopulation != null) {
            iPopulation.filter(iScope, iShape, collection);
        }
    }

    @Override
    public IContainerType<?> getGamlType() {
        return (IContainerType)this.getDescription().getSpeciesExpr().getGamlType();
    }

    public boolean belongsToAMicroModel() {
        return this.getDescription().belongsToAMicroModel();
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "name", this.getName());
    }

    public static class SpeciesValidator
    implements IDescriptionValidator<IDescription> {
        @Override
        public void validate(IDescription iDescription) {
            IExpression iExpression;
            SpeciesDescription speciesDescription = (SpeciesDescription)iDescription;
            IExpression iExpression2 = this.processNeighbors(speciesDescription);
            IExpression iExpression3 = speciesDescription.getFacetExpr("cell_width");
            if (iExpression3 != null == ((iExpression = speciesDescription.getFacetExpr("cell_height")) == null)) {
                speciesDescription.error("'cell_width' and 'cell_height' must be defined together", "gaml.conflicting.facets", iExpression3 == null ? "cell_height" : "cell_width", new String[0]);
                return;
            }
            IExpression iExpression4 = speciesDescription.getFacetExpr("width");
            IExpression iExpression5 = speciesDescription.getFacetExpr("height");
            if (iExpression3 != null && iExpression4 != null) {
                speciesDescription.error("'cell_width' and 'width' cannot be defined at the same time", "gaml.conflicting.facets", "width", new String[0]);
                return;
            }
            if (iExpression != null && iExpression5 != null) {
                speciesDescription.error("'cell_width' and 'width' cannot be defined at the same time", "gaml.conflicting.facets", "height", new String[0]);
                return;
            }
            if (!(iExpression == null && iExpression3 == null && iExpression4 == null && iExpression5 == null && iExpression2 == null || "grid".equals(speciesDescription.getKeyword()))) {
                speciesDescription.warning("Facets related to dimensions and neighboring can only be defined in 'grids' definition", "gaml.conflicting.facets");
            }
            this.verifyFiles(speciesDescription, iExpression4, iExpression5, iExpression3, iExpression);
            this.verifyFrequency(speciesDescription);
            this.verifyTorus(speciesDescription);
            String string = speciesDescription.getName();
            if (GAML.isUnaryOperator(string)) {
                speciesDescription.error("The name '" + string + "' cannot be used for naming this " + speciesDescription.getKeyword() + ", as the derived casting operator (" + string + "(...)) would conflict with an existing unary operator");
            }
        }

        private IExpression processNeighbors(SpeciesDescription speciesDescription) {
            IExpression iExpression = speciesDescription.getFacetExpr("neighbors");
            if (iExpression != null) {
                speciesDescription.setFacet("neighbors", iExpression);
            }
            return iExpression;
        }

        private void verifyTorus(IDescription iDescription) {
            IExpression iExpression = iDescription.getFacetExpr("torus");
            if (iExpression != null && ("species".equals(iDescription.getKeyword()) || "grid".equals(iDescription.getKeyword()))) {
                iDescription.warning("The 'torus' facet can only be specified for the model topology (i.e. in 'global')", "gaml.wrong.context.issue", "torus", new String[0]);
            }
        }

        private void verifyFiles(SpeciesDescription speciesDescription, IExpression iExpression, IExpression iExpression2, IExpression iExpression3, IExpression iExpression4) {
            IExpression iExpression5 = speciesDescription.getFacetExpr("file");
            IExpression iExpression6 = speciesDescription.getFacetExpr("files");
            if (iExpression5 != null && iExpression6 != null) {
                speciesDescription.error("The use of the 'files' facet prohibits the use of the 'files' facet: if several files have to be loaded in the grid, use the 'files' facet, otherwise use the 'file' facet", "gaml.conflicting.facets", "file", new String[0]);
            }
            if (!(iExpression5 == null && iExpression6 == null || iExpression2 == null && iExpression == null && iExpression3 == null && iExpression4 == null)) {
                speciesDescription.error("The use of the 'file' and 'files' facets prohibit the use of dimension facets ('width', 'height', 'cell_width', 'cell_height')", "gaml.conflicting.facets", "file", new String[0]);
            }
        }

        private void verifyFrequency(SpeciesDescription speciesDescription) {
            IExpression iExpression = speciesDescription.getFacetExpr("frequency");
            if (iExpression != null && iExpression.isConst() && Integer.valueOf(0).equals(iExpression.getConstValue())) {
                for (VariableDescription iDescription : speciesDescription.getAttributes()) {
                    if (iDescription.getFacet("update", "value") == null) continue;
                    iDescription.warning(iDescription.getName() + " will never be updated because " + speciesDescription.getName() + " has a scheduling frequency of 0", "gaml.wrong.context.issue");
                }
                for (IDescription iDescription : speciesDescription.getBehaviors()) {
                    iDescription.warning(iDescription.getName() + " will never be run because " + speciesDescription.getName() + " has a scheduling frequency of 0", "gaml.wrong.context.issue");
                }
            }
        }
    }
}

