/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.graph.IGraph;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.expressions.operators.BinaryOperator;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@validator(value=ContainerValidator.class)
public abstract class AbstractContainerStatement
extends AbstractStatement {
    protected IExpression item = this.getFacet("item");
    protected IExpression index = this.getFacet("at");
    protected IExpression list;
    protected IExpression all = this.getFacet("all");
    final boolean asAll;
    final boolean asAllValues;
    final boolean asAllIndexes;
    final boolean isDirect;
    final boolean isGraph;

    public AbstractContainerStatement(IDescription iDescription) {
        super(iDescription);
        this.list = this.getFacet("to");
        this.asAll = this.all != null && "true".equals(this.all.literalValue());
        this.asAllValues = this.asAll && this.item != null && this.item.getGamlType().isTranslatableInto(Types.CONTAINER);
        this.asAllIndexes = this.asAll && this.index != null && this.index.getGamlType().isTranslatableInto(Types.CONTAINER);
        IType<?> iType = this.list.getGamlType();
        this.isDirect = iType.isContainer();
        this.isGraph = iType.isTranslatableInto(Types.GRAPH);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IContainer.Modifiable modifiable = this.identifyContainer(iScope);
        Object object = this.identifyIndex(iScope, modifiable);
        Object object2 = this.identifyValue(iScope, modifiable);
        this.apply(iScope, object2, object, modifiable);
        if (this.isDirect && this.list instanceof IVarExpression.Agent) {
            ((IVarExpression)this.list).setVal(iScope, modifiable, false);
        }
        return modifiable;
    }

    protected Object identifyValue(IScope iScope, IContainer.Modifiable modifiable) {
        if (this.item == null) {
            return null;
        }
        if (modifiable instanceof GamaFloatMatrix) {
            return Cast.asFloat(iScope, this.item.value(iScope));
        }
        if (this.isGraph) {
            return this.buildValue(iScope, (IGraph)modifiable);
        }
        return this.item.value(iScope);
    }

    protected Object identifyIndex(IScope iScope, IContainer.Modifiable modifiable) {
        if (this.index == null) {
            return null;
        }
        if (this.isGraph) {
            return this.buildIndex(iScope, (IGraph)modifiable);
        }
        return this.index.value(iScope);
    }

    protected Object buildValue(IScope iScope, IGraph iGraph) {
        if (this.asAllValues) {
            return iGraph.buildValues(iScope, (IContainer)this.item.value(iScope));
        }
        return iGraph.buildValue(iScope, this.item.value(iScope));
    }

    protected Object buildIndex(IScope iScope, IGraph iGraph) {
        if (this.asAllIndexes) {
            return iGraph.buildIndexes(iScope, (IContainer)this.index.value(iScope));
        }
        return iGraph.buildIndex(iScope, this.index.value(iScope));
    }

    private IContainer.Modifiable identifyContainer(IScope iScope) throws GamaRuntimeException {
        Object object = this.list.value(iScope);
        if (this.isDirect) {
            return (IContainer.Modifiable)object;
        }
        if (object instanceof IShape) {
            return ((IShape)object).getOrCreateAttributes();
        }
        throw GamaRuntimeException.warning("Cannot use " + this.list.serializeToGaml(false) + ", of type " + this.list.getGamlType().toString() + ", as a container", iScope);
    }

    protected abstract void apply(IScope var1, Object var2, Object var3, IContainer.Modifiable var4) throws GamaRuntimeException;

    public static class ContainerValidator
    implements IDescriptionValidator {
        public void validate(IDescription iDescription) {
            Object object;
            boolean bl;
            IExpression iExpression = this.findItem(iDescription);
            IExpression iExpression2 = this.findList(iDescription);
            IExpression iExpression3 = this.findIndex(iDescription);
            IExpression iExpression4 = this.findAll(iDescription);
            String string = iDescription.getKeyword();
            boolean bl2 = iExpression4 == null ? false : (bl = !"false".equals(iExpression4.literalValue()));
            if (iExpression == null && !bl && !"remove".equals(string) || iExpression2 == null) {
                iDescription.error("The assignment appears uncomplete", "gaml.general.issue");
                return;
            }
            if (("add".equals(string) || "remove".equals(string)) && (object = iExpression2.getGamlType()).isFixedLength()) {
                iDescription.error("Impossible to add/remove to/from " + iExpression2.serializeToGaml(false), "gaml.wrong.type.issue");
                return;
            }
            if (iExpression3 != null && iExpression2.getGamlType().isAgentType() && iExpression3.isConst()) {
                object = iExpression3.literalValue();
                SpeciesDescription speciesDescription = iExpression2.getGamlType().getSpecies();
                if (speciesDescription.hasAttribute((String)object)) {
                    if ("put".equals(string)) {
                        iDescription.warning("Attribute '" + (String)object + "' will not be modified by this statement. Use '" + iExpression2.serializeToGaml(false) + "." + (String)object + "' instead", "gaml.wrong.context.issue");
                    } else if ("remove".equals(string)) {
                        iDescription.warning("Attribute '" + (String)object + "' cannot be removed. ", "gaml.wrong.context.issue");
                    }
                }
            }
            this.validateIndexAndContentTypes(string, iDescription, bl);
        }

        private IExpression findAll(IDescription iDescription) {
            IExpression iExpression;
            IExpressionDescription iExpressionDescription = iDescription.getFacet("all");
            IExpression iExpression2 = iExpression = iExpressionDescription == null ? null : iExpressionDescription.getExpression();
            if (iExpression != null && iExpression.getGamlType().id() != 3) {
                iDescription.setFacetExprDescription("item", iExpressionDescription);
                iDescription.removeFacets("all");
                iDescription.setFacet("all", IExpressionFactory.TRUE_EXPR);
            }
            return iExpression;
        }

        private IExpression findIndex(IDescription iDescription) {
            IExpression iExpression;
            IExpressionDescription iExpressionDescription = iDescription.getFacet("at", "key", "index");
            IExpression iExpression2 = iExpression = iExpressionDescription == null ? null : iExpressionDescription.getExpression();
            if (iExpression != null) {
                iDescription.setFacetExprDescription("at", iExpressionDescription);
                iDescription.removeFacets("key", "index");
            }
            return iExpression;
        }

        private IExpression findList(IDescription iDescription) {
            IExpression iExpression;
            IExpressionDescription iExpressionDescription = iDescription.getFacet("to", "from", "in");
            IExpression iExpression2 = iExpression = iExpressionDescription == null ? null : iExpressionDescription.getExpression();
            if (iExpression != null) {
                iDescription.setFacetExprDescription("to", iExpressionDescription);
                iDescription.removeFacets("from", "in");
            }
            return iExpression;
        }

        private IExpression findItem(IDescription iDescription) {
            IExpression iExpression;
            IExpressionDescription iExpressionDescription = iDescription.getFacet("item", "edge", "vertex", "node");
            IExpression iExpression2 = iExpression = iExpressionDescription == null ? null : iExpressionDescription.getExpression();
            if (iExpression != null) {
                if (iDescription.hasFacet("edge")) {
                    iExpression = iDescription.hasFacet("weight") ? GAML.getExpressionFactory().createOperator("edge", iDescription, iDescription.getFacet("edge").getTarget(), iExpression, iDescription.getFacetExpr("weight")) : GAML.getExpressionFactory().createOperator("edge", iDescription, iDescription.getFacet("edge").getTarget(), iExpression);
                    iDescription.removeFacets("edge", "weight");
                } else if (iDescription.hasFacet("vertex") || iDescription.hasFacet("node")) {
                    boolean bl = iDescription.hasFacet("node");
                    iExpression = iDescription.hasFacet("weight") ? GAML.getExpressionFactory().createOperator("node", iDescription, bl ? iDescription.getFacet("node").getTarget() : iDescription.getFacet("vertex").getTarget(), iExpression, iDescription.getFacetExpr("weight")) : GAML.getExpressionFactory().createOperator("node", iDescription, bl ? iDescription.getFacet("node").getTarget() : iDescription.getFacet("vertex").getTarget(), iExpression);
                    iDescription.removeFacets("vertex", "node", "weight");
                }
                iDescription.setFacet("item", iExpression);
            }
            return iExpression;
        }

        public void validateIndexAndContentTypes(String string, IDescription iDescription, boolean bl) {
            IExpression iExpression = iDescription.getFacetExpr("item");
            IExpression iExpression2 = iDescription.getFacetExpr("to");
            IExpression iExpression3 = iDescription.getFacetExpr("at");
            if (iExpression2 instanceof BinaryOperator && "internal_between".equals(((BinaryOperator)iExpression2).getName())) {
                iDescription.error("Ranges of indices can only be used in conjunction with `put` or `<-`", "gaml.conflicting.facets", "at", new String[0]);
                return;
            }
            if (!"remove".equals(string)) {
                Object object;
                IType<?> iType;
                if (iExpression == null) {
                    return;
                }
                IType<?> iType2 = iExpression2.getGamlType().getContentType();
                boolean bl2 = false;
                if (!"put".equals(string) && bl && iExpression.getGamlType().isTranslatableInto(Types.CONTAINER)) {
                    bl2 = true;
                    iType = iExpression.getGamlType().getContentType();
                } else {
                    iType = iExpression.getGamlType();
                }
                if (iType2 != Types.NO_TYPE && !iType.isTranslatableInto(iType2) && !Types.isEmptyContainerCase(iType2, iExpression)) {
                    object = new StringBuilder("The type of the elements of ").append(iExpression2.serializeToGaml(false)).append(" (").append(iType2).append(") does not match with the type of the ");
                    if (bl2) {
                        ((StringBuilder)object).append("elements of the argument");
                    } else {
                        ((StringBuilder)object).append("argument");
                    }
                    ((StringBuilder)object).append(" (").append(iType).append("). ");
                    if (bl2) {
                        ((StringBuilder)object).append("These elements will be casted to ").append(iType2).append(". ");
                    } else {
                        ((StringBuilder)object).append("The argument will be casted to ").append(iType2).append(". ");
                    }
                    iDescription.warning(((StringBuilder)object).toString(), "gaml.casting.issue", "item", bl2 ? iExpression2.getGamlType().toString() : iType2.toString());
                }
                object = iExpression2.getGamlType().getKeyType();
                if (iExpression3 != null && object != Types.NO_TYPE && !iExpression3.getGamlType().isTranslatableInto((IType<?>)object)) {
                    if (Types.LIST.isAssignableFrom(iExpression2.getGamlType()) && Types.PAIR.of(Types.INT, Types.INT).equals(iExpression3.getGamlType())) {
                        return;
                    }
                    if (!Types.MATRIX.isAssignableFrom(iExpression2.getGamlType()) || iExpression3.getGamlType() != Types.INT && !iExpression3.getGamlType().equals(Types.LIST.of(Types.INT))) {
                        iDescription.warning("The type of the index of " + iExpression2.serializeToGaml(false) + " (" + String.valueOf(object) + ") does not match with the type of " + iExpression3.serializeToGaml(false) + " (" + String.valueOf(iExpression3.getGamlType()) + "). The latter will be casted to " + String.valueOf(object), "gaml.casting.issue", "at", object.toString());
                    }
                }
            }
        }
    }
}

