/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.util.GamaColor;
import gama.gaml.operators.Colors;
import gama.gaml.statements.draw.IMeshColorProvider;

public class PaletteBasedMeshColorProvider
implements IMeshColorProvider {
    final double[] components;
    final int size;

    public PaletteBasedMeshColorProvider(Colors.GamaPalette gamaPalette) {
        this.size = gamaPalette.size();
        this.components = new double[this.size * 4];
        int n = 0;
        while (n < this.size) {
            GamaColor gamaColor = (GamaColor)gamaPalette.get(n);
            this.components[n * 3] = (double)gamaColor.getRed() / 255.0;
            this.components[n * 3 + 1] = (double)gamaColor.getGreen() / 255.0;
            this.components[n * 3 + 2] = (double)gamaColor.getBlue() / 255.0;
            this.components[n * 3 + 3] = (double)gamaColor.getAlpha() / 255.0;
            ++n;
        }
    }

    @Override
    public double[] getColor(int n, double d, double d2, double d3, double[] dArray) {
        double[] dArray2 = dArray;
        if (dArray2 == null) {
            dArray2 = this.newArray();
        }
        if (d2 > d3 || d <= d2) {
            dArray2[0] = this.components[0];
            dArray2[1] = this.components[1];
            dArray2[2] = this.components[2];
            dArray2[3] = this.components[3];
        } else if (d >= d3) {
            dArray2[0] = this.components[3 * (this.size - 1)];
            dArray2[1] = this.components[3 * (this.size - 1) + 1];
            dArray2[2] = this.components[3 * (this.size - 1) + 2];
            dArray2[3] = this.components[3 * (this.size - 1) + 3];
        } else {
            double d4 = (d3 - d2) / (double)(this.size - 1);
            double d5 = (d - d2) / d4;
            int n2 = (int)d5;
            double d6 = d5 - (double)n2;
            double d7 = 1.0 - d6;
            dArray2[0] = this.components[n2 * 3] * d7 + this.components[(n2 + 1) * 3] * d6;
            dArray2[1] = this.components[n2 * 3 + 1] * d7 + this.components[(n2 + 1) * 3 + 1] * d6;
            dArray2[2] = this.components[n2 * 3 + 2] * d7 + this.components[(n2 + 1) * 3 + 2] * d6;
            dArray2[3] = 1.0;
        }
        return dArray2;
    }
}

