/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import com.google.common.collect.Iterators;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GamaGeometryFactory;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.Rotation3D;
import gama.core.metamodel.shape.GamaPoint;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class GamaCoordinateSequence
implements ICoordinates {
    final int dimension;
    final GamaPoint[] points;

    GamaCoordinateSequence(int n, Coordinate ... coordinateArray) {
        this(n, true, coordinateArray);
    }

    GamaCoordinateSequence(int n, boolean bl, Coordinate ... coordinateArray) {
        this.dimension = n;
        if (bl) {
            int n2 = coordinateArray.length;
            this.points = new GamaPoint[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.points[n3] = new GamaPoint(coordinateArray[n3]);
                ++n3;
            }
            this.ensureClockwiseness();
        } else {
            this.points = (GamaPoint[])coordinateArray;
        }
    }

    GamaCoordinateSequence(int n, int n2) {
        this.dimension = n;
        this.points = new GamaPoint[n2 < 0 ? 0 : n2];
        int n3 = 0;
        while (n3 < n2) {
            this.points[n3] = new GamaPoint(0.0, 0.0, 0.0);
            ++n3;
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public final GamaCoordinateSequence copy() {
        return new GamaCoordinateSequence(this.dimension, true, (Coordinate[])this.points);
    }

    @Override
    @Deprecated
    public GamaCoordinateSequence clone() {
        return this.copy();
    }

    public String toString() {
        return Arrays.toString(this.points);
    }

    @Override
    public GamaPoint getCoordinate(int n) {
        return this.points[n];
    }

    public GamaPoint getCoordinateCopy(int n) {
        return new GamaPoint(this.points[n]);
    }

    public void getCoordinate(int n, Coordinate coordinate) {
        coordinate.setCoordinate((Coordinate)this.points[n]);
    }

    public double getX(int n) {
        return this.points[n].x;
    }

    public double getY(int n) {
        return this.points[n].y;
    }

    public double getOrdinate(int n, int n2) {
        return this.points[n].getOrdinate(n2);
    }

    public int size() {
        return this.points.length;
    }

    public void setOrdinate(int n, int n2, double d) {
        this.points[n].setOrdinate(n2, d);
    }

    @Override
    public GamaPoint[] toCoordinateArray() {
        return this.points;
    }

    public Envelope expandEnvelope(Envelope envelope) {
        GamaPoint[] gamaPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = gamaPointArray[n2];
            envelope.expandToInclude((Coordinate)gamaPoint);
            ++n2;
        }
        return envelope;
    }

    @Override
    public Iterator<GamaPoint> iterator() {
        return Iterators.forArray((Object[])this.points);
    }

    @Override
    public void addCenterTo(GamaPoint gamaPoint) {
        int n = GamaGeometryFactory.isRing(this.points) ? this.points.length - 1 : this.points.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint2 = this.points[n2];
            d += gamaPoint2.x;
            d2 += gamaPoint2.y;
            d3 += gamaPoint2.z;
            ++n2;
        }
        gamaPoint.x += (d /= (double)n);
        gamaPoint.y += (d2 /= (double)n);
        gamaPoint.z += (d3 /= (double)n);
    }

    @Override
    public ICoordinates yNegated() {
        int n = this.points.length;
        Coordinate[] coordinateArray = new GamaPoint[n];
        int n2 = 0;
        while (n2 < n) {
            coordinateArray[n2] = this.points[n - n2 - 1].yNegated();
            ++n2;
        }
        return new GamaCoordinateSequence(this.dimension, false, coordinateArray);
    }

    @Override
    public void visit(ICoordinates.IndexedVisitor indexedVisitor, int n, boolean bl) {
        boolean bl2;
        int n2 = n < 0 || n > this.points.length ? this.points.length : n;
        boolean bl3 = bl2 = GamaGeometryFactory.isRing(this.points) && !bl;
        if (bl2) {
            this.reverseVisit(indexedVisitor, n2);
        } else {
            this.visit(indexedVisitor, n2);
        }
    }

    private void visit(ICoordinates.IndexedVisitor indexedVisitor, int n) {
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = this.points[n2];
            indexedVisitor.process(n2, gamaPoint.x, gamaPoint.y, gamaPoint.z);
            ++n2;
        }
    }

    private void reverseVisit(ICoordinates.IndexedVisitor indexedVisitor, int n) {
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            GamaPoint gamaPoint = this.points[n2];
            indexedVisitor.process(n3, gamaPoint.x, gamaPoint.y, gamaPoint.z);
            --n2;
            ++n3;
        }
    }

    @Override
    public void visit(ICoordinates.PairVisitor pairVisitor) {
        int n = 0;
        while (n < this.points.length - 1) {
            pairVisitor.process(this.points[n], this.points[n + 1]);
            ++n;
        }
    }

    @Override
    public void getNormal(boolean bl, double d, GamaPoint gamaPoint) {
        GamaPoint gamaPoint2;
        gamaPoint.setLocation(0.0, 0.0, 0.0);
        if (this.points.length < 3) {
            return;
        }
        int n = 0;
        while (n < this.points.length - 1) {
            gamaPoint2 = this.points[n];
            GamaPoint gamaPoint3 = this.points[n + 1];
            gamaPoint.x += (gamaPoint2.y - gamaPoint3.y) * (gamaPoint2.z + gamaPoint3.z);
            gamaPoint.y += (gamaPoint2.z - gamaPoint3.z) * (gamaPoint2.x + gamaPoint3.x);
            gamaPoint.z += (gamaPoint2.x - gamaPoint3.x) * (gamaPoint2.y + gamaPoint3.y);
            ++n;
        }
        if (!GamaGeometryFactory.isRing(this.points)) {
            GamaPoint gamaPoint4 = this.points[0];
            gamaPoint2 = this.points[1];
            gamaPoint.x += (gamaPoint4.y - gamaPoint2.y) * (gamaPoint4.z + gamaPoint2.z);
            gamaPoint.y += (gamaPoint4.z - gamaPoint2.z) * (gamaPoint4.x + gamaPoint2.x);
            gamaPoint.z += (gamaPoint4.x - gamaPoint2.x) * (gamaPoint4.y + gamaPoint2.y);
        }
        double d2 = bl ? -gamaPoint.norm() : gamaPoint.norm();
        gamaPoint.divideBy(d2 / d);
    }

    @Override
    public Envelope3D getEnvelopeInto(Envelope3D envelope3D) {
        envelope3D.setToNull();
        this.expandEnvelope(envelope3D);
        return envelope3D;
    }

    @Override
    public double averageZ() {
        double d = 0.0;
        if (this.points.length == 0) {
            return d;
        }
        GamaPoint[] gamaPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = gamaPointArray[n2];
            d += gamaPoint.z;
            ++n2;
        }
        return d / (double)this.points.length;
    }

    @Override
    public ICoordinates setTo(GamaPoint ... gamaPointArray) {
        int n = Math.min(gamaPointArray.length, this.points.length);
        int n2 = 0;
        while (n2 < n) {
            this.points[n2].setCoordinate(gamaPointArray[n2]);
            ++n2;
        }
        this.ensureClockwiseness();
        return this;
    }

    @Override
    public ICoordinates setTo(int n, double ... dArray) {
        int n2 = Math.min(dArray.length, this.points.length * 3);
        int n3 = n;
        while (n3 < n2) {
            GamaPoint gamaPoint = this.points[n3 / 3];
            gamaPoint.x = dArray[n3];
            gamaPoint.y = dArray[n3 + 1];
            gamaPoint.z = dArray[n3 + 2];
            n3 += 3;
        }
        this.ensureClockwiseness();
        return this;
    }

    @Override
    public GamaPoint directionBetweenLastPointAndOrigin() {
        GamaPoint gamaPoint = new GamaPoint();
        GamaPoint gamaPoint2 = this.points[0];
        int n = this.points.length - 1;
        while (n > 0) {
            if (!this.points[n].equals(gamaPoint2)) {
                gamaPoint.setLocation(this.points[n]).subtract(gamaPoint2).normalize();
                return gamaPoint;
            }
            --n;
        }
        return gamaPoint;
    }

    @Override
    public void applyRotation(Rotation3D rotation3D) {
        GamaPoint[] gamaPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = gamaPointArray[n2];
            rotation3D.applyTo(gamaPoint);
            ++n2;
        }
    }

    @Override
    public void replaceWith(int n, double d, double d2, double d3) {
        if (n < 0 || n >= this.points.length) {
            return;
        }
        this.points[n].setLocation(d, d2, d3);
    }

    @Override
    public boolean isHorizontal() {
        double d = this.points[0].z;
        int n = 1;
        while (n < this.points.length) {
            if (this.points[n].z != d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public double getLength() {
        double d = 0.0;
        int n = 1;
        while (n < this.points.length) {
            d += this.points[n].euclidianDistanceTo(this.points[n - 1]);
            ++n;
        }
        return d;
    }

    @Override
    public void setAllZ(double d) {
        int n = 0;
        while (n < this.points.length) {
            this.points[n].z = d;
            ++n;
        }
    }

    @Override
    public boolean isCoveredBy(Envelope3D envelope3D) {
        GamaPoint[] gamaPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = gamaPointArray[n2];
            if (!envelope3D.covers(gamaPoint)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void visitClockwise(ICoordinates.VertexVisitor vertexVisitor) {
        int n = GamaGeometryFactory.isRing(this.points) ? this.points.length - 1 : this.points.length;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = this.points[n2];
            vertexVisitor.process(gamaPoint.x, gamaPoint.y, gamaPoint.z);
            ++n2;
        }
    }

    @Override
    public void visitYNegatedCounterClockwise(ICoordinates.VertexVisitor vertexVisitor) {
        int n = GamaGeometryFactory.isRing(this.points) ? this.points.length - 1 : this.points.length;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = this.points[n2];
            vertexVisitor.process(gamaPoint.x, -gamaPoint.y, gamaPoint.z);
            ++n2;
        }
    }

    @Override
    public boolean isClockwise() {
        return CGAlgorithms.signedArea((Coordinate[])this.points) > 0.0;
    }

    @Override
    public void completeRing() {
        this.points[this.points.length - 1] = this.points[0];
    }

    @Override
    public void translateBy(double d, double d2, double d3) {
        GamaPoint[] gamaPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint = gamaPointArray[n2];
            gamaPoint.add(d, d2, d3);
            ++n2;
        }
    }

    @Override
    public void ensureClockwiseness() {
        if (!GamaGeometryFactory.isRing(this.points)) {
            return;
        }
        if (CGAlgorithms.signedArea((Coordinate[])this.points) <= 0.0) {
            ArrayUtils.reverse((Object[])this.points);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof GamaCoordinateSequence)) {
            return false;
        }
        GamaCoordinateSequence gamaCoordinateSequence = (GamaCoordinateSequence)object;
        return Arrays.equals(this.points, gamaCoordinateSequence.points);
    }

    public int hashCode() {
        return Arrays.hashCode(this.points);
    }
}

