/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IKeyword;
import gama.core.common.util.FileUtils;
import gama.core.kernel.batch.IExploration;
import gama.core.kernel.batch.exploration.sampling.LatinhypercubeSampling;
import gama.core.kernel.batch.exploration.sampling.MorrisSampling;
import gama.core.kernel.batch.exploration.sampling.OrthogonalSampling;
import gama.core.kernel.batch.exploration.sampling.RandomSampling;
import gama.core.kernel.batch.exploration.sampling.SaltelliSampling;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.compilation.Symbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Strings;
import gama.gaml.types.GamaDateType;
import gama.gaml.types.GamaFloatType;
import gama.gaml.types.GamaPointType;
import gama.gaml.types.Types;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import one.util.streamex.IntStreamEx;

@GamlAnnotations.inside(kinds={13})
public abstract class AExplorationAlgorithm
extends Symbol
implements IExploration {
    protected BatchAgent currentExperiment;
    protected IExpression outputsExpression;
    protected IExpression outputFilePath;
    protected int sample_size = 132;
    public static final String CSV_SEP = ",";

    @Override
    public void initializeFor(IScope iScope, BatchAgent batchAgent) throws GamaRuntimeException {
        this.currentExperiment = batchAgent;
    }

    public AExplorationAlgorithm(IDescription iDescription) {
        super(iDescription);
        if (this.hasFacet("outputs")) {
            this.outputsExpression = this.getFacet("outputs");
        }
        if (this.hasFacet("results")) {
            this.outputFilePath = this.getFacet("results");
        }
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, BatchAgent batchAgent) {
        list.add(new ParameterAdapter("Exploration method", "Exploration experiment", 4){

            @Override
            public Object value() {
                List<Class> list = Arrays.asList(CLASSES);
                String string = IKeyword.METHODS[list.indexOf(AExplorationAlgorithm.this.getClass())];
                return string;
            }
        });
        if (this.getOutputs() != null) {
            list.add(new ParameterAdapter("Outputs of interest", "Exploration experiment", 4){

                @Override
                public Object value() {
                    return AExplorationAlgorithm.this.getOutputs().literalValue();
                }
            });
        }
    }

    @Override
    public void run(IScope iScope) {
        try {
            this.explore(iScope);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            GAMA.reportError(iScope, gamaRuntimeException, false);
        }
    }

    @Override
    public boolean isFitnessBased() {
        return false;
    }

    public abstract void explore(IScope var1);

    public String getReport() {
        return "";
    }

    @Override
    public IExpression getOutputs() {
        return this.outputsExpression;
    }

    public List<ParametersSet> getExperimentPlan(List<IParameter.Batch> list, IScope iScope) {
        String string;
        return switch (string = this.hasFacet("sampling") ? Cast.asString(iScope, this.getFacet("sampling").value(iScope)) : (this.hasFacet("from") ? "FROMFILE" : (this.hasFacet("with") ? "FROMLIST" : ""))) {
            case "morris" -> MorrisSampling.makeMorrisSamplingOnly(this.hasFacet("levels") ? Cast.asInt(iScope, this.getFacet("levels")) : 4, this.sample_size, list, iScope);
            case "latinhypercube" -> LatinhypercubeSampling.latinHypercubeSamples(this.sample_size, list, iScope.getRandom().getGenerator(), iScope);
            case "orthogonal" -> OrthogonalSampling.orthogonalSamples(this.sample_size, this.hasFacet("iterations") ? Cast.asInt(iScope, this.getFacet("iterations").value(iScope)) : 5, list, iScope.getRandom().getGenerator(), iScope);
            case "saltelli" -> SaltelliSampling.makeSaltelliSampling(iScope, this.sample_size, list);
            case "uniform" -> RandomSampling.uniformSampling(iScope, this.sample_size, list);
            case "factorial" -> {
                if (this.hasFacet("factorial")) {
                    yield RandomSampling.factorialUniformSampling(iScope, this.getFactorial(iScope, list), list);
                }
                yield RandomSampling.factorialUniformSampling(iScope, this.sample_size, list);
            }
            case "FROMLIST" -> this.buildParameterFromMap(iScope);
            case "FROMFILE" -> this.buildParametersFromCSV(iScope, Cast.asString(iScope, this.getFacet("from").value(iScope)));
            default -> this.buildParameterSets(iScope, new ArrayList<ParametersSet>(), 0);
        };
    }

    public int[] getFactorial(IScope iScope, List<IParameter.Batch> list) {
        IList iList = Cast.asList(iScope, this.getFacet("factorial").value(iScope));
        if (iList.size() < list.size()) {
            iList.addAll(Collections.nCopies(list.size() - iList.size(), 9));
        } else if (iList.size() > list.size()) {
            iList = Cast.asList(iScope, iList.subList(0, list.size()));
        }
        return IntStreamEx.of((Collection)iList).toArray();
    }

    public List<ParametersSet> buildParameterSets(IScope iScope, List<ParametersSet> list, int n) {
        if (list == null) {
            throw GamaRuntimeException.error("Cannot build a sample with empty parameter set", iScope);
        }
        List<IParameter.Batch> list2 = this.currentExperiment.getParametersToExplore();
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>();
        if (list2.isEmpty()) {
            return arrayList;
        }
        if (list.isEmpty()) {
            list.add(new ParametersSet());
        }
        IParameter.Batch batch = list2.get(n);
        for (ParametersSet parametersSet : list) {
            List<Object> list3 = batch.getAmongValue(iScope) != null ? batch.getAmongValue(iScope) : this.getParameterSwip(iScope, batch);
            for (Object object : list3) {
                ParametersSet parametersSet2 = new ParametersSet(parametersSet);
                parametersSet2.put(batch.getName(), object);
                arrayList.add(parametersSet2);
            }
        }
        if (n == list2.size() - 1) {
            return arrayList;
        }
        return this.buildParameterSets(iScope, arrayList, n + 1);
    }

    public void saveRawResults(IScope iScope, IMap<ParametersSet, Map<String, List<Object>>> iMap) {
        String string = Cast.asString(iScope, this.outputFilePath.value(iScope));
        File file2 = new File(FileUtils.constructAbsoluteFilePath(iScope, string, false));
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            try {
                if (!file3.mkdirs()) {
                    throw new Exception("Unknown reason");
                }
            }
            catch (Exception exception) {
                throw GamaRuntimeException.error("Cannot create a folder at " + file3.toString() + " because: " + exception.getMessage(), iScope);
            }
        }
        if (file2.exists()) {
            try {
                if (!file2.delete()) {
                    throw new Exception("Unknown reason");
                }
            }
            catch (Exception exception) {
                throw GamaRuntimeException.error("File " + file2.toString() + " cannot be deleted because: " + exception.getMessage(), iScope);
            }
        }
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (FileWriter fileWriter = new FileWriter(file2, StandardCharsets.UTF_8, false);){
                fileWriter.write(this.buildSimulationCsv(iMap, iScope));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error("File " + file2.toString() + " cannot be found to save " + this.currentExperiment.getName() + " experiment results", iScope);
        }
    }

    private List<ParametersSet> buildParameterFromMap(IScope iScope) {
        IExpression iExpression = this.getFacet("with");
        if (iExpression.getGamlType().isAssignableFrom(Types.LIST)) {
            throw GamaRuntimeException.error("You cannot use with facet without input a list of maps: got " + String.valueOf(iExpression.getDenotedType()), iScope);
        }
        IList iList = Cast.asList(iScope, iExpression.value(iScope));
        return this.buildParametersSetList(iScope, iList);
    }

    private List<ParametersSet> buildParametersSetList(IScope iScope, List<Map<String, Object>> list) {
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>();
        for (Map<String, Object> map : list) {
            ParametersSet parametersSet = new ParametersSet();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                parametersSet.put(entry.getKey(), entry.getValue() instanceof IExpression ? ((IExpression)entry.getValue()).value(iScope) : entry.getValue());
            }
            arrayList.add(parametersSet);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ParametersSet> buildParametersFromCSV(IScope iScope, String string) throws GamaRuntimeException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                FileReader fileReader = new FileReader(new File(string), StandardCharsets.UTF_8);
                try {
                    try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                        String string2 = " ";
                        ArrayList<Object> arrayList2 = new ArrayList<Object>();
                        int n = 0;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            Object object;
                            String[] stringArray;
                            String[] stringArray2 = stringArray = string2.split(CSV_SEP);
                            int n2 = stringArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                object = stringArray2[n3];
                                if (n == 0) {
                                    arrayList2.add(object);
                                }
                                ++n3;
                            }
                            if (n > 0) {
                                object = new HashMap();
                                n3 = 0;
                                while (n3 < stringArray.length) {
                                    object.put((String)arrayList2.get(n3), stringArray[n3]);
                                    ++n3;
                                }
                                arrayList.add((Map<String, Object>)object);
                            }
                            ++n;
                        }
                    }
                    if (fileReader == null) return this.buildParametersSetList(iScope, arrayList);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fileReader == null) throw throwable;
                    fileReader.close();
                    throw throwable;
                }
                fileReader.close();
                return this.buildParametersSetList(iScope, arrayList);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw GamaRuntimeException.error("CSV file not found: " + string, iScope);
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error("Error during the reading of the CSV file", iScope);
        }
    }

    private String buildSimulationCsv(IMap<ParametersSet, Map<String, List<Object>>> iMap, IScope iScope) {
        StringBuilder stringBuilder = new StringBuilder();
        IList iList = Cast.asList(iScope, this.getFacet("outputs").value(iScope));
        IList iList2 = iMap.getKeys().anyValue(iScope).getKeys();
        stringBuilder.append(String.join((CharSequence)CSV_SEP, iList2));
        stringBuilder.append(CSV_SEP);
        stringBuilder.append(String.join((CharSequence)CSV_SEP, iList));
        for (Map.Entry entry : iMap.entrySet()) {
            Map map = (Map)entry.getValue();
            ParametersSet parametersSet = (ParametersSet)entry.getKey();
            int n = ((List)map.values().stream().findAny().get()).size();
            if (!map.values().stream().allMatch(list -> list.size() == n)) {
                GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("Not all sample of stochastic analysis have the same number of replicates", iScope), false);
                continue;
            }
            int n2 = 0;
            while (n2 < n) {
                stringBuilder.append(Strings.LN);
                stringBuilder.append(iList2.stream().map(string -> parametersSet.get(string).toString()).collect(Collectors.joining(CSV_SEP)));
                for (Map.Entry entry2 : map.entrySet()) {
                    stringBuilder.append(CSV_SEP).append(((List)entry2.getValue()).get(n2));
                }
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    private List<Object> getParameterSwip(IScope iScope, IParameter.Batch batch) {
        return switch (batch.getType().id()) {
            case 1 -> this.getIntParameterSwip(iScope, batch);
            case 2 -> this.getFloatParameterSwip(iScope, batch);
            case 23 -> this.getDateParameterSwip(iScope, batch);
            case 7 -> this.getPointParameterSwip(iScope, batch);
            default -> this.getDefaultParameterSwip(iScope, batch);
        };
    }

    private List<Object> getDateParameterSwip(IScope iScope, IParameter.Batch batch) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GamaDate gamaDate = GamaDateType.staticCast(iScope, batch.getMinValue(iScope), null, false);
        GamaDate gamaDate2 = GamaDateType.staticCast(iScope, batch.getMaxValue(iScope), null, false);
        Double d = Cast.asFloat(iScope, batch.getStepValue(iScope));
        while (gamaDate.isSmallerThan(gamaDate2, false)) {
            if (d > 0.0) {
                arrayList.add(gamaDate);
                gamaDate = gamaDate.plus(d, (TemporalUnit)ChronoUnit.SECONDS);
                continue;
            }
            arrayList.add(gamaDate2);
            gamaDate2 = gamaDate2.minus(Math.abs(d.longValue()), ChronoUnit.SECONDS);
        }
        return arrayList;
    }

    private List<Object> getPointParameterSwip(IScope iScope, IParameter.Batch batch) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GamaPoint gamaPoint = Cast.asPoint(iScope, batch.getMinValue(iScope));
        GamaPoint gamaPoint2 = Cast.asPoint(iScope, batch.getMaxValue(iScope));
        Double d = null;
        GamaPoint gamaPoint3 = new GamaPoint((gamaPoint2.x - gamaPoint.x) / 10.0, (gamaPoint2.y - gamaPoint.y) / 10.0, (gamaPoint2.z - gamaPoint.z) / 10.0);
        if (batch.getStepValue(iScope) != null) {
            gamaPoint3 = GamaPointType.staticCast(iScope, batch.getStepValue(iScope), true);
            if (gamaPoint3 == null) {
                double d2 = GamaFloatType.staticCast(iScope, batch.getStepValue(iScope), null, false);
                d = d2;
                gamaPoint3 = new GamaPoint(d2, d2, d2);
            } else {
                d = (gamaPoint3.x + gamaPoint3.y + gamaPoint3.z) / 3.0;
            }
        }
        while (gamaPoint.smallerThanOrEqualTo(gamaPoint2)) {
            if (d == null || d > 0.0) {
                arrayList.add(gamaPoint);
                gamaPoint = gamaPoint.plus(Cast.asPoint(iScope, gamaPoint3));
                continue;
            }
            arrayList.add(gamaPoint2);
            gamaPoint2 = gamaPoint2.plus(Cast.asPoint(iScope, gamaPoint3));
        }
        return arrayList;
    }

    private List<Object> getFloatParameterSwip(IScope iScope, IParameter.Batch batch) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        double d = Cast.asFloat(iScope, batch.getMinValue(iScope));
        double d2 = Cast.asFloat(iScope, batch.getMaxValue(iScope));
        double d3 = 0.1;
        double d4 = 8.0;
        if (this.hasFacet("factorial")) {
            List<IParameter.Batch> list = this.currentExperiment.getParametersToExplore();
            d4 = this.getFactorial(iScope, list)[list.indexOf(batch)];
            d3 = (d2 - d) / d4;
        } else {
            d3 = batch.getStepValue(iScope) != null ? Cast.asFloat(iScope, batch.getStepValue(iScope)) : (d2 - d) / d4;
        }
        if (d3 < 0.0) {
            d3 *= -1.0;
        } else if (d3 == 0.0) {
            d3 = 0.1;
        }
        while (d <= d2) {
            arrayList.add(d += d3);
        }
        return arrayList;
    }

    private List<Object> getIntParameterSwip(IScope iScope, IParameter.Batch batch) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = Cast.asInt(iScope, batch.getMinValue(iScope));
        int n2 = Cast.asInt(iScope, batch.getMaxValue(iScope));
        double d = 1.0;
        double d2 = 8.0;
        if (this.hasFacet("factorial")) {
            List<IParameter.Batch> list = this.currentExperiment.getParametersToExplore();
            d2 = this.getFactorial(iScope, list)[list.indexOf(batch)];
            if ((double)(n2 - n) > d2) {
                d = (double)(n2 - n) / d2;
            }
        } else if (batch.getStepValue(iScope) != null) {
            d = Cast.asInt(iScope, batch.getStepValue(iScope)).intValue();
        } else if ((double)(n2 - n) > d2) {
            d = (double)(n2 - n) / d2;
        }
        int n3 = 0;
        n3 = Math.abs((int)((double)(n2 - n) / d));
        double d3 = d >= 0.0 ? n : n2;
        int n4 = 0;
        while (n4 <= n3) {
            arrayList.add(d3 + (double)((int)(d * (double)n4)));
            ++n4;
        }
        return arrayList;
    }

    private List<Object> getDefaultParameterSwip(IScope iScope, IParameter.Batch batch) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        double d = Cast.asFloat(iScope, batch.getMinValue(iScope));
        double d2 = Cast.asFloat(iScope, batch.getMaxValue(iScope));
        double d3 = 1.0;
        double d4 = 8.0;
        if (this.hasFacet("factorial")) {
            List<IParameter.Batch> list = this.currentExperiment.getParametersToExplore();
            d4 = this.getFactorial(iScope, list)[list.indexOf(batch)];
            d3 = (d2 - d) / d4;
        } else {
            d3 = batch.getStepValue(iScope) != null ? Cast.asFloat(iScope, batch.getStepValue(iScope)) : (d2 - d) / d4;
        }
        double d5 = d3 >= 0.0 ? d : d2;
        while (d5 <= d2) {
            if (batch.getType().id() == 1) {
                arrayList.add((int)d5);
            } else if (batch.getType().id() == 2) {
                arrayList.add(d5);
            }
            d5 += d3;
        }
        return arrayList;
    }
}

