/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.COUNTER;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.statements.AspectStatement;

@GamlAnnotations.inside(symbols={"display"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="position", type={7}, optional=true, doc={@GamlAnnotations.doc(value="position of the upper-left corner of the layer. Note that if coordinates are in [0,1[, the position is relative to the size of the environment (e.g. {0.5,0.5} refers to the middle of the display) whereas it is absolute when coordinates are greater than 1 for x and y. The z-ordinate can only be defined between 0 and 1. The position can only be a 3D point {0.5, 0.5, 0.5}, the last coordinate specifying the elevation of the layer. In case of negative value OpenGl will position the layer out of the environment.")}), @GamlAnnotations.facet(name="background", type={6}, optional=true, doc={@GamlAnnotations.doc(value="the background color of the layer. Default is none")}), @GamlAnnotations.facet(name="border", type={6}, optional=true, doc={@GamlAnnotations.doc(value="Color to apply to the border of the rectangular shape of the layer. Default is none")}), @GamlAnnotations.facet(name="rotate", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Defines the angle of rotation of this layer, in degrees, around the z-axis.")}), @GamlAnnotations.facet(name="trace", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="Allows to aggregate the visualization at each timestep on the display. Default is false. If set to an int value, only the last n-th steps will be visualized. If set to true, no limit of timesteps is applied. ")}), @GamlAnnotations.facet(name="fading", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Used in conjunction with 'trace:', allows to apply a fading effect to the previous traces. Default is false")}), @GamlAnnotations.facet(name="size", type={7}, optional=true, doc={@GamlAnnotations.doc(value="extent of the layer in the screen from its position. Coordinates in [0,1[ are treated as percentages of the total surface, while coordinates > 1 are treated as absolute sizes in model units (i.e. considering the model occupies the entire view). Like in 'position', an elevation can be provided with the z coordinate, allowing to scale the layer in the 3 directions ")}), @GamlAnnotations.facet(name="transparency", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the transparency level of the layer (between 0 -- opaque -- and 1 -- fully transparent)")}), @GamlAnnotations.facet(name="visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Defines whether this layer is visible or not")}), @GamlAnnotations.facet(name="name", type={-200}, optional=true, doc={@GamlAnnotations.doc(value="the human readable title of the graphics")}), @GamlAnnotations.facet(name="refresh", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(openGL only) specify whether the display of the species is refreshed. (true by default, usefull in case of agents that do not move)")})}, omissible="name")
@GamlAnnotations.doc(value="`graphics` allows the modeler to freely draw shapes/geometries/texts without having to define a species. It works exactly like a species [Aspect161 aspect]: the draw statement can be used in the same way.", usages={@GamlAnnotations.usage(value="The general syntax is:", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   graphics \"my new layer\" {", isExecutable=false), @GamlAnnotations.example(value="      draw circle(5) at: {10,10} color: #red;", isExecutable=false), @GamlAnnotations.example(value="      draw \"test\" at: {10,10} size: 20 color: #black;", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"display", "agents", "chart", "event", "graphics", "display_grid", "image_layer", "overlay", "species_layer"})
public class GraphicLayerStatement
extends AbstractLayerStatement {
    AspectStatement aspect;

    public GraphicLayerStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        IDescription iDescription2 = DescriptionFactory.create("aspect", iDescription, "name", "graphic_aspect" + String.valueOf(COUNTER.COUNT()));
        this.aspect = new AspectStatement(iDescription2);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.aspect.setChildren(iterable);
    }

    public AspectStatement getAspect() {
        return this.aspect;
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        return ILayerStatement.LayerType.GRAPHICS;
    }

    @Override
    protected boolean _init(IScope iScope) {
        return true;
    }

    @Override
    protected boolean _step(IScope iScope) {
        return true;
    }
}

