/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.dev.DEBUG;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

public class MtlLoader {
    protected ArrayList materials = new ArrayList();

    public MtlLoader(BufferedReader bufferedReader, String string) {
        this.loadobject(bufferedReader, string);
        this.cleanup();
    }

    private void cleanup() {
    }

    public int getSize() {
        return this.materials.size();
    }

    public float getd(String string) {
        int n = 0;
        while (n < this.materials.size()) {
            Mtl mtl = (Mtl)this.materials.get(n);
            if (mtl.name.matches(string)) {
                return mtl.d;
            }
            ++n;
        }
        return 1.0f;
    }

    public float[] getKd(String string) {
        float[] fArray = new float[3];
        int n = 0;
        while (n < this.materials.size()) {
            Mtl mtl = (Mtl)this.materials.get(n);
            if (mtl.name.matches(string)) {
                return mtl.Kd;
            }
            ++n;
        }
        return fArray;
    }

    public String getMapKa(String string) {
        int n = 0;
        while (n < this.materials.size()) {
            Mtl mtl = (Mtl)this.materials.get(n);
            if (mtl.name.matches(string)) {
                return mtl.map_Ka;
            }
            ++n;
        }
        return null;
    }

    public String getMapKd(String string) {
        int n = 0;
        while (n < this.materials.size()) {
            Mtl mtl = (Mtl)this.materials.get(n);
            if (mtl.name.matches(string)) {
                return mtl.map_Kd;
            }
            ++n;
        }
        return null;
    }

    public String getMapd(String string) {
        int n = 0;
        while (n < this.materials.size()) {
            Mtl mtl = (Mtl)this.materials.get(n);
            if (mtl.name.matches(string)) {
                return mtl.map_d;
            }
            ++n;
        }
        return null;
    }

    private void loadobject(BufferedReader bufferedReader, String string) {
        int n = 0;
        try {
            String string2;
            boolean bl = true;
            Mtl mtl = new Mtl();
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n3;
                Object object;
                ++n;
                if ((string2 = string2.trim()).length() <= 0) continue;
                if (string2.charAt(0) == 'n' && string2.charAt(1) == 'e' && string2.charAt(2) == 'w') {
                    if (bl) {
                        bl = false;
                    } else {
                        this.materials.add(mtl);
                        mtl = new Mtl();
                    }
                    object = string2.split("\\s+");
                    mtl.name = object[1];
                    mtl.mtlNum = n2++;
                    continue;
                }
                if (string2.charAt(0) == 'K' && string2.charAt(1) == 'a') {
                    object = string2.split("\\s+");
                    n3 = 1;
                    while (n3 < ((String[])object).length) {
                        mtl.Ka[n3 - 1] = Float.parseFloat(object[n3]);
                        ++n3;
                    }
                    continue;
                }
                if (string2.charAt(0) == 'K' && string2.charAt(1) == 'd') {
                    object = string2.split("\\s+");
                    n3 = 1;
                    while (n3 < ((String[])object).length) {
                        mtl.Kd[n3 - 1] = Float.parseFloat((String)object[n3]);
                        ++n3;
                    }
                    continue;
                }
                if (string2.charAt(0) == 'K' && string2.charAt(1) == 's') {
                    object = string2.split("\\s+");
                    n3 = 1;
                    while (n3 < ((String[])object).length) {
                        mtl.Ks[n3 - 1] = Float.parseFloat((String)object[n3]);
                        ++n3;
                    }
                    continue;
                }
                if (string2.charAt(0) == 'd') {
                    object = string2.split("\\s+");
                    mtl.d = Float.parseFloat(object[1]);
                    continue;
                }
                if (string2.contains("map_Ka")) {
                    object = string2.replace("map_Ka ", "");
                    while (((String)object).startsWith(" ")) {
                        object = ((String)object).replaceFirst(" ", "");
                    }
                    mtl.map_Ka = object;
                    continue;
                }
                if (string2.contains("map_Kd")) {
                    object = string2.replace("map_Kd ", "");
                    while (((String)object).startsWith(" ")) {
                        object = ((String)object).replaceFirst(" ", "");
                    }
                    mtl.map_Kd = object;
                    continue;
                }
                if (!string2.contains("map_d")) continue;
                object = string2.replace("map_d ", "");
                while (((String)object).startsWith(" ")) {
                    object = ((String)object).replaceFirst(" ", "");
                }
                mtl.map_d = object;
            }
            this.materials.add(mtl);
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)("Failed to read file: " + bufferedReader.toString()));
            iOException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            DEBUG.ERR((Object)("Malformed MTL (on line " + n + "): " + bufferedReader.toString() + "\r \r" + numberFormatException.getMessage()));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            DEBUG.ERR((Object)("Malformed MTL (on line " + n + "): " + bufferedReader.toString() + "\r \r" + stringIndexOutOfBoundsException.getMessage()));
        }
    }

    public static class Mtl {
        public String name;
        public int mtlNum;
        public float d = 1.0f;
        public float[] Ka = new float[3];
        public float[] Kd = new float[3];
        public float[] Ks = new float[3];
        public String map_Kd;
        public String map_Ka;
        public String map_d;
    }
}

