/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph;

import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.graph.IGraph;

public class GraphAlgorithmsHandmade {
    public static Object getOneRandomNode(IScope iScope, IGraph iGraph) {
        return iGraph.getVertices().get(iScope.getRandom().between(0, iGraph.getVertices().size() - 1));
    }

    public static Object getAnotherRandomNode(IScope iScope, IGraph iGraph, Object object) {
        if (iGraph.getVertices().size() < 2) {
            throw GamaRuntimeException.error("unable to find another node in this very small network", iScope);
        }
        Object object2 = null;
        while ((object2 = GraphAlgorithmsHandmade.getOneRandomNode(iScope, iGraph)) == object) {
        }
        return object2;
    }

    public static IGraph rewireGraphProbability(IScope iScope, IGraph iGraph, Double d) {
        IList iList = iGraph.getEdges();
        int n = 0;
        while (n < iList.size()) {
            Object e = iList.get(n);
            if (iScope.getRandom().between(0.0, 1.0) <= d) {
                Object object = iGraph.getEdgeSource(e);
                Object object2 = GraphAlgorithmsHandmade.getAnotherRandomNode(iScope, iGraph, object);
                iGraph.removeEdge(e);
                iGraph.addEdge(object, object2, e);
            }
            ++n;
        }
        return iGraph;
    }

    public static IGraph rewireGraphCount(IScope iScope, IGraph iGraph, Integer n) {
        IList iList = iGraph.getEdges();
        int n2 = 0;
        while (n2 < n) {
            Object e = iList.get(iScope.getRandom().between(0, iGraph.getEdges().length(null) - 1));
            Object object = iGraph.getEdgeSource(e);
            Object object2 = GraphAlgorithmsHandmade.getAnotherRandomNode(iScope, iGraph, object);
            iGraph.removeEdge(e);
            iGraph.addEdge(object, object2, e);
            ++n2;
        }
        return iGraph;
    }
}

