/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.finite_state_machine;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.gaml.architecture.finite_state_machine.FsmStateStatement;
import gama.gaml.architecture.reflex.ReflexArchitecture;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="state", type=4, doc={@GamlAnnotations.doc(value="Returns the name of the current state of the agent")}), @GamlAnnotations.variable(name="states", type=5, constant=true, doc={@GamlAnnotations.doc(value="Returns the list of all the states defined in the species")})})
@GamlAnnotations.skill(name="fsm", concept={"behavior", "architecture"}, doc={@GamlAnnotations.doc(value="The Finite State Machine architecture allows to program agents using a finite set of states and conditional transitions between them")})
public class FsmArchitecture
extends ReflexArchitecture {
    protected final Map<String, FsmStateStatement> states = GamaMapFactory.createUnordered();
    protected FsmStateStatement initialState;

    @Override
    protected void clearBehaviors() {
        super.clearBehaviors();
        this.states.clear();
    }

    @Override
    public void verifyBehaviors(ISpecies iSpecies) {
        super.verifyBehaviors(iSpecies);
        for (FsmStateStatement fsmStateStatement : this.states.values()) {
            if (!fsmStateStatement.isInitial()) continue;
            this.initialState = fsmStateStatement;
        }
        if (this.initialState != null) {
            iSpecies.getVar("state").setValue(null, this.initialState.getName());
        }
    }

    @GamlAnnotations.getter(value="states", initializer=true)
    public IList<String> getStateNames(IAgent iAgent) {
        return GamaListFactory.wrap((IType)Types.STRING, this.states.keySet());
    }

    @GamlAnnotations.setter(value="states")
    public void setStateNames(IAgent iAgent, IList<String> iList) {
    }

    @GamlAnnotations.getter(value="state")
    public String getStateName(IAgent iAgent) {
        return (String)iAgent.getAttribute("currentState");
    }

    public FsmStateStatement getState(String string) {
        return this.states.get(string);
    }

    @GamlAnnotations.setter(value="state")
    public void setStateName(IAgent iAgent, String string) {
        if (string != null && this.states.containsKey(string)) {
            this.setCurrentState(iAgent, this.states.get(string));
        }
    }

    @Override
    public void addBehavior(IStatement iStatement) {
        if (iStatement instanceof FsmStateStatement) {
            FsmStateStatement fsmStateStatement = (FsmStateStatement)iStatement;
            this.states.put(fsmStateStatement.getName(), fsmStateStatement);
        } else {
            super.addBehavior(iStatement);
        }
    }

    @Override
    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        super.executeOn(iScope);
        return this.executeCurrentState(iScope);
    }

    protected Object executeCurrentState(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        if (iScope.interrupted()) {
            return null;
        }
        FsmStateStatement fsmStateStatement = this.getState((String)iAgent.getAttribute("currentState"));
        if (fsmStateStatement == null) {
            return null;
        }
        return iScope.execute(fsmStateStatement).getValue();
    }

    public void setCurrentState(IAgent iAgent, FsmStateStatement fsmStateStatement) {
        FsmStateStatement fsmStateStatement2 = this.getState((String)iAgent.getAttribute("currentState"));
        if (fsmStateStatement2 == fsmStateStatement) {
            return;
        }
        iAgent.setAttribute("enter", true);
        iAgent.setAttribute("currentState", fsmStateStatement.getName());
    }

    @Override
    public boolean abort(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        if (iScope.interrupted() || iAgent == null) {
            return true;
        }
        FsmStateStatement fsmStateStatement = this.getState((String)iAgent.getAttribute("currentState"));
        if (fsmStateStatement == null) {
            return true;
        }
        fsmStateStatement.haltOn(iScope);
        return super.abort(iScope);
    }
}

