/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.reflex;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.architecture.reflex.AbstractArchitecture;
import gama.gaml.compilation.ISymbol;
import gama.gaml.statements.IStatement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;

@GamlAnnotations.skill(name="reflex", concept={"behavior", "architecture"})
@GamlAnnotations.doc(value="Represents the default behavioral architecture attached to species of agents if none is specified. This skills extends AbstractArchitecture and have all his actions and variables")
public class ReflexArchitecture
extends AbstractArchitecture {
    protected List<IStatement> _inits;
    protected List<IStatement> _reflexes;
    protected List<IStatement> _aborts;

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.clearBehaviors();
        for (ISymbol iSymbol : iterable) {
            this.addBehavior((IStatement)iSymbol);
        }
    }

    protected void clearBehaviors() {
        if (this._inits != null) {
            this._inits.clear();
        }
        this._inits = null;
        if (this._aborts != null) {
            this._aborts.clear();
        }
        this._aborts = null;
        if (this._reflexes != null) {
            this._reflexes.clear();
        }
        this._reflexes = null;
    }

    public void addBehavior(IStatement iStatement) {
        switch (iStatement.getKeyword()) {
            case "init": {
                if (this._inits == null) {
                    this._inits = new ArrayList<IStatement>();
                }
                this._inits.add(0, iStatement);
                return;
            }
            case "abort": {
                if (this._aborts == null) {
                    this._aborts = new ArrayList<IStatement>();
                }
                this._aborts.add(0, iStatement);
                return;
            }
            case "reflex": 
            case "test": {
                if (this._reflexes == null) {
                    this._reflexes = new ArrayList<IStatement>();
                }
                this._reflexes.add(iStatement);
            }
        }
    }

    @Override
    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        return this.executeReflexes(iScope);
    }

    protected final Object executeReflexes(IScope iScope) throws GamaRuntimeException {
        if (this._reflexes == null) {
            return null;
        }
        Object object = null;
        for (IStatement iStatement : this._reflexes) {
            ExecutionResult executionResult = iScope.execute(iStatement);
            if (!executionResult.passed()) {
                return object;
            }
            object = executionResult.getValue();
        }
        return object;
    }

    @Override
    public boolean init(IScope iScope) throws GamaRuntimeException {
        if (this._inits == null) {
            return true;
        }
        for (IStatement iStatement : this._inits) {
            if (iScope.execute(iStatement).passed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean abort(IScope iScope) throws GamaRuntimeException {
        if (this._aborts == null) {
            return true;
        }
        for (IStatement iStatement : this._aborts) {
            if (iScope.execute(iStatement).passed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEnclosing(ISymbol iSymbol) {
    }

    @Override
    public void preStep(IScope iScope, IPopulation<? extends IAgent> iPopulation) {
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void setOrder(int n) {
    }

    @Override
    public URI getURI() {
        return null;
    }
}

