/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.matrix.GamaField;
import gama.core.util.matrix.IField;
import gama.gaml.statements.draw.IMeshColorProvider;
import java.util.List;

public class BandsBasedMeshColorProvider
implements IMeshColorProvider {
    private final double[] components;
    private final int size;

    public BandsBasedMeshColorProvider(List<GamaField> list) {
        if (list.size() < 4) {
            throw GamaRuntimeException.error("Number of bands should be at least 3 ", GAMA.getRuntimeScope());
        }
        boolean bl = list.size() > 4;
        IField iField = list.get(0);
        this.size = iField.getMatrix().length;
        this.components = new double[this.size * 4];
        double[] dArray = list.get(0).getMatrix();
        double[] dArray2 = list.get(1).getMatrix();
        double[] dArray3 = list.get(2).getMatrix();
        int n = 0;
        while (n < this.size) {
            this.components[n * 3] = dArray[n] / 255.0;
            this.components[n * 3 + 1] = dArray2[n] / 255.0;
            this.components[n * 3 + 2] = dArray3[n] / 255.0;
            this.components[n * 3 + 3] = bl ? list.get(4).getMatrix()[n] / 255.0 : 1.0;
            ++n;
        }
    }

    @Override
    public double[] getColor(int n, double d, double d2, double d3, double[] dArray) {
        double[] dArray2 = dArray;
        if (dArray2 == null) {
            dArray2 = this.newArray();
        }
        dArray2[0] = this.components[n * 3];
        dArray2[1] = this.components[n * 3 + 1];
        dArray2[2] = this.components[n * 3 + 2];
        dArray2[3] = this.components[n * 3 + 3];
        return dArray2;
    }
}

