/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization.genetic;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.batch.Neighborhood;
import gama.core.kernel.batch.Neighborhood1Var;
import gama.core.kernel.batch.optimization.AOptimizationAlgorithm;
import gama.core.kernel.batch.optimization.genetic.Chromosome;
import gama.core.kernel.batch.optimization.genetic.CrossOver;
import gama.core.kernel.batch.optimization.genetic.CrossOver1Pt;
import gama.core.kernel.batch.optimization.genetic.Initialization;
import gama.core.kernel.batch.optimization.genetic.InitializationUniform;
import gama.core.kernel.batch.optimization.genetic.Mutation;
import gama.core.kernel.batch.optimization.genetic.Mutation1Var;
import gama.core.kernel.batch.optimization.genetic.Selection;
import gama.core.kernel.batch.optimization.genetic.SelectionBest;
import gama.core.kernel.batch.optimization.genetic.SelectionRoulette;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of this method. For internal use only")}), @GamlAnnotations.facet(name="pop_dim", type={1}, optional=true, doc={@GamlAnnotations.doc(value="size of the population (number of individual solutions)")}), @GamlAnnotations.facet(name="crossover_prob", type={2}, optional=true, doc={@GamlAnnotations.doc(value="crossover probability between two individual solutions")}), @GamlAnnotations.facet(name="mutation_prob", type={2}, optional=true, doc={@GamlAnnotations.doc(value="mutation probability for an individual solution")}), @GamlAnnotations.facet(name="nb_prelim_gen", type={1}, optional=true, doc={@GamlAnnotations.doc(value="number of random populations used to build the initial population")}), @GamlAnnotations.facet(name="max_gen", type={1}, optional=true, doc={@GamlAnnotations.doc(value="number of generations")}), @GamlAnnotations.facet(name="improve_sol", type={3}, optional=true, doc={@GamlAnnotations.doc(value="if true, use a hill climbing algorithm to improve the solutions at each generation")}), @GamlAnnotations.facet(name="stochastic_sel", type={3}, optional=true, doc={@GamlAnnotations.doc(value="if true, use a stochastic selection algorithm (roulette) rather a determistic one (keep the best solutions)")}), @GamlAnnotations.facet(name="maximize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to maximize")}), @GamlAnnotations.facet(name="minimize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to minimize")}), @GamlAnnotations.facet(name="aggregation", type={-200}, optional=true, values={"min", "max", "avr"}, doc={@GamlAnnotations.doc(value="the agregation method")})}, omissible="name")
@GamlAnnotations.doc(value="This is a simple implementation of Genetic Algorithms (GA). See the wikipedia article and [batch161 the batch dedicated page]. The principle of the GA is to search an optimal solution by applying evolution operators on an initial population of solutions. There are three types of evolution operators: crossover, mutation and selection. Different techniques can be applied for this selection. Most of them are based on the solution quality (fitness).", usages={@GamlAnnotations.usage(value="As other batch methods, the basic syntax of the `genetic` statement uses `method genetic` instead of the expected `genetic name: id` : ", examples={@GamlAnnotations.example(value="method genetic [facet: value];", isExecutable=false)}), @GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method genetic maximize: food_gathered pop_dim: 5 crossover_prob: 0.7 mutation_prob: 0.1 nb_prelim_gen: 1 max_gen: 20; ", isExecutable=false)})})
public class GeneticAlgorithm
extends AOptimizationAlgorithm {
    int populationDim = 3;
    double crossoverProb = 0.7;
    double mutationProb = 0.1;
    int nbPrelimGenerations = 1;
    int maxGenerations = 20;
    Initialization initPop;
    CrossOver crossOverOp;
    Mutation mutationOp;
    Selection selectionOp;
    Boolean improveSolution;
    protected static final String POP_DIM = "pop_dim";
    protected static final String CROSSOVER_PROB = "crossover_prob";
    protected static final String MUTATION_PROB = "mutation_prob";
    protected static final String NB_GEN = "nb_prelim_gen";
    protected static final String MAX_GEN = "max_gen";
    protected static final String IMPROVE_SOL = "improve_sol";
    protected static final String STOCHASTIC_SEL = "stochastic_sel";
    protected Neighborhood neighborhood;

    public GeneticAlgorithm(IDescription iDescription) {
        super(iDescription);
        this.initParams();
    }

    @Override
    public void initializeFor(IScope iScope, BatchAgent batchAgent) throws GamaRuntimeException {
        super.initializeFor(iScope, batchAgent);
        IExpression iExpression = this.getFacet(IMPROVE_SOL);
        if (iExpression != null) {
            this.improveSolution = Cast.asBool(iScope, iExpression.value(iScope));
        }
        if (this.improveSolution != null && this.improveSolution.booleanValue()) {
            List<IParameter.Batch> list = batchAgent.getParametersToExplore();
            this.neighborhood = new Neighborhood1Var(list);
        }
    }

    @Override
    public void initParams(IScope iScope) {
        IExpression iExpression;
        IExpression iExpression2;
        IExpression iExpression3;
        IExpression iExpression4;
        Object object;
        this.initPop = new InitializationUniform();
        this.crossOverOp = new CrossOver1Pt();
        this.mutationOp = new Mutation1Var();
        IExpression iExpression5 = this.getFacet(STOCHASTIC_SEL);
        this.selectionOp = iExpression5 != null ? ((object = Cast.asBool(iScope, iExpression5.value(iScope))) != null && ((Boolean)object).booleanValue() ? new SelectionRoulette() : new SelectionBest()) : new SelectionBest();
        object = this.getFacet(POP_DIM);
        if (object != null) {
            this.populationDim = Cast.asInt(iScope, object.value(iScope));
        }
        if ((iExpression4 = this.getFacet(CROSSOVER_PROB)) != null) {
            this.crossoverProb = Cast.asFloat(iScope, iExpression4.value(iScope));
        }
        if ((iExpression3 = this.getFacet(MUTATION_PROB)) != null) {
            this.mutationProb = Cast.asFloat(iScope, iExpression3.value(iScope));
        }
        if ((iExpression2 = this.getFacet(NB_GEN)) != null) {
            this.nbPrelimGenerations = Cast.asInt(iScope, iExpression2.value(iScope));
        }
        if ((iExpression = this.getFacet(MAX_GEN)) != null) {
            this.maxGenerations = Cast.asInt(iScope, iExpression.value(iScope));
        }
    }

    @Override
    public ParametersSet findBestSolution(IScope iScope) throws GamaRuntimeException {
        List<IParameter.Batch> list = this.getCurrentExperiment().getParametersToExplore();
        this.setBestFitness(null);
        this.initializeTestedSolutions();
        List<Chromosome> list2 = this.initPop.initializePop(iScope, list, this);
        int n = 1;
        while (n <= this.maxGenerations) {
            Collector.AsSet asSet;
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                asSet = Collector.getSet();
                try {
                    for (Chromosome chromosome : list2) {
                        if (!(iScope.getRandom().next() < this.crossoverProb) || list.isEmpty()) continue;
                        asSet.addAll(this.crossOverOp.crossOver(iScope, chromosome, list2.get(iScope.getRandom().between(0, list2.size() - 1))));
                    }
                    list2.addAll(asSet.items());
                }
                finally {
                    if (asSet != null) {
                        asSet.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var6_8 = null;
            try {
                asSet = Collector.getSet();
                try {
                    for (Chromosome chromosome : list2) {
                        if (!(iScope.getRandom().next() < this.mutationProb) || list.isEmpty()) continue;
                        asSet.add(this.mutationOp.mutate(iScope, chromosome, list));
                    }
                    list2.addAll(asSet.items());
                }
                finally {
                    if (asSet != null) {
                        asSet.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            if (GamaExecutorService.shouldRunAllSimulationsInParallel(this.getCurrentExperiment())) {
                this.computePopFitnessAll(iScope, list2);
            } else {
                this.computePopFitness(iScope, list2);
            }
            list2 = list2.stream().distinct().toList();
            list2 = this.selectionOp.select(iScope, list2, this.populationDim, this.isMaximize());
            ++n;
        }
        return this.getBestSolution();
    }

    public void computePopFitness(IScope iScope, List<Chromosome> list) throws GamaRuntimeException {
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return;
        }
        for (Chromosome chromosome : list) {
            this.computeChroFitness(iScope, chromosome);
        }
        if (this.improveSolution != null && this.improveSolution.booleanValue()) {
            for (Chromosome chromosome : list) {
                ParametersSet parametersSet = chromosome.convertToSolution(iScope, this.getCurrentExperiment().getParametersToExplore());
                parametersSet = this.improveSolution(iScope, parametersSet, chromosome.getFitness());
                chromosome.update(iScope, parametersSet);
                double d = (Double)this.testedSolutions.get(parametersSet);
                chromosome.setFitness(d);
            }
        }
    }

    public void computePopFitnessAll(IScope iScope, List<Chromosome> list) throws GamaRuntimeException {
        ParametersSet parametersSet;
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return;
        }
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>();
        IMap iMap = GamaMapFactory.create();
        for (Chromosome chromosome : list) {
            Iterator<Chromosome> iterator = chromosome.convertToSolution(iScope, batchAgent.getParametersToExplore());
            iMap.put(chromosome, iterator);
            if (this.testedSolutions.containsKey(iterator)) continue;
            arrayList.add((ParametersSet)((Object)iterator));
        }
        Map<ParametersSet, Double> map = batchAgent.runSimulationsAndReturnResults(arrayList).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getFirstFitness((Map)entry.getValue())));
        this.testedSolutions.putAll(map);
        for (Chromosome chromosome : list) {
            parametersSet = (ParametersSet)iMap.get(chromosome);
            if (parametersSet == null) continue;
            Double d = map.get(parametersSet);
            if (d != null) {
                chromosome.setFitness(d);
                continue;
            }
            chromosome.setFitness((Double)this.testedSolutions.get(parametersSet));
        }
        if (this.improveSolution != null && this.improveSolution.booleanValue()) {
            for (Chromosome chromosome : list) {
                parametersSet = chromosome.convertToSolution(iScope, batchAgent.getParametersToExplore());
                parametersSet = this.improveSolution(iScope, parametersSet, chromosome.getFitness());
                chromosome.update(iScope, parametersSet);
                double d = (Double)this.testedSolutions.get(parametersSet);
                chromosome.setFitness(d);
            }
        }
    }

    public void computeChroFitness(IScope iScope, Chromosome chromosome) {
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return;
        }
        ParametersSet parametersSet = chromosome.convertToSolution(iScope, batchAgent.getParametersToExplore());
        Double d = (Double)this.testedSolutions.get(parametersSet);
        if (d == null) {
            d = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(parametersSet));
        }
        this.testedSolutions.put(parametersSet, d);
        chromosome.setFitness(d);
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        list.add(new ParameterAdapter("Mutation probability", "Calibration experiment", 2){

            @Override
            public Object value() {
                return GeneticAlgorithm.this.mutationProb;
            }
        });
        list.add(new ParameterAdapter("Crossover probability", "Calibration experiment", 2){

            @Override
            public Object value() {
                return GeneticAlgorithm.this.crossoverProb;
            }
        });
        list.add(new ParameterAdapter("Population dimension", "Calibration experiment", 1){

            @Override
            public Object value() {
                return GeneticAlgorithm.this.populationDim;
            }
        });
        list.add(new ParameterAdapter("Preliminary number of generations", "Calibration experiment", 2){

            @Override
            public Object value() {
                return GeneticAlgorithm.this.nbPrelimGenerations;
            }
        });
        list.add(new ParameterAdapter("Max. number of generations", "Calibration experiment", 2){

            @Override
            public Object value() {
                return GeneticAlgorithm.this.maxGenerations;
            }
        });
    }

    public Map<ParametersSet, Double> testSolutions(List<ParametersSet> list) {
        IMap iMap = GamaMapFactory.create();
        list.removeIf(parametersSet -> parametersSet == null);
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>();
        for (ParametersSet iValue2 : list) {
            if (this.testedSolutions.containsKey(iValue2)) {
                iMap.put(iValue2, (Double)this.testedSolutions.get(iValue2));
                continue;
            }
            arrayList.add(iValue2);
        }
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return iMap;
        }
        Map<ParametersSet, Double> map = batchAgent.runSimulationsAndReturnResults(arrayList).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getFirstFitness((Map)entry.getValue())));
        this.testedSolutions.putAll(map);
        iMap.putAll(map);
        return iMap;
    }

    private ParametersSet improveSolution(IScope iScope, ParametersSet parametersSet, double d) {
        List<ParametersSet> list;
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return parametersSet;
        }
        ParametersSet object = parametersSet;
        double d2 = d;
        while (!(list = this.neighborhood.neighbor(iScope, parametersSet)).isEmpty()) {
            ParametersSet object2 = null;
            if (GamaExecutorService.shouldRunAllSimulationsInParallel(this.getCurrentExperiment()) && !this.getCurrentExperiment().getParametersToExplore().isEmpty()) {
                ParametersSet parametersSet2 = this.testSolutions(list);
                for (ParametersSet parametersSet3 : parametersSet2.keySet()) {
                    Double d3 = (Double)parametersSet2.get(parametersSet3);
                    if (!(this.isMaximize() && d3 > d2) && (this.isMaximize() || !(d3 < d2))) continue;
                    object2 = parametersSet3;
                    d2 = d3;
                    object = object2;
                }
            } else {
                for (ParametersSet parametersSet2 : list) {
                    if (parametersSet2 == null) continue;
                    Object object3 = (Double)this.testedSolutions.get(parametersSet2);
                    if (object3 == null) {
                        object3 = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(parametersSet2));
                        this.testedSolutions.put(parametersSet2, object3);
                    }
                    if (!(this.isMaximize() && (Double)object3 > d2) && (this.isMaximize() || !((Double)object3 < d2))) continue;
                    object2 = parametersSet2;
                    d2 = (Double)object3;
                    object = object2;
                }
            }
            if (object2 == null) break;
            object = object2;
        }
        return object;
    }

    public int getPopulationDim() {
        return this.populationDim;
    }

    public double getMutationProb() {
        return this.mutationProb;
    }

    public int getNbPrelimGenerations() {
        return this.nbPrelimGenerations;
    }

    public int getMaxGenerations() {
        return this.maxGenerations;
    }

    public Mutation getMutationOp() {
        return this.mutationOp;
    }
}

