/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.root;

import gama.dev.STRINGS;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.lang3.SystemUtils;

public class SystemInfo {
    private static final long KIBI = 1024L;
    private static final long MEBI = 0x100000L;
    private static final long GIBI = 0x40000000L;
    private static final long TEBI = 0x10000000000L;
    private static final long PEBI = 0x4000000000000L;
    private static final long EXBI = 0x1000000000000000L;
    static List<String> displays;
    public static String graphicsCard;
    public static String physicalMemory;
    static List<String> INFO;

    static {
        graphicsCard = "Not available";
    }

    public static String formatBytes(long l) {
        if (l == 1L) {
            return String.format(Locale.ROOT, "%d byte", l);
        }
        if (l < 1024L) {
            return String.format(Locale.ROOT, "%d bytes", l);
        }
        if (l < 0x100000L) {
            return SystemInfo.formatUnits(l, 1024L, "KB");
        }
        if (l < 0x40000000L) {
            return SystemInfo.formatUnits(l, 0x100000L, "MB");
        }
        if (l < 0x10000000000L) {
            return SystemInfo.formatUnits(l, 0x40000000L, "GB");
        }
        if (l < 0x4000000000000L) {
            return SystemInfo.formatUnits(l, 0x10000000000L, "TB");
        }
        if (l < 0x1000000000000000L) {
            return SystemInfo.formatUnits(l, 0x4000000000000L, "PB");
        }
        return SystemInfo.formatUnits(l, 0x1000000000000000L, "EiB");
    }

    private static String formatUnits(long l, long l2, String string) {
        if (l % l2 == 0L) {
            return String.format(Locale.ROOT, "%d %s", l / l2, string);
        }
        return String.format(Locale.ROOT, "%.1f %s", (double)l / (double)l2, string);
    }

    public static void setGraphicsCard(String string) {
        graphicsCard = string;
    }

    public static String getSystemInfo() {
        Object object2;
        displays = new ArrayList<String>();
        if (!GraphicsEnvironment.isHeadless()) {
            object2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = ((GraphicsEnvironment)object2).getScreenDevices();
            int n = graphicsDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice object3 = graphicsDeviceArray[n2];
                displays.add(object3.getDisplayMode().getWidth() + "x" + object3.getDisplayMode().getHeight() + " zoom " + String.valueOf((int)object3.getDefaultConfiguration().getDefaultTransform().getScaleX() * 100) + "% " + (object3.equals(((GraphicsEnvironment)object2).getDefaultScreenDevice()) ? "(primary)" : ""));
                ++n2;
            }
        }
        if (physicalMemory == null) {
            physicalMemory = "Memory not available";
            object2 = ManagementFactory.getPlatformMBeanServer();
            try {
                Object object = object2.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalMemorySize");
                physicalMemory = SystemInfo.formatBytes(Long.parseLong(object.toString()));
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException jMException) {
                jMException.printStackTrace();
            }
        }
        INFO = new ArrayList<String>();
        INFO.add("\n");
        INFO.add(STRINGS.PAD((String)"GAMA VERSION:", (int)20) + System.getProperty("gama.version", "2025.5.2-SNAPSHOT").replace("-SNAPSHOT", "") + " commit " + System.getProperty("gama.commit", "Not available"));
        INFO.add(STRINGS.PAD((String)"COMPUTER:", (int)20) + SystemUtils.OS_NAME + " " + SystemUtils.OS_VERSION + " on " + SystemUtils.OS_ARCH + " (" + Runtime.getRuntime().availableProcessors() + " cores, " + physicalMemory + ")");
        INFO.add(STRINGS.PAD((String)"VIRTUAL MACHINE:", (int)20) + SystemUtils.JAVA_VM_NAME + " " + SystemUtils.JAVA_VM_VENDOR + " version " + SystemUtils.JAVA_VM_VERSION);
        INFO.add(STRINGS.PAD((String)"AVAILABLE MEMORY:", (int)20) + SystemInfo.formatBytes(Runtime.getRuntime().freeMemory()) + " / " + SystemInfo.formatBytes(Runtime.getRuntime().totalMemory()));
        INFO.add(STRINGS.PAD((String)"GRAPHICS CARD:", (int)20) + graphicsCard);
        if (displays.isEmpty()) {
            INFO.add(STRINGS.PAD((String)"MONITORS:", (int)20) + "None detected");
        } else {
            int n = 0;
            while (n < displays.size()) {
                INFO.add(STRINGS.PAD((String)("MONITOR #" + n + ":"), (int)20) + displays.get(n));
                ++n;
            }
        }
        object2 = new StringBuilder();
        for (String string : INFO) {
            ((StringBuilder)object2).append(string);
            if (string == null || string.endsWith("\n")) continue;
            ((StringBuilder)object2).append('\n');
        }
        return ((StringBuilder)object2).toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(SystemInfo.getSystemInfo());
    }
}

