/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.display;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.interfaces.IAsset;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.interfaces.ILayer;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.display.AbstractDisplayGraphics;
import gama.core.outputs.layers.OverlayLayer;
import gama.core.outputs.layers.charts.ChartOutput;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.core.util.file.GamaGeometryFile;
import gama.core.util.matrix.GamaField;
import gama.core.util.matrix.IField;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import gama.gaml.statements.draw.ShapeDrawingAttributes;
import gama.gaml.statements.draw.TextDrawingAttributes;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.List;
import org.locationtech.jts.awt.PointTransformation;
import org.locationtech.jts.awt.ShapeWriter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Puntal;

public class AWTDisplayGraphics
extends AbstractDisplayGraphics
implements ImageObserver {
    private Graphics2D currentRenderer;
    private Graphics2D overlayRenderer;
    private Graphics2D normalRenderer;
    private Rectangle2D temporaryEnvelope = null;
    private static final Font defaultFont = new Font("Helvetica", 1, 12);
    private final Java2DPointTransformation pf = new Java2DPointTransformation();
    private final ShapeWriter sw = new ShapeWriter((PointTransformation)this.pf);
    AffineTransform imageTransform = new AffineTransform();
    final Rectangle2D chartRect = new Rectangle2D.Double();
    boolean drawChart = true;

    static {
        QUALITY_RENDERING.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        QUALITY_RENDERING.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        QUALITY_RENDERING.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        QUALITY_RENDERING.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        QUALITY_RENDERING.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        MEDIUM_RENDERING.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        MEDIUM_RENDERING.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        MEDIUM_RENDERING.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        MEDIUM_RENDERING.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        MEDIUM_RENDERING.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        SPEED_RENDERING.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        SPEED_RENDERING.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        SPEED_RENDERING.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        SPEED_RENDERING.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        SPEED_RENDERING.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public AWTDisplayGraphics(Graphics2D graphics2D) {
        this.setGraphics2D(graphics2D);
        this.sw.setRemoveDuplicatePoints(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.currentRenderer != null) {
            this.currentRenderer.dispose();
        }
        if (this.normalRenderer != null) {
            this.normalRenderer.dispose();
        }
        if (this.overlayRenderer != null) {
            this.overlayRenderer.dispose();
        }
    }

    @Override
    public boolean beginDrawingLayers() {
        this.currentRenderer.setRenderingHints(this.data.isAntialias() ? QUALITY_RENDERING : SPEED_RENDERING);
        return true;
    }

    @Override
    public void beginDrawingLayer(ILayer iLayer) {
        super.beginDrawingLayer(iLayer);
        this.pf.adapt();
    }

    @Override
    public void setAlpha(double d) {
        super.setAlpha(d);
        this.currentRenderer.setComposite(AlphaComposite.getInstance(3, (float)d));
    }

    @Override
    public Rectangle2D drawField(IField iField, MeshDrawingAttributes meshDrawingAttributes) {
        Object object;
        List list = meshDrawingAttributes.getTextures();
        if (list != null) {
            object = list.get(0);
            if (object instanceof IImageProvider) {
                IImageProvider iImageProvider = (IImageProvider)object;
                return this.drawAsset(iImageProvider, meshDrawingAttributes);
            }
            if (object instanceof BufferedImage) {
                BufferedImage bufferedImage = (BufferedImage)object;
                return this.drawImage(bufferedImage, meshDrawingAttributes);
            }
        }
        if (!(iField instanceof GamaField)) {
            return null;
        }
        object = (GamaField)iField;
        GamaField gamaField = ((GamaField)object).flatten(this.surface.getScope(), meshDrawingAttributes.getColorProvider());
        meshDrawingAttributes.setSize(null);
        return this.drawImage(gamaField.getImage(this.surface.getScope()), meshDrawingAttributes);
    }

    @Override
    public Rectangle2D drawAsset(IAsset iAsset, DrawingAttributes drawingAttributes) {
        IScope.IGraphicsScope iGraphicsScope = this.surface.getScope();
        if (iAsset instanceof IImageProvider) {
            IImageProvider iImageProvider = (IImageProvider)iAsset;
            return this.drawImage(iImageProvider.getImage(iGraphicsScope, drawingAttributes.useCache()), drawingAttributes);
        }
        if (!(iAsset instanceof GamaGeometryFile)) {
            return null;
        }
        IShape iShape = Cast.asGeometry(iGraphicsScope, iAsset);
        if (iShape == null) {
            return null;
        }
        AxisAngle axisAngle = drawingAttributes.getRotation();
        iShape = GamaShapeFactory.createFrom(iShape).withRotation(axisAngle).withLocation(drawingAttributes.getLocation()).withScaling(drawingAttributes.getSize(), true);
        GamaColor gamaColor = drawingAttributes.getColor();
        return this.drawShape(iShape.getInnerGeometry(), new ShapeDrawingAttributes(iShape.getLocation(), gamaColor, gamaColor, null));
    }

    @Override
    public Rectangle2D drawImage(BufferedImage bufferedImage, DrawingAttributes drawingAttributes) {
        int n;
        int n2;
        double d;
        double d2;
        this.imageTransform.setToIdentity();
        if (drawingAttributes.getLocation() == null) {
            d2 = this.getXOffsetInPixels();
            d = this.getYOffsetInPixels();
        } else {
            d2 = this.xFromModelUnitsToPixels(drawingAttributes.getLocation().getX());
            d = this.yFromModelUnitsToPixels(drawingAttributes.getLocation().getY());
        }
        this.imageTransform.translate(d2, d);
        if (drawingAttributes.getSize() == null) {
            n2 = this.getLayerWidth();
            n = this.getLayerHeight();
        } else {
            n2 = (int)this.wFromModelUnitsToPixels(drawingAttributes.getSize().getX());
            n = (int)this.hFromModelUnitsToPixels(drawingAttributes.getSize().getY());
        }
        if (drawingAttributes.getAngle() != null) {
            this.imageTransform.rotate(Math.PI / 180 * drawingAttributes.getAngle(), (double)n2 / 2.0, (double)n / 2.0);
        }
        if (n2 != bufferedImage.getWidth() || n != bufferedImage.getHeight()) {
            this.imageTransform.scale((double)n2 / (double)bufferedImage.getWidth(), (double)n / (double)bufferedImage.getHeight());
        }
        this.currentRenderer.drawImage(bufferedImage, this.imageTransform, null);
        if (drawingAttributes.getBorder() != null) {
            this.drawGridLine(bufferedImage, drawingAttributes.getBorder());
        }
        this.rect.setRect(d2, d, n2, n);
        if (this.highlight) {
            this.highlightRectangleInPixels(this.rect);
        }
        return this.rect.getBounds2D();
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int n, int n2) {
        Image image = bufferedImage.getScaledInstance(n, n2, 4);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    @Override
    public Rectangle2D drawString(String string, TextDrawingAttributes textDrawingAttributes) {
        double d;
        double d2;
        if (string.contains("\n")) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            String[] stringArray = string.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                Rectangle2D rectangle2D = this.drawString(string2, textDrawingAttributes);
                textDrawingAttributes.getLocation().setY(textDrawingAttributes.getLocation().getY() + rectangle2D.getHeight());
                double_.add(rectangle2D);
                ++n2;
            }
            return double_;
        }
        this.currentRenderer.setColor(this.highlight ? this.data.getHighlightColor() : textDrawingAttributes.getColor());
        if (textDrawingAttributes.getLocation() == null) {
            d2 = this.getXOffsetInPixels();
            d = this.getYOffsetInPixels();
        } else {
            d2 = this.xFromModelUnitsToPixels(textDrawingAttributes.getLocation().getX());
            d = this.yFromModelUnitsToPixels(textDrawingAttributes.getLocation().getY());
        }
        this.setFont(textDrawingAttributes.getFont());
        Rectangle2D rectangle2D = this.currentRenderer.getFontMetrics().getStringBounds(string, this.currentRenderer);
        float f = this.currentRenderer.getFontMetrics().getLineMetrics(string, this.currentRenderer).getAscent();
        float f2 = this.currentRenderer.getFontMetrics().getLineMetrics(string, this.currentRenderer).getDescent();
        rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), Math.min(rectangle2D.getHeight(), (double)(f + f2)));
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        d2 -= d3 * textDrawingAttributes.anchor.x;
        d += (d4 - (double)f2) * textDrawingAttributes.anchor.y;
        AffineTransform affineTransform = this.currentRenderer.getTransform();
        if (textDrawingAttributes.getAngle() != null) {
            this.currentRenderer.rotate(Math.PI / 180 * textDrawingAttributes.getAngle(), d2 + rectangle2D.getWidth() / 2.0, d + rectangle2D.getHeight() / 2.0);
        }
        this.currentRenderer.drawString(string, (int)d2, (int)d);
        this.currentRenderer.setTransform(affineTransform);
        rectangle2D.setFrame(d2, d, rectangle2D.getWidth(), rectangle2D.getHeight());
        return rectangle2D;
    }

    private void setFont(Font font) {
        Font font2 = this.surface == null ? font : this.surface.computeFont(font);
        this.currentRenderer.setFont(font2);
    }

    @Override
    public Rectangle2D drawShape(Geometry geometry2, DrawingAttributes drawingAttributes) {
        GamaColor gamaColor;
        boolean bl;
        if (geometry2 == null) {
            return null;
        }
        Geometry geometry3 = geometry2;
        if (geometry3 instanceof GeometryCollection) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            GeometryUtils.applyToInnerGeometries(geometry3, geometry -> double_.add(this.drawShape(geometry, drawingAttributes)));
            return double_;
        }
        boolean bl2 = bl = geometry3 instanceof Lineal || geometry3 instanceof Puntal;
        if (bl && drawingAttributes.getDepth() != null) {
            geometry3 = GeometryUtils.GEOMETRY_FACTORY.createFatLine(geometry3, drawingAttributes.getDepth());
            bl = false;
            drawingAttributes.setFill(drawingAttributes.getBorder());
        }
        GamaColor gamaColor2 = gamaColor = bl ? drawingAttributes.getColor() : drawingAttributes.getBorder();
        if (gamaColor == null && drawingAttributes.isEmpty()) {
            gamaColor = drawingAttributes.getColor();
        }
        if (this.highlight) {
            drawingAttributes.setFill(GamaColor.get(this.data.getHighlightColor().getRGB()));
            if (gamaColor != null) {
                gamaColor = drawingAttributes.getColor();
            }
        }
        Shape shape = this.sw.toShape(geometry3);
        try {
            Rectangle2D rectangle2D = shape.getBounds2D();
            this.currentRenderer.setColor(drawingAttributes.getColor());
            if (!bl && !drawingAttributes.isEmpty()) {
                Object object;
                BufferedImage bufferedImage = null;
                List list = drawingAttributes.getTextures();
                if (list != null && list.size() > 0) {
                    object = list.get(list.size() - 1);
                    if (object instanceof IImageProvider) {
                        IImageProvider iImageProvider = (IImageProvider)object;
                        bufferedImage = iImageProvider.getImage(this.getSurface().getScope(), drawingAttributes.useCache());
                    } else {
                        Object e = list.get(list.size() - 1);
                        if (e instanceof BufferedImage) {
                            BufferedImage bufferedImage2;
                            bufferedImage = bufferedImage2 = (BufferedImage)e;
                        }
                    }
                } else if (list instanceof BufferedImage) {
                    BufferedImage bufferedImage3;
                    bufferedImage = bufferedImage3 = (BufferedImage)((Object)list);
                }
                if (bufferedImage != null) {
                    object = new TexturePaint(bufferedImage, rectangle2D);
                    this.currentRenderer.setPaint((Paint)object);
                }
                this.currentRenderer.fill(shape);
            }
            if (bl || gamaColor != null || drawingAttributes.isEmpty()) {
                if (gamaColor != null) {
                    this.currentRenderer.setColor(gamaColor);
                }
                this.currentRenderer.draw(shape);
            }
            return rectangle2D;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void fillBackground(Color color) {
        this.setAlpha(1.0);
        this.currentRenderer.setColor(color);
        this.currentRenderer.fillRect(0, 0, (int)this.surface.getDisplayWidth(), (int)this.surface.getDisplayHeight());
    }

    public void drawGridLine(BufferedImage bufferedImage, Color color) {
        double d = (double)this.getLayerWidth() / (double)bufferedImage.getWidth();
        double d2 = (double)this.getLayerHeight() / (double)bufferedImage.getHeight();
        if (d < 2.0 || d2 < 2.0) {
            return;
        }
        Line2D.Double double_ = new Line2D.Double();
        this.currentRenderer.setColor(color);
        double d3 = 0.0;
        double d4 = this.getLayerWidth();
        while (d3 < d4 + 1.0) {
            ((Line2D)double_).setLine(this.getXOffsetInPixels() + d3, this.getYOffsetInPixels(), this.getXOffsetInPixels() + d3, this.getYOffsetInPixels() + (double)this.getLayerHeight());
            this.currentRenderer.draw(double_);
            d3 += d;
        }
        ((Line2D)double_).setLine(this.getXOffsetInPixels() + (double)this.getLayerWidth() - 1.0, this.getYOffsetInPixels(), this.getXOffsetInPixels() + (double)this.getLayerWidth() - 1.0, this.getYOffsetInPixels() + (double)this.getLayerHeight() - 1.0);
        this.currentRenderer.draw(double_);
        d3 = 0.0;
        d4 = this.getLayerHeight();
        while (d3 < d4 + 1.0) {
            ((Line2D)double_).setLine(this.getXOffsetInPixels(), this.getYOffsetInPixels() + d3, this.getXOffsetInPixels() + (double)this.getLayerWidth(), this.getYOffsetInPixels() + d3);
            this.currentRenderer.draw(double_);
            d3 += d2;
        }
        ((Line2D)double_).setLine(this.getXOffsetInPixels(), this.getYOffsetInPixels() + (double)this.getLayerHeight() - 1.0, this.getXOffsetInPixels() + (double)this.getLayerWidth() - 1.0, this.getYOffsetInPixels() + (double)this.getLayerHeight() - 1.0);
        this.currentRenderer.draw(double_);
    }

    private void highlightRectangleInPixels(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return;
        }
        Stroke stroke = this.currentRenderer.getStroke();
        this.currentRenderer.setStroke(new BasicStroke(5.0f));
        Color color = this.currentRenderer.getColor();
        this.currentRenderer.setColor(this.data.getHighlightColor());
        this.currentRenderer.draw(rectangle2D);
        this.currentRenderer.setStroke(stroke);
        this.currentRenderer.setColor(color);
    }

    @Override
    public boolean is2D() {
        return true;
    }

    @Override
    public void beginOverlay(OverlayLayer overlayLayer) {
        this.currentRenderer = this.overlayRenderer;
        this.currentRenderer.setColor(overlayLayer.getData().getBackgroundColor(this.getSurface().getScope()));
        int n = (int)this.getXOffsetInPixels();
        int n2 = (int)this.getYOffsetInPixels();
        int n3 = this.getLayerWidth();
        int n4 = this.getLayerHeight();
        if (overlayLayer.getData().isRounded()) {
            this.currentRenderer.fillRoundRect(n, n2, n3, n4, 10, 10);
        } else {
            this.currentRenderer.fillRect(n, n2, n3, n4);
        }
        if (overlayLayer.getData().getBorderColor() != null) {
            this.currentRenderer.setColor(overlayLayer.getData().getBorderColor());
            if (overlayLayer.getData().isRounded()) {
                this.currentRenderer.drawRoundRect(n, n2, n3, n4, 10, 10);
            } else {
                this.currentRenderer.drawRect(n, n2, n3, n4);
            }
        }
    }

    @Override
    public void endOverlay() {
        this.currentRenderer = this.normalRenderer;
    }

    public void setGraphics2D(Graphics2D graphics2D) {
        this.normalRenderer = graphics2D;
        this.currentRenderer = graphics2D;
        if (graphics2D != null) {
            this.setFont(defaultFont);
        }
    }

    public void setUntranslatedGraphics2D(Graphics2D graphics2D) {
        this.overlayRenderer = graphics2D;
    }

    @Override
    public void accumulateTemporaryEnvelope(Rectangle2D rectangle2D) {
        if (this.temporaryEnvelope == null) {
            this.temporaryEnvelope = rectangle2D;
        } else {
            this.temporaryEnvelope.add(rectangle2D);
        }
    }

    @Override
    public Rectangle2D getAndWipeTemporaryEnvelope() {
        Rectangle2D rectangle2D = this.temporaryEnvelope;
        this.temporaryEnvelope = null;
        return rectangle2D;
    }

    @Override
    public Rectangle2D drawChart(ChartOutput chartOutput) {
        if (!this.drawChart) {
            return this.chartRect;
        }
        BufferedImage bufferedImage = chartOutput.getImage(this.getLayerWidth(), this.getLayerHeight(), this.getSurface().getData().isAntialias());
        this.drawChart = this.currentRenderer.drawImage((Image)bufferedImage, (int)this.getXOffsetInPixels(), (int)this.getYOffsetInPixels(), this);
        return this.chartRect;
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.drawChart = (n & 0x20) == 0;
        return this.drawChart;
    }

    private class Java2DPointTransformation
    implements PointTransformation {
        double xOffset;
        double yOffset;
        double xRatio;
        double yRatio;

        private Java2DPointTransformation() {
        }

        public void transform(Coordinate coordinate, Point2D point2D) {
            point2D.setLocation(this.xOffset + this.xRatio * coordinate.x, this.yOffset + this.yRatio * coordinate.y);
        }

        public void adapt() {
            this.xOffset = AWTDisplayGraphics.this.getXOffsetInPixels();
            this.yOffset = AWTDisplayGraphics.this.getYOffsetInPixels();
            this.xRatio = AWTDisplayGraphics.this.getxRatioBetweenPixelsAndModelUnits();
            this.yRatio = AWTDisplayGraphics.this.getyRatioBetweenPixelsAndModelUnits();
        }
    }
}

