/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.IImageProvider;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.LayerData;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.matrix.IField;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.AttributeHolder;
import gama.gaml.types.GamaFieldType;
import gama.gaml.types.Types;
import java.awt.Color;

public class MeshLayerData
extends LayerData {
    static GamaColor defaultLineColor = GamaColor.get(Color.black);
    boolean shouldComputeValues = true;
    public static final Double ABOVE = -2.147483647E9;
    IField values;
    final AttributeHolder.Attribute<GamaColor> line;
    final AttributeHolder.Attribute<IImageProvider> texture;
    final AttributeHolder.Attribute<Integer> smooth;
    final AttributeHolder.Attribute<IField> elevation;
    final AttributeHolder.Attribute<Boolean> triangulation;
    final AttributeHolder.Attribute<Boolean> grayscale;
    final AttributeHolder.Attribute<Boolean> text;
    final AttributeHolder.Attribute<Boolean> wireframe;
    final AttributeHolder.Attribute<Double> noData;
    final AttributeHolder.Attribute<Object> color;
    final AttributeHolder.Attribute<Double> scale;
    final AttributeHolder.Attribute<Double> above;
    private final GamaPoint dim = new GamaPoint();

    public MeshLayerData(ILayerStatement iLayerStatement) throws GamaRuntimeException {
        super(iLayerStatement);
        this.size = this.create("size", (IScope iScope, IExpression iExpression) -> {
            Object object = iExpression.value(iScope);
            if (object instanceof Number) {
                return new GamaPoint(1.0, 1.0, ((Number)object).doubleValue());
            }
            return Cast.asPoint(iScope, object);
        }, Types.POINT, new GamaPoint(1.0, 1.0, 1.0));
        this.line = this.create("border", Types.COLOR, null);
        this.elevation = this.create("source", (IScope iScope, IExpression iExpression) -> {
            if (iExpression != null) {
                return this.buildValues(iScope, iExpression.value(iScope));
            }
            return null;
        }, Types.NO_TYPE, null);
        this.triangulation = this.create("triangulation", Types.BOOL, false);
        this.smooth = this.create("smooth", (IScope iScope, IExpression iExpression) -> {
            Object object = iExpression.value(iScope);
            return object instanceof Boolean ? (((Boolean)object).booleanValue() ? 1 : 0) : Cast.asInt(iScope, object);
        }, Types.INT, Integer.valueOf(0));
        this.grayscale = this.create("grayscale", Types.BOOL, false);
        this.wireframe = this.create("wireframe", Types.BOOL, false);
        this.text = this.create("text", Types.BOOL, false);
        this.color = this.create("color", Types.NO_TYPE, null);
        this.scale = this.create("scale", Types.FLOAT, null);
        this.noData = this.create("no_data", Types.FLOAT, Double.MAX_VALUE);
        this.above = this.create("above", Types.FLOAT, ABOVE);
        this.texture = this.create("texture", (IScope iScope, IExpression iExpression) -> {
            Object object = iExpression.value(iScope);
            if (object instanceof IImageProvider) {
                return (IImageProvider)object;
            }
            throw GamaRuntimeException.error("The texture of a field must be an image file", iScope);
        }, Types.FILE, null);
    }

    @Override
    public boolean compute(IScope iScope, IGraphics iGraphics) throws GamaRuntimeException {
        boolean bl = super.compute(iScope, iGraphics);
        this.shouldComputeValues = super.getRefresh();
        return bl;
    }

    private IField buildValues(IScope iScope, Object object) {
        if (this.values == null || this.shouldComputeValues) {
            this.values = GamaFieldType.buildField(iScope, object);
            this.dim.setLocation(this.values.getCols(iScope), this.values.getRows(iScope), 0.0);
        }
        return this.values;
    }

    public Boolean isTriangulated() {
        return this.triangulation.get();
    }

    public Boolean isGrayScaled() {
        return this.grayscale.get();
    }

    public Boolean isWireframe() {
        return this.wireframe.get();
    }

    public Boolean isShowText() {
        return this.text.get();
    }

    public IImageProvider textureFile() {
        return this.texture.get();
    }

    public GamaColor getLineColor() {
        return this.line.get() == null && this.wireframe.get() != false ? defaultLineColor : this.line.get();
    }

    public boolean drawLines() {
        return this.line.get() != null || this.wireframe.get() != false;
    }

    public GamaPoint getDimension() {
        return this.dim;
    }

    public IField getElevationMatrix(IScope iScope) {
        return this.elevation.get();
    }

    public Object getColor() {
        return this.color.get();
    }

    public Integer getSmooth() {
        return this.smooth.get();
    }

    public Double getScale() {
        return this.scale.get();
    }

    public double getNoDataValue() {
        return this.noData.get();
    }

    @Override
    public Boolean isSelectable() {
        return false;
    }

    public double getAbove() {
        return this.above.get();
    }
}

