/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime;

import gama.core.common.interfaces.IDisposable;
import gama.core.common.util.PoolUtils;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;

public class AgentExecutionContext
implements IDisposable {
    private static final PoolUtils.ObjectPool<AgentExecutionContext> POOL = PoolUtils.create("Agent Execution Context", true, AgentExecutionContext::new, null, null);
    private static final boolean POOL_ACTIVE = false;
    IAgent agent;
    AgentExecutionContext outer;

    public static AgentExecutionContext create(IAgent iAgent, AgentExecutionContext agentExecutionContext) {
        AgentExecutionContext agentExecutionContext2 = new AgentExecutionContext();
        agentExecutionContext2.agent = iAgent;
        agentExecutionContext2.outer = agentExecutionContext;
        return agentExecutionContext2;
    }

    private AgentExecutionContext() {
    }

    public IAgent getAgent() {
        return this.agent;
    }

    public String toString() {
        return "context of " + String.valueOf(this.agent);
    }

    public AgentExecutionContext getOuterContext() {
        return this.outer;
    }

    @Override
    public void dispose() {
        this.agent = null;
        this.outer = null;
    }

    public AgentExecutionContext createCopy() {
        return AgentExecutionContext.create(this.agent, this.outer == null ? null : this.outer.createCopy());
    }

    public SimulationAgent getSimulation() {
        if (this.agent == null) {
            return null;
        }
        return this.agent.getSimulation();
    }
}

