/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime;

import gama.core.common.interfaces.IGui;
import gama.core.common.interfaces.IStepable;
import gama.core.common.util.RandomUtils;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationClock;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulationFactory;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.AgentExecutionContext;
import gama.core.runtime.ExecutionContext;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.GAMA;
import gama.core.runtime.GraphicsScope;
import gama.core.runtime.IExecutionContext;
import gama.core.runtime.IScope;
import gama.core.runtime.benchmark.StopWatch;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.IList;
import gama.dev.COUNTER;
import gama.dev.DEBUG;
import gama.gaml.compilation.ISymbol;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.IType;
import gama.gaml.types.ITypesManager;
import gama.gaml.types.Types;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;

public class ExecutionScope
implements IScope {
    private static final String ATTRIBUTES = "%_attributes_%";
    private final String scopeName;
    protected IExecutionContext executionContext;
    protected AgentExecutionContext agentContext;
    protected final SpecialContext additionalContext = new SpecialContext();
    private volatile boolean _trace;
    private volatile boolean _in_try_mode;
    private volatile boolean _errors_disabled;
    private volatile FlowStatus flowStatus = FlowStatus.NORMAL;
    private final Object lock = new Object();

    public ExecutionScope(ITopLevelAgent iTopLevelAgent) {
        this(iTopLevelAgent, null);
    }

    public ExecutionScope(ITopLevelAgent iTopLevelAgent, String string) {
        this(iTopLevelAgent, string, null);
    }

    public ExecutionScope(ITopLevelAgent iTopLevelAgent, String string, IExecutionContext iExecutionContext) {
        this(iTopLevelAgent, string, iExecutionContext, null, null);
    }

    public ExecutionScope(ITopLevelAgent iTopLevelAgent, String string, IExecutionContext iExecutionContext, AgentExecutionContext agentExecutionContext, SpecialContext specialContext) {
        StringBuilder stringBuilder = new StringBuilder("Scope #").append(COUNTER.COUNT());
        this.setRoot(iTopLevelAgent);
        if (iTopLevelAgent != null) {
            stringBuilder.append(" of ").append(iTopLevelAgent.stringValue(iTopLevelAgent.getScope()));
        }
        stringBuilder.append((String)(string == null || string.isEmpty() ? "" : " (" + string + ")"));
        this.scopeName = stringBuilder.toString();
        this.setExecutionContext(iExecutionContext == null ? ExecutionContext.create(this, null) : iExecutionContext.createCopy(null));
        this.agentContext = agentExecutionContext == null ? AgentExecutionContext.create(iTopLevelAgent, null) : agentExecutionContext;
        this.additionalContext.copyFrom(specialContext);
    }

    public AgentExecutionContext createChildContext(IAgent iAgent) {
        return AgentExecutionContext.create(iAgent, this.agentContext);
    }

    @Override
    public void clear() {
        if (this.executionContext != null) {
            this.executionContext.dispose();
        }
        this.setExecutionContext(null);
        if (this.agentContext != null) {
            this.agentContext.dispose();
        }
        this.agentContext = null;
        this.additionalContext.clear();
        this.setFlowStatus(FlowStatus.DISPOSE);
    }

    @Override
    public void disableErrorReporting() {
        this._errors_disabled = true;
    }

    @Override
    public void enableErrorReporting() {
        this._errors_disabled = false;
    }

    @Override
    public boolean reportErrors() {
        return !this._errors_disabled;
    }

    @Override
    public void enableTryMode() {
        this._in_try_mode = true;
    }

    @Override
    public void disableTryMode() {
        this._in_try_mode = false;
    }

    @Override
    public boolean isInTryMode() {
        return this._in_try_mode;
    }

    @Override
    public void setTrace(boolean bl) {
        this._trace = bl;
    }

    @Override
    public final boolean interrupted() {
        return INTERRUPTING_STATUSES.contains((Object)this.flowStatus);
    }

    @Override
    public final boolean isClosed() {
        return this.flowStatus == FlowStatus.DISPOSE;
    }

    @Override
    public boolean isOnUserHold() {
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return false;
        }
        return iTopLevelAgent.isOnUserHold();
    }

    @Override
    public void setOnUserHold(boolean bl) {
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return;
        }
        iTopLevelAgent.setOnUserHold(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean push(IAgent iAgent) {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                IAgent iAgent2;
                IAgent iAgent3 = iAgent2 = this.agentContext == null ? null : this.agentContext.getAgent();
                if (iAgent2 == null) {
                    if (iAgent instanceof ITopLevelAgent) {
                        ITopLevelAgent iTopLevelAgent = (ITopLevelAgent)iAgent;
                        this.setRoot(iTopLevelAgent);
                    }
                    this.agentContext = null;
                    break block6;
                }
                if (iAgent2 != iAgent) break block6;
                return false;
            }
            this.agentContext = this.createChildContext(iAgent);
            return true;
        }
    }

    protected void setRoot(ITopLevelAgent iTopLevelAgent) {
        this.additionalContext.rootAgent = iTopLevelAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pop(IAgent iAgent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.agentContext == null) {
                DEBUG.OUT((Object)"Agents stack is empty");
                return;
            }
            AgentExecutionContext agentExecutionContext = this.agentContext;
            this.agentContext = this.agentContext.getOuterContext();
            agentExecutionContext.dispose();
            this.getAndClearDeathStatus();
        }
    }

    @Override
    public void push(ISymbol iSymbol) {
        this.setCurrentSymbol(iSymbol);
        if (this.executionContext != null) {
            this.setExecutionContext(this.executionContext.createChildContext(iSymbol));
        } else {
            this.setExecutionContext(ExecutionContext.create(this, iSymbol));
        }
    }

    @Override
    public void setCurrentSymbol(ISymbol iSymbol) {
        if (this.executionContext != null) {
            this.executionContext.setCurrentSymbol(iSymbol);
        }
        if (iSymbol != null && this._trace) {
            this.writeTrace();
        }
    }

    private void writeTrace() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.executionContext.depth()) {
            stringBuilder.append("\t");
            ++n;
        }
        stringBuilder.append(this.getCurrentSymbol().getTrace(this));
        this.getGui().getConsole().informConsole(stringBuilder.toString(), this.getRoot());
    }

    @Override
    public void pop(ISymbol iSymbol) {
        if (this.executionContext != null) {
            IExecutionContext iExecutionContext = this.executionContext;
            this.setExecutionContext(this.executionContext.getOuterContext());
            iExecutionContext.dispose();
        }
    }

    @Override
    public ISymbol getCurrentSymbol() {
        return this.executionContext == null ? null : this.executionContext.getCurrentSymbol();
    }

    @Override
    public ExecutionResult execute(IExecutable iExecutable, IAgent iAgent, boolean bl, Arguments arguments) {
        if (iExecutable == null || iAgent == null || this.interrupted() || iAgent.dead()) {
            return ExecutionResult.FAILED;
        }
        IAgent iAgent2 = this.getAgent();
        boolean bl2 = this.push(iAgent);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            StopWatch stopWatch = GAMA.benchmark(this, iExecutable);
            try {
                if (arguments != null) {
                    arguments.setCaller(iAgent2);
                }
                iExecutable.setRuntimeArgs(this, arguments);
                if (iExecutable instanceof RemoteSequence && "create".equals(((RemoteSequence)iExecutable).getDescription().getKeyword()) && iAgent2.equals(iAgent)) {
                    iExecutable.setMyself(this.agentContext.outer.getAgent());
                } else {
                    iExecutable.setMyself(iAgent2);
                }
                ExecutionResult executionResult = ExecutionResult.withValue(iExecutable.executeOn(bl ? iAgent.getScope() : this));
                if (stopWatch != null) {
                    stopWatch.close();
                }
                return executionResult;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (stopWatch != null) {
                            stopWatch.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (GamaRuntimeException gamaRuntimeException) {
                    GAMA.reportAndThrowIfNeeded(this, gamaRuntimeException, true);
                    ExecutionResult executionResult = ExecutionResult.FAILED;
                    return executionResult;
                }
            }
        }
        finally {
            if (arguments != null) {
                arguments.setCaller(null);
            }
            if (bl2) {
                this.pop(iAgent);
            }
        }
    }

    @Override
    public void stackArguments(Arguments arguments) {
        if (arguments == null) {
            return;
        }
        boolean bl = false;
        IAgent iAgent = arguments.getCaller();
        if (iAgent != null) {
            bl = this.push(iAgent);
        }
        try {
            arguments.forEachFacet((string, iExpressionDescription) -> {
                IExpression iExpression = iExpressionDescription.getExpression();
                if (iExpression != null) {
                    this.addVarWithValue((String)string, iExpression.value(this));
                }
                return true;
            });
        }
        finally {
            if (bl) {
                this.pop(iAgent);
            }
        }
    }

    @Override
    public ExecutionResult step(IStepable iStepable) {
        if (iStepable == null || this.interrupted()) {
            return ExecutionResult.FAILED;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StopWatch stopWatch = GAMA.benchmark(this, iStepable);){
                return ExecutionResult.withValue(iStepable.step(this));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                GamaExecutorService.EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), throwable);
                return ExecutionResult.FAILED;
            }
            GamaRuntimeException gamaRuntimeException = GamaRuntimeException.create(throwable, this);
            GAMA.reportAndThrowIfNeeded(this, gamaRuntimeException, true);
            return ExecutionResult.FAILED;
        }
    }

    @Override
    public ExecutionResult init(IStepable iStepable) {
        if (iStepable == null || this.interrupted()) {
            return ExecutionResult.FAILED;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StopWatch stopWatch = GAMA.benchmark(this, iStepable);){
                return ExecutionResult.withValue(iStepable.init(this));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                GamaExecutorService.EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), throwable);
                return ExecutionResult.FAILED;
            }
            GamaRuntimeException gamaRuntimeException = GamaRuntimeException.create(throwable, this);
            GAMA.reportAndThrowIfNeeded(this, gamaRuntimeException, true);
            return ExecutionResult.FAILED;
        }
    }

    @Override
    public ExecutionResult step(IAgent iAgent) {
        if (iAgent == null || iAgent.dead() || this.interrupted()) {
            return ExecutionResult.FAILED;
        }
        boolean bl = this.push(iAgent);
        try {
            Throwable throwable = null;
            GamaRuntimeException gamaRuntimeException = null;
            StopWatch stopWatch = GAMA.benchmark(this, iAgent);
            try {
                ExecutionResult executionResult = ExecutionResult.withValue(iAgent.step(this));
                if (stopWatch != null) {
                    stopWatch.close();
                }
                return executionResult;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (stopWatch != null) {
                            stopWatch.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable4 instanceof OutOfMemoryError) {
                        GamaExecutorService.EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), throwable4);
                        ExecutionResult executionResult = ExecutionResult.FAILED;
                        return executionResult;
                    }
                    gamaRuntimeException = GamaRuntimeException.create(throwable4, this);
                    GAMA.reportAndThrowIfNeeded(this, gamaRuntimeException, true);
                    ExecutionResult executionResult = ExecutionResult.FAILED;
                    return executionResult;
                }
            }
        }
        finally {
            if (bl) {
                this.pop(iAgent);
            }
        }
    }

    @Override
    public ExecutionResult init(IAgent iAgent) {
        if (iAgent == null || iAgent.dead() || this.interrupted()) {
            return ExecutionResult.FAILED;
        }
        boolean bl = this.push(iAgent);
        try {
            Throwable throwable = null;
            GamaRuntimeException gamaRuntimeException = null;
            StopWatch stopWatch = GAMA.benchmark(this, iAgent);
            try {
                ExecutionResult executionResult = ExecutionResult.withValue(iAgent.init(this));
                if (stopWatch != null) {
                    stopWatch.close();
                }
                return executionResult;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (stopWatch != null) {
                            stopWatch.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable4 instanceof OutOfMemoryError) {
                        GamaExecutorService.EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), throwable4);
                        ExecutionResult executionResult = ExecutionResult.FAILED;
                        return executionResult;
                    }
                    gamaRuntimeException = GamaRuntimeException.create(throwable4, this);
                    GAMA.reportAndThrowIfNeeded(this, gamaRuntimeException, true);
                    ExecutionResult executionResult = ExecutionResult.FAILED;
                    return executionResult;
                }
            }
        }
        finally {
            if (bl) {
                this.pop(iAgent);
            }
        }
    }

    @Override
    public ExecutionResult evaluate(IExpression iExpression, IAgent iAgent) throws GamaRuntimeException {
        if (iAgent == null || iAgent.dead() || this.interrupted()) {
            return ExecutionResult.FAILED;
        }
        boolean bl = this.push(iAgent);
        try {
            Throwable throwable = null;
            GamaRuntimeException gamaRuntimeException = null;
            StopWatch stopWatch = GAMA.benchmark(this, iAgent);
            try {
                ExecutionResult executionResult = ExecutionResult.withValue(iExpression.value(this));
                if (stopWatch != null) {
                    stopWatch.close();
                }
                return executionResult;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (stopWatch != null) {
                            stopWatch.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable4 instanceof OutOfMemoryError) {
                        GamaExecutorService.EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), throwable4);
                        ExecutionResult executionResult = ExecutionResult.FAILED;
                        return executionResult;
                    }
                    gamaRuntimeException = GamaRuntimeException.create(throwable4, this);
                    GAMA.reportAndThrowIfNeeded(this, gamaRuntimeException, true);
                    ExecutionResult executionResult = ExecutionResult.FAILED;
                    return executionResult;
                }
            }
        }
        finally {
            if (bl) {
                this.pop(iAgent);
            }
        }
    }

    @Override
    public Object getVarValue(String string) {
        if (this.executionContext != null) {
            return this.executionContext.getTempVar(string);
        }
        return null;
    }

    @Override
    public void setVarValue(String string, Object object) {
        if (this.executionContext != null) {
            this.executionContext.setTempVar(string, object);
        }
    }

    @Override
    public void setVarValue(String string, Object object, boolean bl) {
        if (this.executionContext != null) {
            if (bl) {
                this.executionContext.putLocalVar(string, object);
            } else {
                this.executionContext.setTempVar(string, object);
            }
        }
    }

    @Override
    public void saveAllVarValuesIn(Map<String, Object> map) {
        if (this.executionContext != null && map != null) {
            map.putAll(this.executionContext.getLocalVars());
        }
    }

    @Override
    public void removeAllVars() {
        if (this.executionContext != null) {
            this.executionContext.clearLocalVars();
        }
    }

    @Override
    public void addVarWithValue(String string, Object object) {
        if (this.executionContext != null) {
            this.executionContext.putLocalVar(string, object);
        }
    }

    @Override
    public void setEach(Object object) {
        this.additionalContext.each = object;
    }

    @Override
    public Object getEach() {
        return this.additionalContext.each;
    }

    @Override
    public Object getArg(String string, int n) throws GamaRuntimeException {
        if (this.executionContext != null) {
            return Types.get(n).cast(this, this.executionContext.getLocalVar(string), null, false);
        }
        return null;
    }

    @Override
    public final Integer getIntArg(String string) throws GamaRuntimeException {
        return (Integer)this.getArg(string, 1);
    }

    @Override
    public final Double getFloatArg(String string) throws GamaRuntimeException {
        return (Double)this.getArg(string, 2);
    }

    public final IList getListArg(String string) throws GamaRuntimeException {
        return (IList)this.getArg(string, 5);
    }

    @Override
    public final Boolean getBoolArg(String string) throws GamaRuntimeException {
        return (Boolean)this.getArg(string, 3);
    }

    @Override
    public final String getStringArg(String string) throws GamaRuntimeException {
        return (String)this.getArg(string, 4);
    }

    @Override
    public boolean hasArg(String string) {
        if (this.executionContext != null) {
            return this.executionContext.hasLocalVar(string);
        }
        return false;
    }

    @Override
    public Object getAgentVarValue(IAgent iAgent, String string) throws GamaRuntimeException {
        if (iAgent == null || iAgent.dead() || this.interrupted()) {
            return null;
        }
        boolean bl = this.push(iAgent);
        try {
            Object object = iAgent.getDirectVarValue(this, string);
            return object;
        }
        finally {
            if (bl) {
                this.pop(iAgent);
            }
        }
    }

    @Override
    public void setAgentVarValue(IAgent iAgent, String string, Object object) {
        if (iAgent == null || iAgent.dead() || this.interrupted()) {
            return;
        }
        boolean bl = this.push(iAgent);
        try {
            iAgent.setDirectVarValue(this, string, object);
        }
        finally {
            if (bl) {
                this.pop(iAgent);
            }
        }
    }

    @Override
    public ExecutionResult update(IAgent iAgent) {
        if (iAgent == null || iAgent.dead() || this.interrupted()) {
            return ExecutionResult.FAILED;
        }
        boolean bl = this.push(iAgent);
        try {
            iAgent.getPopulation().updateVariables(this, iAgent);
            ExecutionResult executionResult = ExecutionResult.PASSED;
            return executionResult;
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            GAMA.reportAndThrowIfNeeded(this, gamaRuntimeException, true);
            ExecutionResult executionResult = ExecutionResult.FAILED;
            return executionResult;
        }
        finally {
            if (bl) {
                this.pop(iAgent);
            }
        }
    }

    @Override
    public Object getGlobalVarValue(String string) throws GamaRuntimeException {
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return null;
        }
        return iTopLevelAgent.getDirectVarValue(this, string);
    }

    @Override
    public boolean hasAccessToGlobalVar(String string) {
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return false;
        }
        return iTopLevelAgent.hasAttribute(string);
    }

    @Override
    public void setGlobalVarValue(String string, Object object) throws GamaRuntimeException {
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return;
        }
        iTopLevelAgent.setDirectVarValue(this, string, object);
    }

    @Override
    public String getName() {
        return this.scopeName;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ITopology getTopology() {
        ITopology iTopology = this.additionalContext.topology;
        if (iTopology != null) {
            return iTopology;
        }
        IAgent iAgent = this.getAgent();
        return iAgent == null ? null : iAgent.getTopology();
    }

    @Override
    public ITopology setTopology(ITopology iTopology) {
        ITopology iTopology2 = this.getTopology();
        this.additionalContext.topology = iTopology;
        return iTopology2;
    }

    @Override
    public IAgent getAgent() {
        if (this.agentContext == null) {
            return null;
        }
        return this.agentContext.getAgent();
    }

    @Override
    public SimulationAgent getSimulation() {
        if (this.agentContext != null) {
            return this.agentContext.getSimulation();
        }
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return null;
        }
        return iTopLevelAgent.getSimulation();
    }

    @Override
    public IExperimentAgent getExperiment() {
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return null;
        }
        return iTopLevelAgent.getExperiment();
    }

    @Override
    public IPopulationFactory getPopulationFactory() {
        IExperimentAgent iExperimentAgent = this.getExperiment();
        if (iExperimentAgent == null) {
            return null;
        }
        return iExperimentAgent.getPopulationFactory();
    }

    @Override
    public IModel getModel() {
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return null;
        }
        return iTopLevelAgent.getModel();
    }

    @Override
    public IType getType(String string) {
        if (this.additionalContext.types == null) {
            this.additionalContext.types = this.getExperiment().getSpecies().getModel().getDescription().getTypesManager();
        }
        return this.additionalContext.types.get(string);
    }

    @Override
    public SimulationClock getClock() {
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return null;
        }
        return iTopLevelAgent.getClock();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IAgent[] getAgentsStack() {
        var1_1 = null;
        var2_3 = null;
        try {
            var3_5 = Collector.getOrderedSet();
            try {
                var4_6 = this.agentContext;
                if (var4_6 != null) ** GOTO lbl-1000
                v0 = new IAgent[]{};
                if (var3_5 == null) return v0;
            }
            catch (Throwable var1_2) {
                if (var3_5 == null) throw var1_2;
                var3_5.close();
                throw var1_2;
            }
lbl-1000:
            // 1 sources

            {
                while (true) {
                    if (var4_6 == null) {
                        v1 = (IAgent[])var3_5.items().stream().toArray((IntFunction<IAgent[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$1(int ), (I)[Lgama/core/metamodel/agent/IAgent;)());
                        break;
                    }
                    var3_5.add(var4_6.getAgent());
                    var4_6 = var4_6.getOuterContext();
                }
            }
            if (var3_5 == null) return v1;
            var3_5.close();
            return v1;
            var3_5.close();
            return v0;
        }
        catch (Throwable var2_4) {
            if (var1_1 == null) {
                var1_1 = var2_4;
                throw var1_1;
            }
            if (var1_1 == var2_4) throw var1_1;
            var1_1.addSuppressed(var2_4);
            throw var1_1;
        }
    }

    @Override
    public void pushReadAttributes(Map map) {
        this.addVarWithValue(ATTRIBUTES, map);
    }

    @Override
    public Map popReadAttributes() {
        if (this.executionContext != null) {
            Map map = (Map)this.getVarValue(ATTRIBUTES);
            this.executionContext.removeLocalVar(ATTRIBUTES);
            return map;
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public Map peekReadAttributes() {
        return (Map)this.getVarValue(ATTRIBUTES);
    }

    @Override
    public IGui getGui() {
        if (this.additionalContext.gui != null) {
            return this.additionalContext.gui;
        }
        IExperimentAgent iExperimentAgent = this.getExperiment();
        this.additionalContext.gui = iExperimentAgent == null ? GAMA.getGui() : (iExperimentAgent.getSpecies().isHeadless() ? GAMA.getHeadlessGui() : GAMA.getRegularGui());
        return this.additionalContext.gui;
    }

    @Override
    public ITopLevelAgent getRoot() {
        return this.additionalContext.rootAgent;
    }

    @Override
    public boolean isPaused() {
        IExperimentController iExperimentController;
        IExperimentPlan iExperimentPlan;
        IExperimentAgent iExperimentAgent = this.getExperiment();
        if (iExperimentAgent != null && (iExperimentPlan = iExperimentAgent.getSpecies()) != null && (iExperimentController = iExperimentPlan.getController()) != null) {
            return iExperimentController.isPaused() || this.isOnUserHold();
        }
        return this.isOnUserHold();
    }

    @Override
    public RandomUtils getRandom() {
        ITopLevelAgent iTopLevelAgent = this.getRoot();
        if (iTopLevelAgent == null) {
            return new RandomUtils();
        }
        return iTopLevelAgent.getRandomGenerator();
    }

    @Override
    public IScope copy(String string) {
        ExecutionScope executionScope = new ExecutionScope(this.getRoot(), string);
        executionScope.setExecutionContext(this.executionContext == null ? null : this.executionContext.createCopy(null));
        executionScope.agentContext = this.agentContext == null ? null : this.agentContext.createCopy();
        executionScope.additionalContext.copyFrom(this.additionalContext);
        return executionScope;
    }

    @Override
    public IScope.IGraphicsScope copyForGraphics(String string) {
        GraphicsScope graphicsScope = new GraphicsScope(this, string);
        graphicsScope.setExecutionContext(this.executionContext == null ? null : this.executionContext.createCopy(null));
        graphicsScope.agentContext = this.agentContext == null ? null : this.agentContext.createCopy();
        graphicsScope.additionalContext.copyFrom(this.additionalContext);
        return graphicsScope;
    }

    @Override
    public IExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public void setCurrentError(GamaRuntimeException gamaRuntimeException) {
        this.additionalContext.currentError = gamaRuntimeException;
    }

    @Override
    public GamaRuntimeException getCurrentError() {
        return this.additionalContext.currentError;
    }

    @Override
    public void setFlowStatus(FlowStatus flowStatus) {
        this.flowStatus = flowStatus;
    }

    @Override
    public FlowStatus getAndClearFlowStatus(FlowStatus flowStatus) {
        try {
            FlowStatus flowStatus2 = this.flowStatus;
            return flowStatus2;
        }
        finally {
            if (this.flowStatus == flowStatus) {
                this.flowStatus = FlowStatus.NORMAL;
            }
        }
    }

    @Override
    public Object getData(String string) {
        return this.additionalContext.getData(string);
    }

    @Override
    public void setData(String string, Object object) {
        this.additionalContext.setData(string, object);
    }

    protected void setExecutionContext(IExecutionContext iExecutionContext) {
        this.executionContext = iExecutionContext;
    }

    private static /* synthetic */ IAgent[] lambda$1(int n) {
        return new IAgent[n];
    }

    static class SpecialContext {
        Map<String, Object> data;
        Object each;
        public ITopology topology;
        ITopLevelAgent rootAgent;
        IGui gui;
        ITypesManager types;
        GamaRuntimeException currentError;

        SpecialContext() {
        }

        void clear() {
            this.each = null;
            this.data = null;
            this.topology = null;
            this.rootAgent = null;
            this.gui = null;
            this.types = null;
            this.currentError = null;
        }

        public void copyFrom(SpecialContext specialContext) {
            if (specialContext == null) {
                return;
            }
            this.each = specialContext.each;
            this.data = specialContext.data;
            this.topology = specialContext.topology;
            this.rootAgent = specialContext.rootAgent;
            this.gui = specialContext.gui;
            this.types = specialContext.types;
            this.currentError = specialContext.currentError;
        }

        Object getData(String string) {
            return this.data == null ? null : this.data.get(string);
        }

        void setData(String string, Object object) {
            if (object == null) {
                if (this.data == null) {
                    return;
                }
                this.data.remove(string);
            }
            if (this.data == null) {
                this.data = new HashMap<String, Object>();
            }
            this.data.put(string, object);
        }
    }
}

