/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.core.common.geometry.Envelope3D;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaFile;
import gama.core.util.file.IGamaFile;
import gama.gaml.operators.Files;
import gama.gaml.statements.Facets;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.File;

public class GamaFolderFile
extends GamaFile<IList<String>, String> {
    public GamaFolderFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    public GamaFolderFile(IScope iScope, String string, boolean bl) throws GamaRuntimeException {
        super(iScope, string, bl);
    }

    @Override
    protected void checkValidity(IScope iScope) throws GamaRuntimeException {
        File file2 = this.getFile(iScope);
        if (file2 == null || !file2.exists()) {
            throw GamaRuntimeException.error("The folder " + this.getFile(iScope).getAbsolutePath() + " does not exist. Please use 'new_folder' instead", iScope);
        }
        if (!this.getFile(iScope).isDirectory()) {
            throw GamaRuntimeException.error(this.getFile(iScope).getAbsolutePath() + "is not a folder", iScope);
        }
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "folder('" + this.getPath(null) + "')";
    }

    @Override
    public IContainerType<?> getGamlType() {
        return Types.FILE.of(Types.INT, Types.STRING);
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.create(Types.STRING);
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        String[] stringArray = this.getFile(iScope).list();
        IList<String> iList = stringArray == null ? GamaListFactory.EMPTY_LIST : GamaListFactory.createWithoutCasting((IType)Types.STRING, stringArray);
        this.setBuffer(iList);
    }

    @Override
    protected void flushBuffer(IScope iScope, Facets facets2) throws GamaRuntimeException {
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        Object Container = this.getContents(iScope);
        Envelope3D envelope3D = null;
        for (String string : Container.iterable(iScope)) {
            IGamaFile iGamaFile = Files.from(iScope, string);
            Envelope3D envelope3D2 = iGamaFile.computeEnvelope(iScope);
            if (envelope3D == null) {
                envelope3D = envelope3D2;
                continue;
            }
            envelope3D.expandToInclude(envelope3D2);
        }
        return envelope3D;
    }
}

