/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.variables;

import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.ICollector;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.expressions.variables.VariableExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.IType;

public class GlobalVariableExpression
extends VariableExpression
implements IVarExpression.Agent {
    public static IExpression create(String string, IType<?> iType, boolean bl, IDescription iDescription) {
        VariableDescription variableDescription = ((SpeciesDescription)iDescription).getAttribute(string);
        IExpression iExpression = variableDescription.getFacetExpr("init");
        if (iExpression != null && bl && !variableDescription.isFunction() && GamaPreferences.Experimental.CONSTANT_OPTIMIZATION.getValue().booleanValue() && iExpression.isConst()) {
            return GAML.getExpressionFactory().createConst(iExpression.getConstValue(), iType, string);
        }
        return new GlobalVariableExpression(string, iType, bl, iDescription);
    }

    protected GlobalVariableExpression(String string, IType<?> iType, boolean bl, IDescription iDescription) {
        super(string, iType, bl, iDescription);
    }

    @Override
    public boolean isConst() {
        if (this.type.isContainer()) {
            return false;
        }
        VariableDescription variableDescription = this.getDefinitionDescription().getSpeciesContext().getAttribute(this.name);
        if (variableDescription == null || variableDescription.isFunction()) {
            return false;
        }
        return this.isNotModifiable;
    }

    @Override
    public IExpression getOwner() {
        return this.getDefinitionDescription().getModelDescription().getVarExpr("world", false);
    }

    @Override
    public Object _value(IScope iScope) throws GamaRuntimeException {
        IScope iScope2;
        ITopLevelAgent iTopLevelAgent;
        IScope iScope3;
        String string = this.getName();
        if (iScope.hasAccessToGlobalVar(string)) {
            return iScope.getGlobalVarValue(string);
        }
        IAgent iAgent = iScope.getAgent();
        if (iAgent != null && (iScope3 = iAgent.getScope()) != null && (iTopLevelAgent = iScope3.getRoot()) != null && (iScope2 = iTopLevelAgent.getScope()) != null) {
            return iScope2.getGlobalVarValue(this.getName());
        }
        return null;
    }

    @Override
    public void setVal(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
        if (this.isNotModifiable) {
            return;
        }
        if (iScope.hasAccessToGlobalVar(this.name)) {
            iScope.setGlobalVarValue(this.name, object);
        } else {
            IAgent iAgent = iScope.getAgent();
            if (iAgent != null) {
                iAgent.getScope().getRoot().getScope().setGlobalVarValue(this.name, object);
            }
        }
    }

    @Override
    public String getTitle() {
        VariableDescription variableDescription;
        IDescription iDescription = this.getDefinitionDescription();
        boolean bl = iDescription != null ? (variableDescription = iDescription.getSpeciesContext().getAttribute(this.getName())) != null && variableDescription.isParameter() : false;
        return "global " + (bl ? "parameter" : (this.isNotModifiable ? "constant" : "attribute")) + " " + this.getName() + " of type " + this.getGamlType().getName();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        IDescription iDescription = this.getDefinitionDescription();
        if (iDescription == null) {
            return new IGamlDescription.ConstantDoc("Type " + this.type.getTitle());
        }
        IGamlDescription.RegularDoc regularDoc = new IGamlDescription.RegularDoc(new StringBuilder());
        VariableDescription variableDescription = iDescription.getSpeciesContext().getAttribute(this.name);
        regularDoc.append("Type ").append(this.type.getTitle()).append("<br/>");
        String string = null;
        if (variableDescription != null) {
            string = variableDescription.getBuiltInDoc();
        }
        if (string != null) {
            regularDoc.append(string).append("<br/>");
        }
        regularDoc.append(iDescription.isBuiltIn() ? "Built in " : (string == null ? "Defined in " : "Redefined in ")).append(iDescription.getTitle());
        return regularDoc;
    }

    @Override
    public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        SpeciesDescription speciesDescription2 = this.getDefinitionDescription().getSpeciesContext();
        if (speciesDescription.equals(speciesDescription2)) {
            iCollector2.add(speciesDescription2.getAttribute(this.getName()));
        }
    }

    @Override
    public IExpression resolveAgainst(IScope iScope) {
        return this;
    }
}

