/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.operators.Cast;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.precision.EnhancedPrecisionOp;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.util.AssertionFailedException;

public class SpatialOperators {
    @GamlAnnotations.operator(value={"inter", "intersection"}, category={"Spatial operators"})
    @GamlAnnotations.doc(value="A geometry resulting from the intersection between the two geometries", special_cases={"returns nil if one of the operands is nil"}, examples={@GamlAnnotations.example(value="square(10) inter circle(5)", equals="circle(5)")}, see={"union", "+", "-"})
    public static IShape inter(IScope iScope, IShape iShape, IShape iShape2) {
        Object object;
        if (iShape2 == null || iShape == null) {
            return null;
        }
        if (iShape2.isPoint() && iShape.covers(iShape2.getLocation())) {
            return iShape2.copy(iScope);
        }
        if (iShape.isPoint() && iShape2.covers(iShape.getLocation())) {
            return iShape.copy(iScope);
        }
        Geometry geometry = null;
        Geometry geometry2 = iShape.getInnerGeometry();
        Geometry geometry3 = iShape2.getInnerGeometry();
        try {
            geometry = geometry2.intersection(geometry3);
        }
        catch (Exception exception) {
            try {
                object = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
                geometry = GeometryPrecisionReducer.reducePointwise((Geometry)geometry2, (PrecisionModel)object).intersection(GeometryPrecisionReducer.reducePointwise((Geometry)geometry3, (PrecisionModel)object));
            }
            catch (Exception exception2) {
                try {
                    geometry = geometry2.buffer(0.01, 8, 2).intersection(geometry3.buffer(0.01, 8, 2));
                }
                catch (Exception exception3) {
                    return null;
                }
            }
        }
        if (geometry == null || geometry.isEmpty()) {
            return null;
        }
        object = GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
        ((GamaShape)object).losePredefinedProperty();
        return object;
    }

    @GamlAnnotations.operator(value={"+", "union"}, category={"Spatial operators"}, concept={"geometry", "spatial_computation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the right-operand is a point, a geometry or an agent, returns the geometry resulting from the union between both geometries", examples={@GamlAnnotations.example(value="geom1 + geom2", equals="a geometry corresponding to union between geom1 and geom2", isExecutable=false)})})
    public static IShape union(IScope iScope, IShape iShape, IShape iShape2) {
        Object object;
        Geometry geometry;
        if (iShape == null) {
            if (iShape2 == null) {
                return null;
            }
            return iShape2.copy(iScope);
        }
        if (iShape2 == null) {
            return iShape.copy(iScope);
        }
        Geometry geometry2 = iShape.getInnerGeometry();
        Geometry geometry3 = iShape2.getInnerGeometry();
        try {
            geometry = geometry2.union(geometry3);
        }
        catch (Exception exception) {
            try {
                object = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
                geometry = GeometryPrecisionReducer.reducePointwise((Geometry)geometry2, (PrecisionModel)object).intersection(GeometryPrecisionReducer.reducePointwise((Geometry)geometry3, (PrecisionModel)object));
            }
            catch (Exception exception2) {
                try {
                    geometry = SpatialTransformations.translated_by(iScope, iShape2.copy(iScope), new GamaPoint(0.01, 0.0)).getInnerGeometry().union(geometry2);
                }
                catch (Exception exception3) {
                    try {
                        geometry = geometry2.buffer(0.01, 0, 3).union(geometry3.buffer(0.01, 0, 3));
                    }
                    catch (Exception exception4) {
                        geometry = SpatialTransformations.rotated_by(iScope, iShape2.copy(iScope), 0.1).getInnerGeometry().union(geometry2);
                    }
                }
            }
        }
        if (geometry == null || geometry.isEmpty()) {
            return null;
        }
        object = GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
        ((GamaShape)object).losePredefinedProperty();
        return object;
    }

    @GamlAnnotations.operator(value={"union"}, expected_content_type={7, 13, 11}, category={"Spatial operators"}, concept={"geometry", "spatial_computation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the right-operand is a container of points, geometries or agents, returns the geometry resulting from the union all the geometries")}, examples={@GamlAnnotations.example(value="union([geom1, geom2, geom3])", equals="a geometry corresponding to union between geom1, geom2 and geom3", isExecutable=false)})
    public static IShape union(IScope iScope, IContainer<?, IShape> iContainer) {
        try {
            return Cast.asGeometry(iScope, iContainer, false);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            return null;
        }
    }

    @GamlAnnotations.operator(value={"-"}, category={"Spatial operators"}, concept={"geometry", "spatial_computation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if both operands are a point, a geometry or an agent, returns the geometry resulting from the difference between both geometries", examples={@GamlAnnotations.example(value="geom1 - geom2", equals="a geometry corresponding to difference between geom1 and geom2", isExecutable=false)})})
    public static IShape minus(IScope iScope, IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null || iShape.getInnerGeometry() == null || iShape2.getInnerGeometry() == null) {
            return iShape;
        }
        Geometry geometry = SpatialOperators.difference(iShape.getInnerGeometry(), iShape2.getInnerGeometry());
        if (geometry != null && !geometry.isEmpty()) {
            GamaShape gamaShape = GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
            gamaShape.losePredefinedProperty();
            return gamaShape;
        }
        return null;
    }

    @GamlAnnotations.operator(value={"-"}, category={"Spatial operators"}, concept={"geometry", "spatial_computation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the right-operand is a list of points, geometries or agents, returns the geometry resulting from the difference between the left-geometry and all of the right-geometries", examples={@GamlAnnotations.example(value="rectangle(10,10) - [circle(2), square(2)]", equals="rectangle(10,10) - (circle(2) + square(2))")})})
    public static IShape minus(IScope iScope, IShape iShape, IContainer<?, IShape> iContainer) {
        IShape iShape22;
        if (iShape == null || iContainer == null || iShape.getInnerGeometry() == null || iContainer.isEmpty(iScope)) {
            return iShape;
        }
        Geometry geometry = GeometryUtils.GEOMETRY_FACTORY.createGeometry(iShape.getInnerGeometry());
        for (IShape iShape22 : iContainer.iterable(iScope)) {
            if (iShape22 == null || iShape22.getInnerGeometry() == null || (geometry = SpatialOperators.difference(geometry, iShape22.getInnerGeometry())) != null && !geometry.isEmpty()) continue;
            return null;
        }
        if (geometry == null || geometry.isEmpty()) {
            return null;
        }
        iShape22 = GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
        ((GamaShape)iShape22).losePredefinedProperty();
        return iShape22;
    }

    private static Geometry difference(Geometry geometry, Geometry geometry2) {
        Geometry geometry3 = geometry;
        if (geometry2 instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry2;
            int n = geometryCollection.getNumGeometries();
            int n2 = 0;
            while (n2 < n) {
                if ((geometry3 = SpatialOperators.difference(geometry3, geometryCollection.getGeometryN(n2))) == null || geometry3.isEmpty()) {
                    return null;
                }
                ++n2;
            }
            return geometry3;
        }
        try {
            return geometry3.difference(geometry2);
        }
        catch (TopologyException | AssertionFailedException throwable) {
            try {
                PrecisionModel precisionModel = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
                return GeometryPrecisionReducer.reducePointwise((Geometry)geometry3, (PrecisionModel)precisionModel).difference(GeometryPrecisionReducer.reducePointwise((Geometry)geometry2, (PrecisionModel)precisionModel));
            }
            catch (RuntimeException runtimeException) {
                try {
                    return geometry3.buffer(0.0, 10, 2).difference(geometry2.buffer(0.0, 10, 2));
                }
                catch (TopologyException topologyException) {
                    try {
                        PrecisionModel precisionModel = new PrecisionModel(100000.0);
                        return GeometryPrecisionReducer.reduce((Geometry)geometry3, (PrecisionModel)precisionModel).difference(GeometryPrecisionReducer.reduce((Geometry)geometry2, (PrecisionModel)precisionModel));
                    }
                    catch (RuntimeException runtimeException2) {
                        try {
                            return EnhancedPrecisionOp.difference((Geometry)geometry3, (Geometry)geometry2);
                        }
                        catch (RuntimeException runtimeException3) {
                            try {
                                return geometry3.difference(geometry2.buffer(Math.min(0.01, geometry2.getArea() / 1000.0), 10, 2));
                            }
                            catch (RuntimeException runtimeException4) {
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }

    @GamlAnnotations.operator(value={"add_point"}, category={"Spatial operators", "Points-related operators"}, concept={"point", "geometry", "spatial_computation"})
    @GamlAnnotations.doc(value="A new geometry resulting from the addition of the right point (coordinate) to the left-hand geometry. Note that adding a point to a line or polyline will always return a closed contour. Also note that the position at which the added point will appear in the geometry is not necessarily the last one, as points are always ordered in a clockwise fashion in geometries", examples={@GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20}]) add_point {20,10}", returnType="geometry", equals="polygon([{10,10},{10,20},{20,20},{20,10}])")})
    public static IShape add_point(IScope iScope, IShape iShape, GamaPoint gamaPoint) {
        Object object;
        if (gamaPoint == null || iShape == null) {
            return iShape;
        }
        GamaPoint gamaPoint2 = gamaPoint;
        Geometry geometry = iShape.getInnerGeometry();
        Geometry geometry2 = null;
        if (geometry instanceof Point) {
            object = new Coordinate[]{geometry.getCoordinate(), gamaPoint2};
            geometry2 = GeometryUtils.GEOMETRY_FACTORY.createLineString((Coordinate[])object);
        } else if (geometry instanceof MultiPoint) {
            object = new Coordinate[geometry.getNumPoints() + 1];
            object[((Coordinate[])object).length - 1] = gamaPoint;
            geometry2 = GeometryUtils.GEOMETRY_FACTORY.createMultiPointFromCoords((Coordinate[])object);
        } else if (geometry instanceof LineString) {
            geometry2 = SpatialOperators.createLineStringWithPoint(geometry, gamaPoint2);
        } else if (geometry instanceof MultiLineString) {
            object = null;
            double d = Double.MAX_VALUE;
            int n = -1;
            Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(gamaPoint2);
            int n2 = 0;
            while (n2 < geometry.getNumGeometries()) {
                Geometry geometry3 = geometry.getGeometryN(n2);
                double d2 = geometry3.distance((Geometry)point);
                if (d2 < d) {
                    d = d2;
                    object = geometry3;
                    n = n2;
                }
                ++n2;
            }
            LineString[] lineStringArray = new LineString[geometry.getNumGeometries()];
            int n3 = 0;
            while (n3 < geometry.getNumGeometries()) {
                lineStringArray[n3] = n3 != n ? (LineString)geometry.getGeometryN(n3) : (LineString)SpatialOperators.createLineStringWithPoint((Geometry)object, gamaPoint2);
                ++n3;
            }
            geometry2 = GeometryUtils.GEOMETRY_FACTORY.createMultiLineString(lineStringArray);
        } else if (geometry instanceof Polygon) {
            geometry2 = SpatialOperators.createPolygonWithPoint(geometry, gamaPoint2);
        } else if (geometry instanceof MultiPolygon) {
            object = null;
            double d = Double.MAX_VALUE;
            int n = -1;
            Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(gamaPoint2);
            int n4 = 0;
            while (n4 < geometry.getNumGeometries()) {
                Geometry geometry4 = geometry.getGeometryN(n4);
                double d3 = geometry4.distance((Geometry)point);
                if (d3 < d) {
                    d = d3;
                    object = geometry4;
                    n = n4;
                }
                ++n4;
            }
            Polygon[] polygonArray = new Polygon[geometry.getNumGeometries()];
            int n5 = 0;
            while (n5 < geometry.getNumGeometries()) {
                polygonArray[n5] = n5 != n ? (Polygon)geometry.getGeometryN(n5) : (Polygon)SpatialOperators.createPolygonWithPoint((Geometry)object, gamaPoint2);
                ++n5;
            }
            geometry2 = GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon(polygonArray);
        }
        if (geometry2 != null) {
            object = GamaShapeFactory.createFrom(geometry2).withAttributesOf(iShape);
            ((GamaShape)object).losePredefinedProperty();
            return object;
        }
        return iShape;
    }

    private static Geometry createPolygonWithPoint(Geometry geometry, Coordinate coordinate) {
        double d = Double.MAX_VALUE;
        Polygon polygon = null;
        double d2 = Double.MAX_VALUE;
        Polygon polygon2 = null;
        int n = ((Polygon)geometry).getExteriorRing().getCoordinates().length;
        int n2 = 0;
        while (n2 <= n) {
            Coordinate[] coordinateArray = new Coordinate[n + 1];
            int n3 = 0;
            while (n3 < n2) {
                coordinateArray[n3] = geometry.getCoordinates()[n3];
                ++n3;
            }
            coordinateArray[n2] = coordinate;
            n3 = n2 + 1;
            while (n3 < coordinateArray.length) {
                coordinateArray[n3] = geometry.getCoordinates()[n3 - 1];
                ++n3;
            }
            LinearRing[] linearRingArray = new LinearRing[((Polygon)geometry).getNumInteriorRing()];
            int n4 = 0;
            while (n4 < linearRingArray.length) {
                linearRingArray[n4] = ((Polygon)geometry).getInteriorRingN(n4);
                ++n4;
            }
            Polygon polygon3 = GeometryUtils.GEOMETRY_FACTORY.createPolygon(GeometryUtils.GEOMETRY_FACTORY.createLinearRing(coordinateArray), linearRingArray);
            if (polygon3.isValid()) {
                if (d > polygon3.getArea()) {
                    d = polygon3.getArea();
                    polygon = polygon3;
                }
            } else if (d2 > polygon3.getArea()) {
                d2 = polygon3.getArea();
                polygon2 = polygon3;
            }
            ++n2;
        }
        if (polygon != null) {
            return polygon;
        }
        return polygon2;
    }

    private static Geometry createLineStringWithPoint(Geometry geometry, Coordinate coordinate) {
        double d = Double.MAX_VALUE;
        LineString lineString = null;
        double d2 = Double.MAX_VALUE;
        LineString lineString2 = null;
        int n = 0;
        while (n <= geometry.getCoordinates().length) {
            Coordinate[] coordinateArray = new Coordinate[geometry.getCoordinates().length + 1];
            int n2 = 0;
            while (n2 < n) {
                coordinateArray[n2] = geometry.getCoordinates()[n2];
                ++n2;
            }
            coordinateArray[n] = coordinate;
            n2 = n + 1;
            while (n2 < coordinateArray.length) {
                coordinateArray[n2] = geometry.getCoordinates()[n2 - 1];
                ++n2;
            }
            LineString lineString3 = GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray);
            if (lineString3.isValid()) {
                if (d > lineString3.getLength()) {
                    d = lineString3.getLength();
                    lineString = lineString3;
                }
            } else if (d2 > lineString3.getLength()) {
                d2 = lineString3.getLength();
                lineString2 = lineString3;
            }
            ++n;
        }
        if (lineString != null) {
            return lineString;
        }
        return lineString2;
    }

    @GamlAnnotations.operator(value={"masked_by"}, category={"Spatial operators"}, concept={"geometry", "spatial_computation", "obstacle"})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="perception_geom masked_by obstacle_list", equals="the geometry representing the part of perception_geom visible from the agent position considering the list of obstacles obstacle_list.", isExecutable=false)})
    public static IShape masked_by(IScope iScope, IShape iShape2, IContainer<?, IShape> iContainer, Integer n) {
        int n2 = n == null ? 120 : n;
        IAgent iAgent = iScope.getAgent();
        ArrayList<IShape> arrayList = iContainer == null ? new ArrayList<IShape>() : iContainer.listValue(iScope, Types.GEOMETRY, false);
        GamaPoint gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        Geometry geometry = GeometryUtils.GEOMETRY_FACTORY.createGeometry(iShape2.getInnerGeometry());
        boolean bl = iShape2.isPoint();
        if (iContainer != null && !iContainer.isEmpty(iScope)) {
            Object object22;
            IValue iValue;
            PreparedGeometry preparedGeometry;
            GamaPoint gamaPoint222;
            Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(gamaPoint);
            Geometry geometry2 = point.buffer(0.01).getEnvelope();
            double d = 0.0;
            for (GamaPoint gamaPoint222 : iShape2.getPoints()) {
                double d2 = gamaPoint.euclidianDistanceTo(gamaPoint222);
                if (!(d2 > d)) continue;
                d = d2;
            }
            gamaPoint222 = point.buffer(d, n2 / 4);
            ArrayList arrayList2 = new ArrayList();
            int n3 = 1;
            while (n3 < gamaPoint222.getNumPoints()) {
                preparedGeometry = GamaListFactory.create((IType)Types.POINT, 4);
                preparedGeometry.add(gamaPoint);
                preparedGeometry.add(new GamaPoint(gamaPoint222.getCoordinates()[n3 - 1]));
                preparedGeometry.add(new GamaPoint(gamaPoint222.getCoordinates()[n3]));
                preparedGeometry.add(gamaPoint);
                iValue = SpatialOperators.inter(iScope, iShape2, SpatialCreation.polygon(iScope, preparedGeometry));
                if (iValue != null && (bl || !iValue.isPoint())) {
                    object22 = GamaShapeFactory.createFrom(GeometryUtils.geometryCollectionManagement(iValue.getInnerGeometry()));
                    arrayList2.add(object22);
                }
                ++n3;
            }
            IList<Object> iList = GamaListFactory.create();
            preparedGeometry = PreparedGeometryFactory.prepare((Geometry)geometry2);
            object22 = arrayList2.iterator();
            while (object22.hasNext()) {
                iValue = (IShape)object22.next();
                if (!SpatialOperators.intersection(iValue, arrayList)) {
                    iList.addValue(iScope, iValue);
                    continue;
                }
                IShape iShape3 = SpatialOperators.difference(iScope, iValue, arrayList, preparedGeometry);
                if (iShape3 == null || !bl && iShape3.isPoint()) continue;
                iList.addValue(iScope, iShape3);
            }
            iValue = GamaListFactory.create(Types.GEOMETRY);
            for (Object object22 : iList) {
                if (object22.getGeometries().size() > 1) {
                    for (IShape iShape4 : object22.getGeometries()) {
                        if (!iShape4.intersects(gamaPoint)) continue;
                        iValue.add(iShape4);
                    }
                    continue;
                }
                iValue.add(object22);
            }
            boolean bl2 = false;
            boolean bl3 = false;
            Iterator iterator = iValue.iterator();
            while (iterator.hasNext()) {
                IShape iShape3 = (IShape)iterator.next();
                bl3 = bl3 || iShape3.isLine();
                boolean bl4 = bl2 = bl2 || !iShape3.isPoint() && !iShape3.isLine();
            }
            boolean bl5 = bl2;
            boolean bl6 = bl3;
            iValue.removeIf(iShape -> (bl5 || bl6) && iShape.isPoint() && bl5 && iShape.isLine());
            if (iValue.isEmpty(iScope)) {
                return null;
            }
            IShape iShape4 = Cast.asGeometry(iScope, iValue, false);
            if (iShape4 == null || iShape4.getInnerGeometry() == null) {
                iValue.stream().forEach(iShape -> {
                    IShape iShape2 = SpatialTransformations.enlarged_by(iScope, iShape, 0.1);
                });
                iShape4 = Cast.asGeometry(iScope, iValue, false);
            }
            if (iShape4 == null || iShape4.getInnerGeometry() == null) {
                return null;
            }
            if (iShape4.getInnerGeometry() instanceof GeometryCollection) {
                iShape4 = SpatialTransformations.enlarged_by(iScope, iShape4, 0.1);
            }
            return iShape4;
        }
        return GamaShapeFactory.createFrom(geometry);
    }

    private static boolean intersection(IShape iShape, List<IShape> list) {
        if (iShape == null) {
            return false;
        }
        for (IShape iShape2 : list) {
            if (iShape2 == null || !iShape.intersects(iShape2)) continue;
            return true;
        }
        return false;
    }

    private static IShape difference(IScope iScope, IShape iShape, List<IShape> list, PreparedGeometry preparedGeometry) {
        if (iShape == null) {
            return null;
        }
        IShape iShape2 = GamaShapeFactory.createFrom(iShape);
        block0: for (IShape iShape3 : list) {
            if (iShape3 == null || !iShape.intersects(iShape3)) continue;
            if ((iShape2 = SpatialOperators.minus(iScope, iShape2, iShape3)) == null) {
                return null;
            }
            if (iShape2.getGeometries().size() > 1) {
                for (IShape iShape4 : iShape2.getGeometries()) {
                    if (preparedGeometry.disjoint(iShape4.getInnerGeometry())) continue;
                    iShape2 = iShape4;
                    continue block0;
                }
                continue;
            }
            if (!preparedGeometry.disjoint(iShape2.getInnerGeometry())) continue;
            return null;
        }
        return iShape2;
    }

    @GamlAnnotations.operator(value={"masked_by"}, category={"Spatial operators"}, concept={})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="perception_geom masked_by obstacle_list", equals="the geometry representing the part of perception_geom visible from the agent position considering the list of obstacles obstacle_list.", isExecutable=false)})
    public static IShape masked_by(IScope iScope, IShape iShape, IContainer<?, IShape> iContainer) {
        return SpatialOperators.masked_by(iScope, iShape, iContainer, null);
    }

    @GamlAnnotations.operator(value={"split_at"}, content_type=13, category={"Spatial operators"})
    @GamlAnnotations.doc(value="The two part of the left-operand lines split at the given right-operand point", usages={@GamlAnnotations.usage(value="if the left-operand is a point or a polygon, returns an empty list")}, examples={@GamlAnnotations.example(value="polyline([{1,2},{4,6}]) split_at {7,6}", equals="[polyline([{1.0,2.0},{7.0,6.0}]), polyline([{7.0,6.0},{4.0,6.0}])]")})
    public static IList<IShape> split_at(IShape iShape, GamaPoint gamaPoint) {
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        ArrayList<LineString> arrayList = null;
        if (iShape.getInnerGeometry() instanceof LineString) {
            Coordinate[] coordinateArray;
            Coordinate[] object = ((LineString)iShape.getInnerGeometry()).getCoordinates();
            var5_11 = GeometryUtils.GEOMETRY_FACTORY.createPoint(gamaPoint.getLocation());
            int n = object.length;
            int n2 = -1;
            double d = Double.MAX_VALUE;
            int n3 = 0;
            while (n3 < n - 1) {
                coordinateArray = object[n3];
                Coordinate coordinate = object[n3 + 1];
                Coordinate[] coordinateArray2 = new Coordinate[]{coordinateArray, coordinate};
                Coordinate[] coordinateArray3 = coordinateArray2;
                LineString lineString = GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray3);
                double d2 = lineString.distance((Geometry)var5_11);
                if (d2 < d) {
                    d = d2;
                    n2 = n3;
                }
                ++n3;
            }
            n3 = n2 + 2;
            coordinateArray = new Coordinate[n3];
            int n4 = 0;
            while (n4 <= n2) {
                coordinateArray[n4] = object[n4];
                ++n4;
            }
            coordinateArray[n2 + 1] = new GamaPoint(gamaPoint.getLocation());
            n3 = object.length - n2;
            Coordinate[] coordinateArray4 = new Coordinate[n3];
            coordinateArray4[0] = new GamaPoint(gamaPoint.getLocation());
            int n5 = 1;
            int n6 = n2 + 1;
            while (n6 < object.length) {
                coordinateArray4[n5] = object[n6];
                ++n5;
                ++n6;
            }
            ArrayList<LineString> arrayList2 = new ArrayList<LineString>();
            arrayList2.add(GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray));
            arrayList2.add(GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray4));
            arrayList = arrayList2;
        } else if (iShape.getInnerGeometry() instanceof MultiLineString) {
            Coordinate[] coordinateArray;
            Geometry geometry;
            Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(gamaPoint);
            var5_11 = (MultiLineString)iShape.getInnerGeometry();
            Geometry geometry2 = var5_11.getGeometryN(0);
            double d = geometry2.distance((Geometry)point);
            int n = 1;
            while (n < var5_11.getNumGeometries()) {
                geometry = var5_11.getGeometryN(n);
                double d3 = geometry.distance((Geometry)point);
                if (d3 <= d) {
                    geometry2 = geometry;
                    d = d3;
                }
                ++n;
            }
            Coordinate[] coordinateArray5 = ((LineString)geometry2).getCoordinates();
            geometry = GeometryUtils.GEOMETRY_FACTORY.createPoint(new GamaPoint(gamaPoint.getLocation()));
            int n7 = coordinateArray5.length;
            int n8 = -1;
            double d4 = Double.MAX_VALUE;
            int n9 = 0;
            while (n9 < n7 - 1) {
                coordinateArray = coordinateArray5[n9];
                Coordinate coordinate = coordinateArray5[n9 + 1];
                Coordinate[] coordinateArray6 = new Coordinate[]{coordinateArray, coordinate};
                Coordinate[] coordinateArray7 = coordinateArray6;
                LineString lineString = GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray7);
                double d5 = lineString.distance(geometry);
                if (d5 < d4) {
                    d4 = d5;
                    n8 = n9;
                }
                ++n9;
            }
            n9 = n8 + 2;
            coordinateArray = new Coordinate[n9];
            int n10 = 0;
            while (n10 <= n8) {
                coordinateArray[n10] = coordinateArray5[n10];
                ++n10;
            }
            coordinateArray[n8 + 1] = new GamaPoint(gamaPoint.getLocation());
            n9 = coordinateArray5.length - n8;
            Coordinate[] coordinateArray8 = new Coordinate[n9];
            coordinateArray8[0] = new GamaPoint(gamaPoint.getLocation());
            int n11 = 1;
            int n12 = n8 + 1;
            while (n12 < coordinateArray5.length) {
                coordinateArray8[n11] = coordinateArray5[n12];
                ++n11;
                ++n12;
            }
            ArrayList<LineString> arrayList3 = new ArrayList<LineString>();
            arrayList3.add(GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray));
            arrayList3.add(GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray8));
            arrayList = arrayList3;
        }
        if (arrayList != null) {
            for (Geometry geometry : arrayList) {
                iList.add(GamaShapeFactory.createFrom(geometry));
            }
        }
        for (IShape iShape2 : iList) {
            iShape2.copyAttributesOf(iShape);
        }
        return iList;
    }
}

