/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.util.Collector;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.statements.AbstractStatementSequenceWithArgs;
import gama.gaml.statements.Arguments;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.inside(kinds={0, 13, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="identifier of the action")}), @GamlAnnotations.facet(name="type", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="the action returned type")}, internal=true), @GamlAnnotations.facet(name="of", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="if the action returns a container, the type of its elements")}, internal=true), @GamlAnnotations.facet(name="index", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="if the action returns a map, the type of its keys")}, internal=true), @GamlAnnotations.facet(name="virtual", type={3}, optional=true, doc={@GamlAnnotations.doc(value="whether the action is virtual (defined without a set of instructions) (false by default)")})}, omissible="name")
@GamlAnnotations.doc(value="Allows to define in a species, model or experiment a new action that can be called elsewhere.", usages={@GamlAnnotations.usage(value="The simplest syntax to define an action that does not take any parameter and does not return anything is:", examples={@GamlAnnotations.example(value="action simple_action {", isExecutable=false), @GamlAnnotations.example(value="   // [set of statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="If the action needs some parameters, they can be specified betwee, braquets after the identifier of the action:", examples={@GamlAnnotations.example(value="action action_parameters(int i, string s){", isExecutable=false), @GamlAnnotations.example(value="   // [set of statements using i and s]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="If the action returns any value, the returned type should be used instead of the \"action\" keyword. A return statement inside the body of the action statement is mandatory.", examples={@GamlAnnotations.example(value="int action_return_val(int i, string s){", isExecutable=false), @GamlAnnotations.example(value="   // [set of statements using i and s]", isExecutable=false), @GamlAnnotations.example(value="   return i + i;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="If virtual: is true, then the action is abstract, which means that the action is defined without body. A species containing at least one abstract action is abstract. Agents of this species cannot be created. The common use of an abstract action is to define an action that can be used by all its sub-species, which should redefine all abstract actions and implements its body.", examples={@GamlAnnotations.example(value="species parent_species {", isExecutable=false), @GamlAnnotations.example(value="   int virtual_action(int i, string s);", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="species children parent: parent_species {", isExecutable=false), @GamlAnnotations.example(value="   int virtual_action(int i, string s) {", isExecutable=false), @GamlAnnotations.example(value="      return i + i;", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"do"})
@validator(value=ActionValidator.class)
@serializer(value=ActionSerializer.class)
public class ActionStatement
extends AbstractStatementSequenceWithArgs {
    Arguments formalArgs = new Arguments();

    public ActionStatement(IDescription iDescription) {
        super(iDescription);
        if (this.hasFacet("name")) {
            this.name = this.getLiteral("name");
        }
    }

    @Override
    public void leaveScope(IScope iScope) {
        iScope.getAndClearReturnStatus();
        super.leaveScope(iScope);
    }

    @Override
    public void setRuntimeArgs(IScope iScope, Arguments arguments) {
        super.setRuntimeArgs(iScope, arguments);
        ((Arguments)this.actualArgs.get()).complementWith(this.formalArgs);
    }

    @Override
    public void setFormalArgs(Arguments arguments) {
        this.formalArgs.putAll(arguments);
    }

    @Override
    public void dispose() {
        this.formalArgs.dispose();
        super.dispose();
    }

    public static class ActionSerializer
    extends SymbolSerializer.StatementSerializer {
        @Override
        protected String serializeFacetValue(SymbolDescription symbolDescription, String string, boolean bl) {
            if ("type".equals(string)) {
                return null;
            }
            return super.serializeFacetValue(symbolDescription, string, bl);
        }

        @Override
        protected void serializeArg(IDescription iDescription, IDescription iDescription2, StringBuilder stringBuilder, boolean bl) {
            String string = iDescription2.getLitteral("name");
            IExpressionDescription iExpressionDescription = iDescription2.getFacet("type");
            IExpressionDescription iExpressionDescription2 = iDescription2.getFacet("default");
            stringBuilder.append(iExpressionDescription == null ? "unknown" : iExpressionDescription.serializeToGaml(bl)).append(" ").append(string);
            if (iExpressionDescription2 != null) {
                stringBuilder.append(" <- ").append(iExpressionDescription2.serializeToGaml(bl));
            }
        }

        @Override
        protected void serializeKeyword(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            String string = symbolDescription.getGamlType().serializeToGaml(bl);
            if ("unknown".equals(string)) {
                string = "action";
            }
            stringBuilder.append(string).append(" ");
        }
    }

    public static class ActionValidator
    implements IDescriptionValidator<IDescription> {
        @Override
        public void validate(IDescription iDescription) {
            if (IDescriptionValidator.Assert.nameIsValid(iDescription)) {
                this.assertReturnedValueIsOk((ActionDescription)iDescription);
            }
        }

        private void assertReturnedValueIsOk(ActionDescription actionDescription) {
            IType<?> iType = actionDescription.getGamlType();
            if (iType == Types.NO_TYPE) {
                return;
            }
            Throwable throwable = null;
            Object var4_5 = null;
            try (Collector.AsOrderedSet<StatementDescription> asOrderedSet = Collector.getOrderedSet();){
                IDescription.DescriptionVisitor descriptionVisitor = iDescription -> {
                    if ("return".equals(iDescription.getKeyword())) {
                        asOrderedSet.add((StatementDescription)iDescription);
                    }
                    return true;
                };
                actionDescription.visitOwnChildrenRecursively(descriptionVisitor);
                if (asOrderedSet.isEmpty() && !actionDescription.isAbstract()) {
                    actionDescription.error("Action " + actionDescription.getName() + " must return a result of type " + String.valueOf(iType), "gaml.missing.return.issue");
                    return;
                }
                for (StatementDescription statementDescription : asOrderedSet) {
                    IExpression iExpression = statementDescription.getFacetExpr("value");
                    if (iExpression == null) continue;
                    if (iExpression.equals(IExpressionFactory.NIL_EXPR)) {
                        if (iType.getDefault() == null) continue;
                        statementDescription.error("'nil' is not an acceptable return value. A valid " + String.valueOf(iType) + " is expected instead.", "gaml.wrong.type.issue", "value", new String[0]);
                        continue;
                    }
                    IType<?> iType2 = iExpression.getGamlType();
                    if (!iType2.isTranslatableInto(iType)) {
                        statementDescription.error("Action " + actionDescription.getName() + " must return a result of type " + String.valueOf(iType) + " (and not " + String.valueOf(iType2) + ")", "gaml.casting.issue", "value", iType.toString());
                        continue;
                    }
                    if (!Types.intFloatCase(iType2, iType) && !Types.intFloatCase(iType2.getContentType(), iType.getContentType())) continue;
                    statementDescription.warning("The returned value (of type " + String.valueOf(iType2) + ") will be casted to " + String.valueOf(iType), "gaml.wrong.type.issue", "value", new String[0]);
                    statementDescription.setFacet("value", GAML.getExpressionFactory().createAs((IDescription)actionDescription.getSpeciesContext(), iExpression, GAML.getExpressionFactory().createTypeExpression(iType)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

