/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Rotation3D;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaPair;
import gama.core.util.IList;
import gama.gaml.constants.GamlCoreConstants;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.AttributeHolder;
import gama.gaml.statements.draw.DrawStatement;
import gama.gaml.types.GamaFontType;
import gama.gaml.types.GamaListType;
import gama.gaml.types.Types;
import java.awt.Color;

public class DrawingData
extends AttributeHolder {
    static final GamaColor DEFAULT_BORDER_COLOR = GamaColor.get(Color.BLACK);
    public final AttributeHolder.Attribute<GamaPoint> size = this.create("size", this::castSize, Types.POINT, null);
    public final AttributeHolder.Attribute<Double> depth;
    public final AttributeHolder.Attribute<AxisAngle> rotation;
    public final AttributeHolder.Attribute<GamaPoint> location;
    public final AttributeHolder.Attribute<GamaPoint> anchor;
    public final AttributeHolder.Attribute<Boolean> empty;
    public final AttributeHolder.Attribute<GamaColor> border;
    public final AttributeHolder.Attribute<GamaColor> color;
    public final AttributeHolder.Attribute<GamaFont> font;
    public final AttributeHolder.Attribute<IList> texture;
    public final AttributeHolder.Attribute<Boolean> perspective;
    public final AttributeHolder.Attribute<Double> lineWidth;
    public final AttributeHolder.Attribute<Boolean> lighting = this.create("lighted", Types.BOOL, true);
    public final AttributeHolder.Attribute<Double> precision;

    public DrawingData(DrawStatement drawStatement) {
        super(drawStatement);
        this.depth = this.create("depth", Types.FLOAT, null);
        this.precision = this.create("precision", Types.FLOAT, 0.01);
        this.rotation = this.create("rotate", this::castRotation, Types.NO_TYPE, null);
        this.anchor = this.create("anchor", this::castAnchor, Types.POINT, GamlCoreConstants.bottom_left);
        this.location = this.create("at", Types.POINT, null);
        this.empty = this.create("wireframe", Types.BOOL, false);
        this.border = this.create("border", this::castBorder, Types.COLOR, null);
        this.color = this.create("color", this::castColor, Types.COLOR, null);
        this.font = this.create("font", Types.FONT, GamaFontType.DEFAULT_DISPLAY_FONT.getValue());
        this.texture = this.create("texture", this::castTexture, Types.LIST, null);
        this.perspective = this.create("perspective", Types.BOOL, true);
        this.lineWidth = this.create("width", Types.FLOAT, GamaPreferences.Displays.CORE_LINE_WIDTH.getValue());
    }

    private GamaPoint castSize(IScope iScope, IExpression iExpression) throws GamaRuntimeException {
        if (iExpression.getGamlType().isNumber()) {
            double d = Cast.asFloat(iScope, iExpression.value(iScope));
            return new GamaPoint(d, d, 0.0);
        }
        return (GamaPoint)iExpression.value(iScope);
    }

    private GamaPoint constCastSize(IExpression iExpression) {
        if (iExpression.getGamlType().isNumber()) {
            double d = Cast.asFloat(null, iExpression.getConstValue());
            return new GamaPoint(d, d, 0.0);
        }
        return (GamaPoint)iExpression.getConstValue();
    }

    private AxisAngle castRotation(IScope iScope, IExpression iExpression) throws GamaRuntimeException {
        if (iExpression.getGamlType().getGamlType() == Types.PAIR) {
            GamaPair gamaPair = Cast.asPair(iScope, iExpression.value(iScope), true);
            return new AxisAngle(Cast.asPoint(iScope, gamaPair.value), Cast.asFloat(iScope, gamaPair.key));
        }
        return new AxisAngle(Rotation3D.PLUS_K, Cast.asFloat(iScope, iExpression.value(iScope)));
    }

    private AxisAngle constCastRotation(IExpression iExpression) throws GamaRuntimeException {
        if (iExpression.getGamlType().getGamlType() == Types.PAIR) {
            GamaPair gamaPair = Cast.asPair(null, iExpression.getConstValue(), true);
            return new AxisAngle(Cast.asPoint(null, gamaPair.value), Cast.asFloat(null, gamaPair.key));
        }
        return new AxisAngle(Rotation3D.PLUS_K, Cast.asFloat(null, iExpression.getConstValue()));
    }

    private GamaPoint castAnchor(IScope iScope, IExpression iExpression) throws GamaRuntimeException {
        GamaPoint gamaPoint = Cast.asPoint(iScope, iExpression.value(iScope));
        gamaPoint.x = Math.min(1.0, Math.max(gamaPoint.x, 0.0));
        gamaPoint.y = Math.min(1.0, Math.max(gamaPoint.y, 0.0));
        return gamaPoint;
    }

    private GamaPoint constCastAnchor(IExpression iExpression) throws GamaRuntimeException {
        GamaPoint gamaPoint = Cast.asPoint(null, iExpression.getConstValue());
        gamaPoint.x = Math.min(1.0, Math.max(gamaPoint.x, 0.0));
        gamaPoint.y = Math.min(1.0, Math.max(gamaPoint.y, 0.0));
        return gamaPoint;
    }

    private IList castTexture(IScope iScope, IExpression iExpression) throws GamaRuntimeException {
        if (iExpression.getGamlType().getGamlType() == Types.LIST) {
            return GamaListType.staticCast(iScope, iExpression.value(iScope), Types.STRING, false);
        }
        return GamaListFactory.wrap(Types.NO_TYPE, iExpression.value(iScope));
    }

    private IList constCastTexture(IExpression iExpression) throws GamaRuntimeException {
        if (iExpression.getGamlType().getGamlType() == Types.LIST) {
            return GamaListType.staticCast(null, iExpression.getConstValue(), Types.STRING, false);
        }
        return GamaListFactory.wrap(Types.NO_TYPE, iExpression.getConstValue());
    }

    private GamaColor constCastColor(IExpression iExpression) {
        return switch (iExpression.getGamlType().id()) {
            case 6 -> Cast.asColor(null, iExpression.getConstValue());
            default -> null;
        };
    }

    private GamaColor constCastBorder(IExpression iExpression) {
        if (iExpression.getGamlType() != Types.BOOL) {
            return (GamaColor)iExpression.getConstValue();
        }
        boolean bl = (Boolean)iExpression.getConstValue();
        if (bl) {
            return DEFAULT_BORDER_COLOR;
        }
        return null;
    }

    private GamaColor castColor(IScope iScope, IExpression iExpression) {
        return switch (iExpression.getGamlType().id()) {
            case 6 -> Cast.asColor(iScope, iExpression.value(iScope));
            default -> null;
        };
    }

    private GamaColor castBorder(IScope iScope, IExpression iExpression) {
        if (iExpression.getGamlType() != Types.BOOL) {
            return (GamaColor)iExpression.value(iScope);
        }
        boolean bl = Cast.asBool(iScope, iExpression.value(iScope));
        if (bl) {
            return DEFAULT_BORDER_COLOR;
        }
        return null;
    }

    public GamaPoint getLocation() {
        return this.location.get() == null ? null : this.location.get();
    }

    public GamaPoint getAnchor() {
        return this.anchor.get() == null ? null : this.anchor.get();
    }
}

