/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.interfaces;

import java.util.concurrent.Semaphore;

public class GeneralSynchronizer {
    final Semaphore semaphore;
    int max;

    public static GeneralSynchronizer withInitialPermits(int n) {
        return GeneralSynchronizer.withInitialAndMaxPermits(n, Integer.MAX_VALUE);
    }

    public static GeneralSynchronizer withInitialAndMaxPermits(int n, int n2) {
        return new GeneralSynchronizer(n, n2);
    }

    private GeneralSynchronizer(int n, int n2) {
        this.semaphore = new Semaphore(n);
        this.max = n2;
    }

    public void release() {
        if (this.semaphore.availablePermits() >= this.max) {
            return;
        }
        this.semaphore.release();
    }

    public void acquire() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void release(int n) {
        int n2 = this.semaphore.availablePermits();
        if (n2 >= this.max) {
            return;
        }
        this.semaphore.release(Math.min(this.max - n2, n));
    }

    public void acquire(int n) {
        try {
            this.semaphore.acquire(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

