/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.util;

import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.util.random.IGamaRNG;
import gama.core.util.random.JavaRNG;
import gama.core.util.random.MersenneTwisterRNG;
import gama.core.util.random.ParallelMersenneTwisterRNG;
import gama.core.util.random.ThreadLocalRNG;
import gama.gaml.operators.Maths;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class RandomUtils {
    public static final String DOC = "The random number generator to use. Four different ones are at the disposal of the modeler: 'mersenne' represents the default generator, based on the Mersenne-Twister algorithm. Very reliable, fast and deterministic (that is, using the same seed and the same sequence of calls, it will return the same stream of pseudo-random numbers). This algorithm is however not safe to use in simulations where agents can behave in parallel; 'threaded' is a very fast generator, based on the DotMix algorithm, that can be safely used in parallel simulations as it creates one instance per thread. However, determinism cannot be guaranteed and this algorithm does not accept a seed as each instance will compute its own;'parallel' is a version of the Mersenne-Twister algorithm that can be safely used in parallel simulations by preventing a concurrent access to its internal state. Determinism is guaranteed (in terms of generation, but not in terms of execution, as the sequence in which the threads will access it cannot be determined) and it performs a bit slower than its base version.'java' invokes the standard generator provided by the JDK, deterministic and thread-safe, albeit slower than all the other ones";
    private static final SecureRandom SEED_SOURCE = new SecureRandom();
    protected Double seed;
    private String generatorName;
    private IGamaRNG generator;

    public RandomUtils(Double d, String string) {
        this.setSeed(d, false);
        this.setGenerator(string, true);
    }

    public RandomUtils(String string) {
        this(GamaPreferences.External.CORE_SEED_DEFINED.getValue() != false ? GamaPreferences.External.CORE_SEED.getValue() : null, string);
    }

    public RandomUtils() {
        this(GamaPreferences.External.CORE_RNG.getValue());
    }

    private void initGenerator() {
        this.generator = switch (Generators.get(this.generatorName)) {
            case Generators.JAVA -> new JavaRNG(this);
            case Generators.THREADED -> new ThreadLocalRNG(this);
            case Generators.PARALLEL -> new ParallelMersenneTwisterRNG(this);
            default -> new MersenneTwisterRNG(this);
        };
    }

    public void setUsage(Integer n) {
        this.generator.setUsage(n);
    }

    public Integer getUsage() {
        return this.generator.getUsage();
    }

    public double createGaussian(double d, double d2) {
        return this.generator.nextGaussian() * d2 + d;
    }

    public byte[] generateSeed(int n) {
        Double d = this.seed;
        if (d < 0.0) {
            d = d * -1.0;
        }
        if (d < 1.0) {
            d = d * 9.223372036854776E18;
        }
        long l = Double.doubleToRawLongBits(d);
        byte[] byArray = new byte[n];
        switch (n) {
            case 4: {
                int n2 = 0;
                while (n2 < 4) {
                    byArray[n2] = (byte)(l & 0xFFL);
                    l >>= 8;
                    ++n2;
                }
                break;
            }
            case 8: {
                int n3 = 0;
                while (n3 < 8) {
                    byArray[n3] = (byte)l;
                    l >>= 8;
                    ++n3;
                }
                break;
            }
            case 16: {
                int n4 = 0;
                while (n4 < 8) {
                    byte by = (byte)(l & 0xFFL);
                    byArray[n4 + 8] = by;
                    byArray[n4] = by;
                    l >>= 8;
                    ++n4;
                }
                break;
            }
        }
        return byArray;
    }

    public void setSeed(Double d, boolean bl) {
        this.seed = d;
        if (this.seed == null) {
            this.seed = SEED_SOURCE.nextDouble();
        }
        if (bl) {
            this.initGenerator();
        }
    }

    public void setGenerator(String string, boolean bl) {
        this.generatorName = string;
        if (bl) {
            this.initGenerator();
        }
    }

    public void shuffleInPlace(Collection collection) {
        if (collection == null) {
            return;
        }
        int n = collection.size();
        if (n < 2) {
            return;
        }
        Object[] objectArray = collection.toArray(new Object[n]);
        collection.clear();
        this.shuffleInPlace(objectArray);
        collection.addAll(Arrays.asList(objectArray));
    }

    public <T> void shuffleInPlace(T[] TArray) {
        int n = 0;
        while (n < TArray.length) {
            int n2 = this.between(n, TArray.length - 1);
            T t = TArray[n];
            TArray[n] = TArray[n2];
            TArray[n2] = t;
            ++n;
        }
    }

    public void shuffleInPlace(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = this.between(n, dArray.length - 1);
            double d = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = d;
            ++n;
        }
    }

    public void shuffleInPlace(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = this.between(n, nArray.length - 1);
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
            ++n;
        }
    }

    public void shuffleInPlace(short[] sArray) {
        int n = 0;
        while (n < sArray.length) {
            int n2 = this.between(n, sArray.length - 1);
            short s = sArray[n];
            sArray[n] = sArray[n2];
            sArray[n2] = s;
            ++n;
        }
    }

    public void shuffleInPlace(char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            int n2 = this.between(n, cArray.length - 1);
            char c = cArray[n];
            cArray[n] = cArray[n2];
            cArray[n2] = c;
            ++n;
        }
    }

    public void shuffleInPlace(List list) {
        int n = list.size();
        while (n > 1) {
            int n2 = n - 1;
            int n3 = this.between(0, n - 1);
            Object e = list.get(n2);
            list.set(n2, list.get(n3));
            list.set(n3, e);
            --n;
        }
    }

    public String shuffle(String string) {
        char[] cArray = string.toCharArray();
        this.shuffleInPlace(cArray);
        return String.copyValueOf(cArray);
    }

    public int between(int n, int n2) {
        return (int)((long)n + (long)((double)(1L + (long)n2 - (long)n) * this.next()));
    }

    public double between(double d, double d2) {
        return d + (d2 + Double.MIN_VALUE - d) * this.next();
    }

    public int between(int n, int n2, int n3) {
        int n4 = (n2 - n) / n3;
        return n + this.between(0, n4) * n3;
    }

    public double between(double d, double d2, double d3) {
        double d4 = this.between(d, d2);
        int n = (int)((d4 - d) / d3);
        double d5 = Math.min(d2, d + ((double)n + 1.0) * d3);
        double d6 = d + (double)n * d3;
        int n2 = BigDecimal.valueOf(d3).scale() + 5;
        double d7 = Maths.round(d5, n2);
        double d8 = Maths.round(d6, n2);
        return d4 - d8 < d7 - d4 ? d8 : d7;
    }

    public double next() {
        return this.generator.nextDouble();
    }

    public Double getSeed() {
        return this.seed;
    }

    public String getRngName() {
        return this.generatorName;
    }

    public Random getGenerator() {
        return this.generator.getRandomGenerator();
    }

    public <K> K oneOf(Collection<K> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return (K)this.oneOf(collection.toArray());
    }

    public <K> K oneOf(List<K> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(this.between(0, list.size() - 1));
    }

    public <K> K oneOf(K[] KArray) {
        if (KArray == null || KArray.length == 0) {
            return null;
        }
        return KArray[this.between(0, KArray.length - 1)];
    }

    public int oneOf(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return -1;
        }
        return nArray[this.between(0, nArray.length - 1)];
    }

    public double oneOf(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return -1.0;
        }
        return dArray[this.between(0, dArray.length - 1)];
    }

    public boolean oneOf(boolean[] blArray) {
        if (blArray == null || blArray.length == 0) {
            return false;
        }
        return blArray[this.between(0, blArray.length - 1)];
    }

    public GamaPoint between(GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3) {
        double d = this.between(gamaPoint.x, gamaPoint2.x, gamaPoint3.x);
        double d2 = this.between(gamaPoint.y, gamaPoint2.y, gamaPoint3.y);
        double d3 = this.between(gamaPoint.z, gamaPoint2.z, gamaPoint3.z);
        return new GamaPoint(d, d2, d3);
    }

    public static enum Generators {
        MERSENNE("mersenne", " represents the default generator, based on the Mersenne-Twister algorithm. Very reliable, fast and deterministic (that is, using the same seed and the same sequence of calls, it will return the same stream of pseudo-random numbers). This algorithm is however not safe to use in simulations where agents can behave in parallel; "),
        PARALLEL("parallel", " is a version of the Mersenne-Twister algorithm that can be safely used in parallel simulations by preventing a concurrent access to its internal state. Determinism is guaranteed (in terms of generation, but not in terms of execution, as the sequence in which the threads will access it cannot be determined) and it performs a bit slower than its base version; "),
        JAVA("java", " invokes the standard generator provided by the JDK, deterministic and thread-safe, albeit slower than all the other ones; "),
        THREADED("threaded", " is a very fast generator, based on the DotMix algorithm, that can be safely used in parallel simulations as it creates one instance per thread. However, determinism cannot be guaranteed and this algorithm does not accept a seed as each instance will compute its own; ");

        private String name;

        private Generators(String string2, String string3) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public static Generators get(String string) {
            return Arrays.stream(Generators.values()).filter(generators -> generators.name.equals(string)).findFirst().orElse(null);
        }

        public static List<String> names() {
            return Arrays.stream(Generators.values()).map(generators -> generators.name).toList();
        }
    }
}

