/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.continuous;

import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.CompoundSpatialIndex;
import gama.core.metamodel.topology.ISpatialIndex;
import gama.core.metamodel.topology.continuous.ContinuousTopology;
import gama.core.runtime.IScope;

public class RootTopology
extends ContinuousTopology {
    private final ISpatialIndex.Compound spatialIndex;
    private final boolean isTorus;

    public RootTopology(IScope iScope, IShape iShape, boolean bl, boolean bl2) {
        super(iScope, iShape);
        Envelope3D envelope3D = iShape.getEnvelope();
        this.spatialIndex = new CompoundSpatialIndex(envelope3D, bl2);
        this.isTorus = bl;
        this.root = this;
    }

    @Override
    public ISpatialIndex getSpatialIndex() {
        return this.spatialIndex;
    }

    public void updateEnvironment(IScope iScope, IShape iShape, boolean bl) {
        this.spatialIndex.update(iScope, iShape.getEnvelope(), bl);
    }

    @Override
    public boolean isTorus() {
        return this.isTorus;
    }

    @Override
    public void setRoot(IScope iScope, RootTopology rootTopology) {
    }

    public void mergeWith(RootTopology rootTopology) {
        this.spatialIndex.mergeWith(rootTopology.spatialIndex);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.spatialIndex != null) {
            this.spatialIndex.dispose();
        }
    }

    public void remove(IPopulation<? extends IAgent> iPopulation) {
        if (this.spatialIndex != null) {
            this.spatialIndex.remove(iPopulation.getSpecies());
        }
    }
}

