/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AspectStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import java.util.ArrayList;

@GamlAnnotations.inside(symbols={"display"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="value", type={16}, of=11, optional=false, doc={@GamlAnnotations.doc(value="the set of agents to display")}), @GamlAnnotations.facet(name="rotate", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Defines the angle of rotation of this layer, in degrees, around the z-axis.")}), @GamlAnnotations.facet(name="trace", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="Allows to aggregate the visualization of agents at each timestep on the display. Default is false. If set to an int value, only the last n-th steps will be visualized. If set to true, no limit of timesteps is applied. ")}), @GamlAnnotations.facet(name="selectable", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates whether the agents present on this layer are selectable by the user. Default is true")}), @GamlAnnotations.facet(name="fading", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Used in conjunction with 'trace:', allows to apply a fading effect to the previous traces. Default is false")}), @GamlAnnotations.facet(name="position", type={7}, optional=true, doc={@GamlAnnotations.doc(value="position of the upper-left corner of the layer. Note that if coordinates are in [0,1[, the position is relative to the size of the environment (e.g. {0.5,0.5} refers to the middle of the display) whereas it is absolute when coordinates are greater than 1 for x and y. The z-ordinate can only be defined between 0 and 1. The position can only be a 3D point {0.5, 0.5, 0.5}, the last coordinate specifying the elevation of the layer. In case of negative value OpenGl will position the layer out of the environment.")}), @GamlAnnotations.facet(name="size", type={7}, optional=true, doc={@GamlAnnotations.doc(value="extent of the layer in the screen from its position. Coordinates in [0,1[ are treated as percentages of the total surface, while coordinates > 1 are treated as absolute sizes in model units (i.e. considering the model occupies the entire view). Like in 'position', an elevation can be provided with the z coordinate, allowing to scale the layer in the 3 directions ")}), @GamlAnnotations.facet(name="transparency", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the transparency level of the layer (between 0 -- opaque -- and 1 -- fully transparent)")}), @GamlAnnotations.facet(name="visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Defines whether this layer is visible or not")}), @GamlAnnotations.facet(name="name", type={-200}, optional=true, doc={@GamlAnnotations.doc(value="Human readable title of the layer")}), @GamlAnnotations.facet(name="aspect", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the name of the aspect that should be used to display the species")}), @GamlAnnotations.facet(name="refresh", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(openGL only) specify whether the display of the species is refreshed. (true by default, useful in case of agents that do not move)")})}, omissible="name")
@validator(value=AgentLayerValidator.class)
@GamlAnnotations.doc(value="`agents` allows the modeler to display only the agents that fulfill a given condition.", usages={@GamlAnnotations.usage(value="The general syntax is:", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   agents layer_name value: expression [additional options];", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="For instance, in a segregation model, `agents` will only display unhappy agents:", examples={@GamlAnnotations.example(value="display Segregation {", isExecutable=false), @GamlAnnotations.example(value="   agents agentDisappear value: people as list where (each.is_happy = false) aspect: with_group_color;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"display", "chart", "event", "graphics", "display_grid", "image_layer", "overlay", "species_layer"})
public class AgentLayerStatement
extends AbstractLayerStatement {
    private IExpression agentsExpr;
    protected String constantAspectName = null;
    protected IExpression aspectExpr;
    private IExecutable aspect = null;

    public AgentLayerStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        this.setAgentsExpr(this.getFacet("value"));
        if (this.name == null && this.agentsExpr != null) {
            this.setName(this.agentsExpr.serializeToGaml(false));
        }
        this.aspectExpr = this.getFacet("aspect");
        if (this.aspectExpr != null && this.aspectExpr.isConst()) {
            this.constantAspectName = this.aspectExpr.literalValue();
        }
    }

    @Override
    public boolean _step(IScope iScope) {
        return true;
    }

    @Override
    public boolean _init(IScope iScope) {
        this.computeAspectName(iScope);
        return true;
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        return ILayerStatement.LayerType.AGENTS;
    }

    public void computeAspectName(IScope iScope) throws GamaRuntimeException {
        String string = this.constantAspectName == null ? (this.aspectExpr == null ? "default" : Cast.asString(iScope, this.aspectExpr.value(iScope))) : this.constantAspectName;
        this.setAspect(string);
    }

    public void setAspect(String string) {
        this.constantAspectName = string;
    }

    public String getAspectName() {
        return this.constantAspectName;
    }

    public void setAgentsExpr(IExpression iExpression) {
        this.agentsExpr = iExpression;
    }

    IExpression getAgentsExpr() {
        return this.agentsExpr;
    }

    public IExecutable getAspect() {
        return this.aspect;
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        ArrayList<IStatement> arrayList = new ArrayList<IStatement>();
        for (ISymbol iDisposable : iterable) {
            if (!(iDisposable instanceof IStatement)) continue;
            arrayList.add((IStatement)iDisposable);
        }
        if (!arrayList.isEmpty()) {
            this.constantAspectName = "inline";
            IDescription iDescription = DescriptionFactory.create("aspect", this.getDescription(), "name", "inline");
            this.aspect = new AspectStatement(iDescription);
            ((AspectStatement)this.aspect).setChildren(arrayList);
        }
    }

    public static class AgentLayerValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            IExpressionDescription iExpressionDescription = statementDescription.getFacet("value");
            SpeciesDescription speciesDescription = null;
            if (iExpressionDescription == null || iExpressionDescription.getExpression() == null) {
                return;
            }
            speciesDescription = iExpressionDescription.getExpression().getGamlType().getContentType().getSpecies();
            if (speciesDescription == null) {
                return;
            }
            iExpressionDescription = statementDescription.getFacet("aspect");
            if (iExpressionDescription != null) {
                String string = statementDescription.getLitteral("aspect");
                if (speciesDescription.getAspect(string) != null) {
                    iExpressionDescription.compileAsLabel();
                } else if (string != null && !"default".equals(string)) {
                    statementDescription.error(string + " is not the name of an aspect of " + speciesDescription.getName(), "gaml.general.issue", statementDescription.getFacet("aspect").getTarget(), new String[0]);
                }
            }
        }
    }
}

